/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BinarySequence;
import jalview.Format;
import jalview.Matrix;
import jalview.Sequence;
import java.io.PrintStream;

public class PCA
implements Runnable {
    Matrix m;
    Matrix symm;
    Matrix m2;
    double[] eigenvalue;
    Matrix eigenvector;

    public PCA(Matrix matrix) {
        this.m = matrix;
    }

    public PCA(Sequence[] sequenceArray) {
        Runtime runtime = Runtime.getRuntime();
        BinarySequence[] binarySequenceArray = new BinarySequence[sequenceArray.length];
        int n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            binarySequenceArray[n] = new BinarySequence(sequenceArray[n]);
            binarySequenceArray[n].encode();
            ++n;
        }
        BinarySequence[] binarySequenceArray2 = new BinarySequence[sequenceArray.length];
        n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            binarySequenceArray2[n] = new BinarySequence(sequenceArray[n]);
            binarySequenceArray2[n].blosumEncode();
            ++n;
        }
        int n2 = 0;
        while (n2 < binarySequenceArray.length && binarySequenceArray[n2] != null) {
            ++n2;
        }
        double[][] dArray = new double[n2][binarySequenceArray[0].dbinary.length];
        double[][] dArray2 = new double[n2][binarySequenceArray2[0].dbinary.length];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = binarySequenceArray[n3].dbinary;
            dArray2[n3] = binarySequenceArray2[n3].dbinary;
            ++n3;
        }
        this.m = new Matrix(dArray, n2, binarySequenceArray[0].dbinary.length);
        this.m2 = new Matrix(dArray2, n2, binarySequenceArray2[0].dbinary.length);
        PCA.printMemory(runtime);
    }

    public static void printMemory(Runtime runtime) {
        System.out.println("Free memory = " + runtime.freeMemory());
    }

    public double[] getEigenvector(int n) {
        return this.eigenvector.getColumn(n);
    }

    public double getEigenvalue(int n) {
        return this.eigenvector.d[n];
    }

    public float[][] getComponents(int n, int n2, int n3) {
        return this.getComponents(n, n2, n3, 1.0f);
    }

    public float[][] getComponents(int n, int n2, int n3, float f) {
        float[][] fArray = new float[this.m.rows][3];
        int n4 = 0;
        while (n4 < this.m.rows) {
            fArray[n4][0] = (float)this.component(n4, n) * f;
            fArray[n4][1] = (float)this.component(n4, n2) * f;
            fArray[n4][2] = (float)this.component(n4, n3) * f;
            ++n4;
        }
        return fArray;
    }

    public double[] component(int n) {
        double[] dArray = new double[this.m.rows];
        int n2 = 0;
        while (n2 < this.m.rows) {
            dArray[n2] = this.component(n2, n);
            ++n2;
        }
        return dArray;
    }

    public double component(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.symm.cols) {
            d += this.symm.value[n][n3] * this.eigenvector.value[n3][n2];
            ++n3;
        }
        return d / this.eigenvector.d[n2];
    }

    public void checkEigenvector(int n, PrintStream printStream) {
        printStream.println(" --- Eigenvector " + n + " --- ");
        double[] dArray = this.eigenvector.getColumn(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            Format.print(printStream, "%15.4f", dArray[n2]);
            ++n2;
        }
        System.out.println();
        double[] dArray2 = this.symm.vectorPostMultiply(dArray);
        System.out.println(" --- symmat * eigenv / lambda --- ");
        if (this.eigenvector.d[n] > 1.0E-4) {
            int n3 = 0;
            while (n3 < dArray2.length) {
                Format.print(System.out, "%15.4f", dArray2[n3] / this.eigenvector.d[n]);
                ++n3;
            }
        }
        System.out.println();
    }

    public void run() {
        Matrix matrix = this.m.transpose();
        this.eigenvector = matrix.preMultiply(this.m2);
        this.symm = this.eigenvector.copy();
        long l = System.currentTimeMillis();
        this.eigenvector.tred();
        long l2 = System.currentTimeMillis();
        l = System.currentTimeMillis();
        this.eigenvector.tqli();
        l2 = System.currentTimeMillis();
    }
}

