<?php
/**
 * StaticLegend
 *
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Model;

use \ArrayAccess;
use \InfluxDB2\ObjectSerializer;

/**
 * StaticLegend Class Doc Comment
 *
 * @category Class
 * @description StaticLegend represents the options specific to the static legend
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class StaticLegend implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StaticLegend';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'colorize_rows' => 'bool',
        'height_ratio' => 'float',
        'show' => 'bool',
        'opacity' => 'float',
        'orientation_threshold' => 'int',
        'value_axis' => 'string',
        'width_ratio' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'colorize_rows' => null,
        'height_ratio' => 'float',
        'show' => null,
        'opacity' => 'float',
        'orientation_threshold' => 'int32',
        'value_axis' => null,
        'width_ratio' => 'float'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'colorize_rows' => 'colorizeRows',
        'height_ratio' => 'heightRatio',
        'show' => 'show',
        'opacity' => 'opacity',
        'orientation_threshold' => 'orientationThreshold',
        'value_axis' => 'valueAxis',
        'width_ratio' => 'widthRatio'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'colorize_rows' => 'setColorizeRows',
        'height_ratio' => 'setHeightRatio',
        'show' => 'setShow',
        'opacity' => 'setOpacity',
        'orientation_threshold' => 'setOrientationThreshold',
        'value_axis' => 'setValueAxis',
        'width_ratio' => 'setWidthRatio'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'colorize_rows' => 'getColorizeRows',
        'height_ratio' => 'getHeightRatio',
        'show' => 'getShow',
        'opacity' => 'getOpacity',
        'orientation_threshold' => 'getOrientationThreshold',
        'value_axis' => 'getValueAxis',
        'width_ratio' => 'getWidthRatio'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['colorize_rows'] = isset($data['colorize_rows']) ? $data['colorize_rows'] : null;
        $this->container['height_ratio'] = isset($data['height_ratio']) ? $data['height_ratio'] : null;
        $this->container['show'] = isset($data['show']) ? $data['show'] : null;
        $this->container['opacity'] = isset($data['opacity']) ? $data['opacity'] : null;
        $this->container['orientation_threshold'] = isset($data['orientation_threshold']) ? $data['orientation_threshold'] : null;
        $this->container['value_axis'] = isset($data['value_axis']) ? $data['value_axis'] : null;
        $this->container['width_ratio'] = isset($data['width_ratio']) ? $data['width_ratio'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets colorize_rows
     *
     * @return bool|null
     */
    public function getColorizeRows()
    {
        return $this->container['colorize_rows'];
    }

    /**
     * Sets colorize_rows
     *
     * @param bool|null $colorize_rows colorize_rows
     *
     * @return $this
     */
    public function setColorizeRows($colorize_rows)
    {
        $this->container['colorize_rows'] = $colorize_rows;

        return $this;
    }

    /**
     * Gets height_ratio
     *
     * @return float|null
     */
    public function getHeightRatio()
    {
        return $this->container['height_ratio'];
    }

    /**
     * Sets height_ratio
     *
     * @param float|null $height_ratio height_ratio
     *
     * @return $this
     */
    public function setHeightRatio($height_ratio)
    {
        $this->container['height_ratio'] = $height_ratio;

        return $this;
    }

    /**
     * Gets show
     *
     * @return bool|null
     */
    public function getShow()
    {
        return $this->container['show'];
    }

    /**
     * Sets show
     *
     * @param bool|null $show show
     *
     * @return $this
     */
    public function setShow($show)
    {
        $this->container['show'] = $show;

        return $this;
    }

    /**
     * Gets opacity
     *
     * @return float|null
     */
    public function getOpacity()
    {
        return $this->container['opacity'];
    }

    /**
     * Sets opacity
     *
     * @param float|null $opacity opacity
     *
     * @return $this
     */
    public function setOpacity($opacity)
    {
        $this->container['opacity'] = $opacity;

        return $this;
    }

    /**
     * Gets orientation_threshold
     *
     * @return int|null
     */
    public function getOrientationThreshold()
    {
        return $this->container['orientation_threshold'];
    }

    /**
     * Sets orientation_threshold
     *
     * @param int|null $orientation_threshold orientation_threshold
     *
     * @return $this
     */
    public function setOrientationThreshold($orientation_threshold)
    {
        $this->container['orientation_threshold'] = $orientation_threshold;

        return $this;
    }

    /**
     * Gets value_axis
     *
     * @return string|null
     */
    public function getValueAxis()
    {
        return $this->container['value_axis'];
    }

    /**
     * Sets value_axis
     *
     * @param string|null $value_axis value_axis
     *
     * @return $this
     */
    public function setValueAxis($value_axis)
    {
        $this->container['value_axis'] = $value_axis;

        return $this;
    }

    /**
     * Gets width_ratio
     *
     * @return float|null
     */
    public function getWidthRatio()
    {
        return $this->container['width_ratio'];
    }

    /**
     * Sets width_ratio
     *
     * @param float|null $width_ratio width_ratio
     *
     * @return $this
     */
    public function setWidthRatio($width_ratio)
    {
        $this->container['width_ratio'] = $width_ratio;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


