/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.ParseIssue;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import io.mola.galimatias.URLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class URLParser {
    private final URL base;
    private final String input;
    private final URL url;
    private final ParseURLState stateOverride;
    private URLParsingSettings settings;
    private int startIdx;
    private int endIdx;
    private int idx;
    private boolean isEOF;
    private int c;

    public URLParser(String input) {
        this(null, input, null, null);
    }

    public URLParser(URL base, String input) {
        this(base, input, null, null);
    }

    public URLParser(String input, URL url, ParseURLState stateOverride) {
        this(null, input, url, stateOverride);
    }

    public URLParser(URL base, String input, URL url, ParseURLState stateOverride) {
        this.base = base;
        this.input = input;
        this.url = url;
        this.stateOverride = stateOverride;
        this.settings = URLParsingSettings.create();
    }

    public URLParser settings(URLParsingSettings settings) {
        this.settings = settings;
        return this;
    }

    private void setIdx(int i) {
        this.idx = i;
        this.isEOF = i >= this.endIdx;
        this.c = this.isEOF || this.idx < this.startIdx ? 0 : this.input.codePointAt(i);
    }

    private void incIdx() {
        int charCount = Character.charCount(this.c);
        this.setIdx(this.idx + charCount);
    }

    private void decrIdx() {
        if (this.idx <= this.startIdx) {
            this.setIdx(this.idx - 1);
            return;
        }
        int charCount = Character.charCount(this.input.codePointBefore(this.idx));
        this.setIdx(this.idx - charCount);
    }

    private char at(int i) {
        if (i >= this.endIdx) {
            return '\u0000';
        }
        return this.input.charAt(i);
    }

    private void handleError(GalimatiasParseException parseException) throws GalimatiasParseException {
        this.settings.errorHandler().error(parseException);
    }

    private void handleError(String message) throws GalimatiasParseException {
        this.handleError(new GalimatiasParseException(message, this.idx));
    }

    private void handleFatalError(GalimatiasParseException parseException) throws GalimatiasParseException {
        this.settings.errorHandler().fatalError(parseException);
        throw parseException;
    }

    private void handleFatalError(String message) throws GalimatiasParseException {
        this.handleFatalError(new GalimatiasParseException(message, this.idx));
    }

    private void handleInvalidPercentEncodingError() throws GalimatiasParseException {
        this.handleError(GalimatiasParseException.builder().withMessage("Percentage (\"%\") is not followed by two hexadecimal digits").withParseIssue(ParseIssue.INVALID_PERCENT_ENCODING).withPosition(this.idx).build());
    }

    private void handleBackslashAsDelimiterError() throws GalimatiasParseException {
        this.handleError(GalimatiasParseException.builder().withMessage("Backslash (\"\\\") used as path segment delimiter").withParseIssue(ParseIssue.BACKSLASH_AS_DELIMITER).withPosition(this.idx).build());
    }

    private void handleIllegalWhitespaceError() throws GalimatiasParseException {
        this.handleError(GalimatiasParseException.builder().withMessage("Tab, new line or carriage return found").withParseIssue(ParseIssue.ILLEGAL_WHITESPACE).withPosition(this.idx).build());
    }

    private void handleIllegalCharacterError(String message, int codePoint) throws GalimatiasParseException {
        message = codePoint == 32 ? message + ": space is not allowed" : (codePoint == 9 ? message + ": tab is not allowed" : (codePoint == 10 ? message + ": line break is not allowed" : (codePoint == 13 ? message + ": carriage return is not allowed" : message + ": \u201c" + new String(Character.toChars(codePoint)) + "\u201d is not allowed")));
        this.handleError(GalimatiasParseException.builder().withMessage(message).withParseIssue(ParseIssue.ILLEGAL_CHARACTER).withPosition(this.idx).build());
    }

    private void handleFatalMissingSchemeError() throws GalimatiasParseException {
        this.handleFatalError(GalimatiasParseException.builder().withMessage("Missing scheme").withPosition(this.idx).withParseIssue(ParseIssue.MISSING_SCHEME).build());
    }

    private void handleFatalIllegalCharacterError(String message, int codePoint) throws GalimatiasParseException {
        message = message + ": \u201c" + new String(Character.toChars(codePoint)) + "\u201d is not allowed";
        this.handleFatalError(GalimatiasParseException.builder().withMessage(message).withParseIssue(ParseIssue.ILLEGAL_CHARACTER).withPosition(this.idx).build());
    }

    private void handleFatalInvalidHostError(Exception exception) throws GalimatiasParseException {
        this.handleFatalError(GalimatiasParseException.builder().withMessage("Invalid host: " + exception.getMessage()).withParseIssue(ParseIssue.INVALID_HOST).withPosition(this.idx).withCause(exception).build());
    }

    public URL parse() throws GalimatiasParseException {
        if (this.input == null) {
            throw new NullPointerException("null input");
        }
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        String encodingOverride = "utf-8";
        String scheme = this.url == null ? null : this.url.scheme();
        StringBuilder schemeData = this.url == null ? new StringBuilder() : new StringBuilder(this.url.schemeData());
        String username = this.url == null ? null : this.url.username();
        String password = this.url == null ? null : this.url.password();
        Host host = this.url == null ? null : this.url.host();
        int port = this.url == null ? -1 : this.url.port();
        boolean relativeFlag = this.url != null && this.url.isHierarchical();
        boolean atFlag = false;
        boolean bracketsFlag = false;
        List<String> pathSegments = this.url == null || this.stateOverride == ParseURLState.RELATIVE_PATH_START ? new ArrayList<String>() : this.url.pathSegments();
        StringBuilder query = this.url == null || this.url.query() == null || this.stateOverride == ParseURLState.QUERY ? null : new StringBuilder(this.url.query());
        StringBuilder fragment = this.url == null || this.url.fragment() == null || this.stateOverride == ParseURLState.FRAGMENT ? null : new StringBuilder(this.url.fragment());
        StringBuilder usernameBuffer = new StringBuilder(buffer.length());
        StringBuilder passwordBuffer = null;
        this.endIdx = this.input.length();
        this.setIdx(this.startIdx);
        while (Character.isWhitespace(this.c)) {
            this.incIdx();
            ++this.startIdx;
        }
        while (this.endIdx > this.startIdx && Character.isWhitespace(this.input.charAt(this.endIdx - 1))) {
            --this.endIdx;
        }
        ParseURLState state = this.stateOverride == null ? ParseURLState.SCHEME_START : this.stateOverride;
        boolean terminate = false;
        while (!terminate && this.idx <= this.endIdx) {
            switch (state.ordinal()) {
                case 0: {
                    if (URLUtils.isASCIIAlpha(this.c)) {
                        buffer.appendCodePoint(Character.toLowerCase(this.c));
                        state = ParseURLState.SCHEME;
                        break;
                    }
                    if (this.stateOverride == null) {
                        state = ParseURLState.NO_SCHEME;
                        this.decrIdx();
                        break;
                    }
                    this.handleFatalError("Scheme must start with alpha character.");
                    break;
                }
                case 1: {
                    if (URLUtils.isASCIIAlphanumeric(this.c) || this.c == 43 || this.c == 45 || this.c == 46) {
                        buffer.appendCodePoint(Character.toLowerCase(this.c));
                        break;
                    }
                    if (this.c == 58) {
                        scheme = buffer.toString();
                        buffer.setLength(0);
                        if (this.stateOverride != null) {
                            terminate = true;
                            break;
                        }
                        relativeFlag = URLUtils.isRelativeScheme(scheme);
                        if ("file".equals(scheme)) {
                            state = ParseURLState.RELATIVE;
                            break;
                        }
                        if (relativeFlag && this.base != null && this.base.scheme().equals(scheme)) {
                            state = ParseURLState.RELATIVE_OR_AUTHORITY;
                            break;
                        }
                        if (relativeFlag) {
                            state = ParseURLState.AUTHORITY_FIRST_SLASH;
                            break;
                        }
                        state = ParseURLState.SCHEME_DATA;
                        break;
                    }
                    if (this.stateOverride == null) {
                        buffer.setLength(0);
                        state = ParseURLState.NO_SCHEME;
                        this.idx = -1;
                        break;
                    }
                    if (this.isEOF) {
                        terminate = true;
                        break;
                    }
                    this.handleFatalIllegalCharacterError("Illegal character in scheme", this.c);
                    break;
                }
                case 2: {
                    if (this.c == 63) {
                        query = new StringBuilder();
                        state = ParseURLState.QUERY;
                        break;
                    }
                    if (this.c == 35) {
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (!this.isEOF && this.c != 37 && !URLUtils.isURLCodePoint(this.c)) {
                        this.handleIllegalCharacterError("Illegal character in scheme data", this.c);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.handleInvalidPercentEncodingError();
                        } else {
                            schemeData.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    if (this.isEOF || this.c == 9 || this.c == 10 || this.c == 13) break;
                    URLParser.utf8PercentEncode(this.c, EncodeSet.SIMPLE, schemeData);
                    break;
                }
                case 3: {
                    if (this.base == null || !URLUtils.isRelativeScheme(this.base.scheme())) {
                        this.handleFatalMissingSchemeError();
                    }
                    state = ParseURLState.RELATIVE;
                    --this.idx;
                    break;
                }
                case 4: {
                    if (this.c == 47 && this.at(this.idx + 1) == '/') {
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        ++this.idx;
                        break;
                    }
                    this.handleError("Relative scheme (" + scheme + ") is not followed by \"://\"");
                    state = ParseURLState.RELATIVE;
                    --this.idx;
                    break;
                }
                case 5: {
                    relativeFlag = true;
                    if (!"file".equals(scheme)) {
                        String string = scheme = this.base == null ? null : this.base.scheme();
                    }
                    if (this.isEOF) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = this.base == null || this.base.query() == null ? null : new StringBuilder(this.base.query());
                        break;
                    }
                    if (this.c == 47 || this.c == 92) {
                        if (this.c == 92) {
                            this.handleBackslashAsDelimiterError();
                        }
                        state = ParseURLState.RELATIVE_SLASH;
                        break;
                    }
                    if (this.c == 63) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = new StringBuilder();
                        state = ParseURLState.QUERY;
                        break;
                    }
                    if (this.c == 35) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = this.base == null || this.base.query() == null ? null : new StringBuilder(this.base.query());
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (!"file".equals(scheme) || !URLUtils.isASCIIAlpha(this.c) || this.at(this.idx + 1) != ':' && this.at(this.idx + 1) != '|' || this.idx + 1 == this.endIdx - 1 || this.idx + 2 < this.endIdx && this.at(this.idx + 2) != '/' && this.at(this.idx + 2) != '\\' && this.at(this.idx + 2) != '?' && this.at(this.idx + 2) != '#') {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        List<Object> list = pathSegments = this.base == null ? new ArrayList() : this.base.pathSegments();
                        if (!pathSegments.isEmpty()) {
                            pathSegments.remove(pathSegments.size() - 1);
                        }
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    --this.idx;
                    break;
                }
                case 6: {
                    if (this.c == 47 || this.c == 92) {
                        if (this.c == 92) {
                            this.handleBackslashAsDelimiterError();
                        }
                        if ("file".equals(scheme)) {
                            state = ParseURLState.FILE_HOST;
                            break;
                        }
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        break;
                    }
                    if (!"file".equals(scheme)) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    this.decrIdx();
                    break;
                }
                case 7: {
                    if (this.c == 47) {
                        state = ParseURLState.AUTHORITY_SECOND_SLASH;
                        break;
                    }
                    this.handleError("Expected a slash (\"/\")");
                    state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                    this.decrIdx();
                    break;
                }
                case 8: {
                    if (this.c == 47) {
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        break;
                    }
                    this.handleError("Expected a slash (\"/\")");
                    state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                    this.decrIdx();
                    break;
                }
                case 9: {
                    if (this.c != 47 && this.c != 92) {
                        state = ParseURLState.AUTHORITY;
                        this.decrIdx();
                        break;
                    }
                    this.handleError("Unexpected slash or backslash");
                    break;
                }
                case 10: {
                    if (this.c == 64) {
                        if (atFlag) {
                            this.handleError("User or password contains an at symbol (\"@\") not percent-encoded");
                            buffer.insert(0, "%40");
                        }
                        atFlag = true;
                        for (int i = 0; i < buffer.codePointCount(0, buffer.length()); ++i) {
                            int otherChar = buffer.codePointAt(i);
                            char startChar = buffer.charAt(i);
                            if (otherChar == 9 || otherChar == 10 || otherChar == 13) {
                                this.handleIllegalWhitespaceError();
                                continue;
                            }
                            if (!URLUtils.isURLCodePoint(startChar) && startChar != '%') {
                                this.handleIllegalCharacterError("Illegal character in user or password", otherChar);
                            }
                            if (otherChar == 37) {
                                if (i + 2 >= buffer.length() || !URLUtils.isASCIIHexDigit(buffer.charAt(i + 1)) || !URLUtils.isASCIIHexDigit(buffer.charAt(i + 2))) {
                                    this.handleInvalidPercentEncodingError();
                                } else if (URLUtils.isASCIIHexDigit(buffer.charAt(i + 1)) && URLUtils.isASCIIHexDigit(buffer.charAt(i + 2))) {
                                    buffer.setCharAt(i + 1, Character.toUpperCase(buffer.charAt(i + 1)));
                                    buffer.setCharAt(i + 2, Character.toUpperCase(buffer.charAt(i + 2)));
                                }
                            }
                            if (otherChar == 58 && passwordBuffer == null) {
                                passwordBuffer = new StringBuilder(buffer.length() - i);
                                continue;
                            }
                            if (passwordBuffer != null) {
                                URLParser.utf8PercentEncode(otherChar, EncodeSet.DEFAULT, passwordBuffer);
                                continue;
                            }
                            URLParser.utf8PercentEncode(otherChar, EncodeSet.DEFAULT, usernameBuffer);
                        }
                        buffer.setLength(0);
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        this.setIdx(this.idx - buffer.length() - 1);
                        if (atFlag) {
                            username = usernameBuffer.toString();
                            if (passwordBuffer != null) {
                                password = passwordBuffer.toString();
                            }
                        }
                        buffer.setLength(0);
                        state = ParseURLState.HOST;
                        break;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case 11: {
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        --this.idx;
                        if (buffer.length() == 2 && URLUtils.isASCIIAlpha(buffer.charAt(0)) && (buffer.charAt(1) == ':' || buffer.charAt(1) == '|')) {
                            state = ParseURLState.RELATIVE_PATH;
                            break;
                        }
                        if (buffer.length() == 0) {
                            state = ParseURLState.RELATIVE_PATH_START;
                            break;
                        }
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.handleFatalInvalidHostError(ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case 12: {
                    if (this.c == 58 && !bracketsFlag) {
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.handleFatalInvalidHostError(ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.PORT;
                        if (this.stateOverride != ParseURLState.HOST) break;
                        terminate = true;
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        this.decrIdx();
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.handleFatalInvalidHostError(ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        if (this.stateOverride == null) break;
                        terminate = true;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    if (this.c == 91) {
                        bracketsFlag = true;
                    } else if (this.c == 93) {
                        bracketsFlag = false;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case 13: {
                    if (URLUtils.isASCIIDigit(this.c)) {
                        buffer.appendCodePoint(this.c);
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        while (buffer.length() > 0 && buffer.charAt(0) == '0' && buffer.length() > 1) {
                            buffer.deleteCharAt(0);
                        }
                        if (buffer.toString().equals(URLUtils.getDefaultPortForScheme(scheme))) {
                            buffer.setLength(0);
                        }
                        if (buffer.length() == 0) {
                            port = -1;
                        } else {
                            String portMsg = "Port number must be less than 65536";
                            try {
                                port = Integer.parseInt(buffer.toString());
                                if (port > 65535) {
                                    this.handleError(portMsg);
                                }
                            }
                            catch (NumberFormatException e) {
                                this.handleError(portMsg);
                            }
                        }
                        if (this.stateOverride != null) {
                            terminate = true;
                            break;
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        --this.idx;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    this.handleFatalIllegalCharacterError("Illegal character in port", this.c);
                    break;
                }
                case 14: {
                    if (this.c == 92) {
                        this.handleBackslashAsDelimiterError();
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    if (this.c == 47 || this.c == 92) break;
                    this.decrIdx();
                    break;
                }
                case 15: {
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.stateOverride == null && (this.c == 63 || this.c == 35)) {
                        String lowerCasedBuffer;
                        if (this.c == 92) {
                            this.handleBackslashAsDelimiterError();
                        }
                        if ("%2e".equals(lowerCasedBuffer = buffer.toString().toLowerCase(Locale.ENGLISH))) {
                            buffer.setLength(0);
                            buffer.append('.');
                        } else if (".%2e".equals(lowerCasedBuffer) || "%2e.".equals(lowerCasedBuffer) || "%2e%2e".equals(lowerCasedBuffer)) {
                            buffer.setLength(0);
                            buffer.append("..");
                        }
                        if ("..".equals(buffer.toString())) {
                            if (!pathSegments.isEmpty()) {
                                pathSegments.remove(pathSegments.size() - 1);
                            }
                            if (this.c != 47 && this.c != 92) {
                                pathSegments.add("");
                            }
                        } else if (".".equals(buffer.toString()) && this.c != 47 && this.c != 92) {
                            pathSegments.add("");
                        } else if (!".".equals(buffer.toString())) {
                            if ("file".equals(scheme) && pathSegments.isEmpty() && buffer.length() == 2 && URLUtils.isASCIIAlpha(buffer.charAt(0)) && buffer.charAt(1) == '|') {
                                buffer.setCharAt(1, ':');
                            }
                            pathSegments.add(buffer.toString());
                        }
                        buffer.setLength(0);
                        if (this.c == 63) {
                            query = new StringBuilder();
                            state = ParseURLState.QUERY;
                            break;
                        }
                        if (this.c != 35) break;
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.handleIllegalCharacterError("Illegal character in path segment", this.c);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.handleInvalidPercentEncodingError();
                        } else {
                            buffer.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    URLParser.utf8PercentEncode(this.c, EncodeSet.DEFAULT, buffer);
                    break;
                }
                case 16: {
                    if (query == null) {
                        query = new StringBuilder();
                    }
                    if (this.isEOF || this.stateOverride == null && this.c == 35) {
                        if (relativeFlag) {
                            encodingOverride = "utf-8";
                        }
                        byte[] bytes = buffer.toString().getBytes(URLUtils.UTF_8);
                        for (int i = 0; i < bytes.length; ++i) {
                            byte b = bytes[i];
                            if (b < 33 || b > 126 || b == 34 || b == 35 || b == 60 || b == 62 || b == 96) {
                                URLUtils.percentEncode(b, query);
                                continue;
                            }
                            query.append((char)b);
                        }
                        buffer.setLength(0);
                        if (this.c != 35) break;
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.handleIllegalCharacterError("Illegal character in query", this.c);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.handleInvalidPercentEncodingError();
                        } else {
                            buffer.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case 17: {
                    if (fragment == null) {
                        fragment = new StringBuilder();
                    }
                    if (this.isEOF) break;
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.handleIllegalWhitespaceError();
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.handleIllegalCharacterError("Illegal character in fragment", this.c);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.handleInvalidPercentEncodingError();
                        } else {
                            fragment.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    URLParser.utf8PercentEncode(this.c, EncodeSet.SIMPLE, fragment);
                }
            }
            if (this.idx == -1) {
                this.setIdx(this.startIdx);
                continue;
            }
            this.incIdx();
        }
        return new URL(scheme, schemeData.toString(), username, password, host, port, pathSegments, query == null ? null : query.toString(), fragment == null ? null : fragment.toString(), relativeFlag);
    }

    String parseUsername() {
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        this.startIdx = 0;
        this.endIdx = this.input.length();
        this.setIdx(0);
        while (!this.isEOF) {
            URLParser.utf8PercentEncode(this.c, EncodeSet.USERNAME, buffer);
            this.incIdx();
        }
        return buffer.toString();
    }

    String parsePassword() {
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        this.startIdx = 0;
        this.endIdx = this.input.length();
        this.setIdx(0);
        while (!this.isEOF) {
            URLParser.utf8PercentEncode(this.c, EncodeSet.PASSWORD, buffer);
            this.incIdx();
        }
        return buffer.toString();
    }

    private static void utf8PercentEncode(int c, EncodeSet encodeSet, StringBuilder buffer) {
        byte[] bytes;
        if (encodeSet != null) {
            switch (encodeSet.ordinal()) {
                case 0: {
                    if (URLParser.isInSimpleEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case 1: {
                    if (URLParser.isInDefaultEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case 2: {
                    if (URLParser.isInPasswordEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case 3: {
                    if (URLParser.isInUsernameEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
            }
        }
        for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
            URLUtils.percentEncode(b, buffer);
        }
    }

    private static boolean isInSimpleEncodeSet(int c) {
        return c < 32 || c > 126;
    }

    private static boolean isInDefaultEncodeSet(int c) {
        return URLParser.isInSimpleEncodeSet(c) || c == 32 || c == 34 || c == 35 || c == 60 || c == 62 || c == 63 || c == 96;
    }

    private static boolean isInPasswordEncodeSet(int c) {
        return URLParser.isInDefaultEncodeSet(c) || c == 47 || c == 64 || c == 92;
    }

    private static boolean isInUsernameEncodeSet(int c) {
        return URLParser.isInPasswordEncodeSet(c) || c == 58;
    }

    public static enum ParseURLState {
        SCHEME_START,
        SCHEME,
        SCHEME_DATA,
        NO_SCHEME,
        RELATIVE_OR_AUTHORITY,
        RELATIVE,
        RELATIVE_SLASH,
        AUTHORITY_FIRST_SLASH,
        AUTHORITY_SECOND_SLASH,
        AUTHORITY_IGNORE_SLASHES,
        AUTHORITY,
        FILE_HOST,
        HOST,
        PORT,
        RELATIVE_PATH_START,
        RELATIVE_PATH,
        QUERY,
        FRAGMENT;

    }

    private static enum EncodeSet {
        SIMPLE,
        DEFAULT,
        PASSWORD,
        USERNAME;

    }
}

