/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.HprofObject;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayDump;

class HprofArrayValue
extends HprofObject
implements ArrayItemValue {
    final ClassDump dumpClass;
    final int index;

    HprofArrayValue(ClassDump cls, long offset, int number) {
        super(offset + (long)number + 1L);
        this.dumpClass = cls;
        this.index = number;
    }

    @Override
    public Instance getDefiningInstance() {
        return new ObjectArrayDump(this.dumpClass, this.getInstanceArrayOffset());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Instance getInstance() {
        HprofHeap heap = this.dumpClass.getHprof();
        HprofByteBuffer dumpBuffer = heap.dumpBuffer;
        int idSize = dumpBuffer.getIDSize();
        long instanceId = dumpBuffer.getID(this.getInstanceArrayOffset() + 1L + (long)idSize + 4L + 4L + (long)idSize + (long)this.index * (long)idSize);
        return heap.getInstanceByID(instanceId);
    }

    private long getInstanceArrayOffset() {
        return this.fileOffset - (long)this.index - 1L;
    }
}

