/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.parser.AbstractRecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.AbstractRecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.AbstractRecordSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public abstract class AbstractRecord
extends ModifiableVariableHolder {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.CIPHERTEXT)
    private ModifiableByteArray completeRecordBytes;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.CIPHERTEXT)
    private ModifiableByteArray protocolMessageBytes;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.PLAIN_PROTOCOL_MESSAGE)
    private ModifiableByteArray cleanProtocolMessageBytes;
    private ProtocolMessageType contentMessageType;
    private Integer maxRecordLengthConfig;

    public AbstractRecord() {
    }

    public AbstractRecord(Config config) {
        this.maxRecordLengthConfig = config.getDefaultMaxRecordData();
    }

    public ProtocolMessageType getContentMessageType() {
        return this.contentMessageType;
    }

    public void setContentMessageType(ProtocolMessageType contentMessageType) {
        this.contentMessageType = contentMessageType;
    }

    public ModifiableByteArray getCleanProtocolMessageBytes() {
        return this.cleanProtocolMessageBytes;
    }

    public void setCleanProtocolMessageBytes(byte[] cleanProtocolMessageBytes) {
        this.cleanProtocolMessageBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cleanProtocolMessageBytes, (byte[])cleanProtocolMessageBytes);
    }

    public void setCleanProtocolMessageBytes(ModifiableByteArray cleanProtocolMessageBytes) {
        this.cleanProtocolMessageBytes = cleanProtocolMessageBytes;
    }

    public ModifiableByteArray getProtocolMessageBytes() {
        return this.protocolMessageBytes;
    }

    public void setProtocolMessageBytes(ModifiableByteArray protocolMessageBytes) {
        this.protocolMessageBytes = protocolMessageBytes;
    }

    public void setProtocolMessageBytes(byte[] bytes) {
        this.protocolMessageBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolMessageBytes, (byte[])bytes);
    }

    public Integer getMaxRecordLengthConfig() {
        return this.maxRecordLengthConfig;
    }

    public void setMaxRecordLengthConfig(Integer maxRecordLengthConfig) {
        this.maxRecordLengthConfig = maxRecordLengthConfig;
    }

    public ModifiableByteArray getCompleteRecordBytes() {
        return this.completeRecordBytes;
    }

    public void setCompleteRecordBytes(ModifiableByteArray completeRecordBytes) {
        this.completeRecordBytes = completeRecordBytes;
    }

    public void setCompleteRecordBytes(byte[] completeRecordBytes) {
        this.completeRecordBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeRecordBytes, (byte[])completeRecordBytes);
    }

    public abstract AbstractRecordPreparator getRecordPreparator(Chooser var1, Encryptor var2, RecordCompressor var3, ProtocolMessageType var4);

    public abstract AbstractRecordParser getRecordParser(int var1, byte[] var2, ProtocolVersion var3);

    public abstract AbstractRecordSerializer getRecordSerializer();

    public abstract void adjustContext(TlsContext var1);

    public abstract void prepareComputations();
}

