/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.v2;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.ModuleOrProject;
import com.jetbrains.python.sdk.add.v2.CustomNewEnvironmentCreator;
import com.jetbrains.python.sdk.add.v2.PythonMutableTargetAddInterpreterModel;
import com.jetbrains.python.sdk.add.v2.PythonSelectableInterpreter;
import com.jetbrains.python.sdk.poetry.PoetryCommandExecutorKt;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PyProjectTomlPythonVersionsService;
import com.jetbrains.python.statistics.InterpreterType;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\r\u0010\u0017\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0018JF\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u0016H\u0090@\u00a2\u0006\u0004\b&\u0010'R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/jetbrains/python/sdk/add/v2/PoetryNewEnvironmentCreator;", "Lcom/jetbrains/python/sdk/add/v2/CustomNewEnvironmentCreator;", "model", "Lcom/jetbrains/python/sdk/add/v2/PythonMutableTargetAddInterpreterModel;", "moduleOrProject", "Lcom/jetbrains/python/sdk/ModuleOrProject;", "<init>", "(Lcom/jetbrains/python/sdk/add/v2/PythonMutableTargetAddInterpreterModel;Lcom/jetbrains/python/sdk/ModuleOrProject;)V", "interpreterType", "Lcom/jetbrains/python/statistics/InterpreterType;", "getInterpreterType$intellij_python_community_impl", "()Lcom/jetbrains/python/statistics/InterpreterType;", "executable", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "", "getExecutable$intellij_python_community_impl", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "installationScript", "Ljava/nio/file/Path;", "getInstallationScript$intellij_python_community_impl", "()Ljava/nio/file/Path;", "onShown", "", "savePathToExecutableToProperties", "savePathToExecutableToProperties$intellij_python_community_impl", "setupEnvSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "baseSdks", "", "projectPath", "homePath", "installPackages", "", "detectExecutable", "detectExecutable$intellij_python_community_impl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.python.community.impl"})
public final class PoetryNewEnvironmentCreator
extends CustomNewEnvironmentCreator {
    @Nullable
    private final ModuleOrProject moduleOrProject;
    @NotNull
    private final InterpreterType interpreterType;
    @NotNull
    private final ObservableMutableProperty<String> executable;
    @Nullable
    private final Path installationScript;

    public PoetryNewEnvironmentCreator(@NotNull PythonMutableTargetAddInterpreterModel model2, @Nullable ModuleOrProject moduleOrProject) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super("poetry", model2);
        this.moduleOrProject = moduleOrProject;
        this.interpreterType = InterpreterType.POETRY;
        this.executable = model2.getState().getPoetryExecutable();
        this.installationScript = PythonHelpersLocator.Companion.findPathInHelpers("pycharm_poetry_installer.py");
    }

    @Override
    @NotNull
    public InterpreterType getInterpreterType$intellij_python_community_impl() {
        return this.interpreterType;
    }

    @Override
    @NotNull
    public ObservableMutableProperty<String> getExecutable$intellij_python_community_impl() {
        return this.executable;
    }

    @Override
    @Nullable
    public Path getInstallationScript$intellij_python_community_impl() {
        return this.installationScript;
    }

    @Override
    public void onShown() {
        StateFlow<List<PythonSelectableInterpreter>> stateFlow;
        VirtualFile virtualFile;
        ModuleOrProject moduleOrProject = this.moduleOrProject;
        if (moduleOrProject instanceof ModuleOrProject.ModuleAndProject) {
            virtualFile = BasePySdkExtKt.getBaseDir(((ModuleOrProject.ModuleAndProject)this.moduleOrProject).getModule());
        } else if (moduleOrProject instanceof ModuleOrProject.ProjectOnly) {
            virtualFile = ((ModuleOrProject.ProjectOnly)this.moduleOrProject).getProject().getProjectFile();
        } else if (moduleOrProject == null) {
            virtualFile = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        VirtualFile moduleDir = virtualFile;
        if (moduleDir != null) {
            Flow<List<PythonSelectableInterpreter>> flow = PyProjectTomlPythonVersionsService.Companion.getInstance().validateInterpretersVersions(moduleDir, (Flow<? extends List<? extends PythonSelectableInterpreter>>)((Flow)this.getModel().getBaseInterpreters()));
            stateFlow = flow instanceof StateFlow ? (StateFlow<List<PythonSelectableInterpreter>>)flow : null;
            if (stateFlow == null) {
                stateFlow = this.getModel().getBaseInterpreters();
            }
        } else {
            stateFlow = this.getModel().getBaseInterpreters();
        }
        StateFlow<List<PythonSelectableInterpreter>> validatedInterpreters = stateFlow;
        this.getBasePythonComboBox().setItems(validatedInterpreters);
    }

    @Override
    public void savePathToExecutableToProperties$intellij_python_community_impl() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        PoetryCommandExecutorKt.setPoetryPath(propertiesComponent, StringKt.nullize$default((String)((String)this.getExecutable$intellij_python_community_impl().get()), (boolean)false, (int)1, null));
    }

    @Override
    @Nullable
    protected Sdk setupEnvSdk(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> baseSdks, @NotNull String projectPath, @Nullable String homePath, boolean installPackages2) {
        Intrinsics.checkNotNullParameter(baseSdks, (String)"baseSdks");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return PoetryKt.setupPoetrySdkUnderProgress$default(project, module, baseSdks, projectPath, homePath, installPackages2, null, 64, null);
    }

    @Override
    @Nullable
    public Object detectExecutable$intellij_python_community_impl(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.getModel().detectPoetryExecutable($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

