/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaValidityCacheKt;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaObject mySchema;
    @NotNull
    private final JsonPointerPosition myPosition;
    @NotNull
    private final JsonSchemaNodeExpansionRequest myExpansionRequest;

    @Deprecated(forRemoval=true)
    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(1);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(2);
        }
        this(project, schema, position, new JsonSchemaNodeExpansionRequest(null, true));
    }

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position, @Nullable JsonValueAdapter inspectedValueAdapter) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(3);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(4);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(5);
        }
        this(project, schema, position, new JsonSchemaNodeExpansionRequest(inspectedValueAdapter, true));
    }

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position, @NotNull JsonSchemaNodeExpansionRequest expansionRequest) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(6);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(7);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(8);
        }
        if (expansionRequest == null) {
            JsonSchemaResolver.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        this.mySchema = schema;
        this.myPosition = position;
        this.myExpansionRequest = expansionRequest;
    }

    public MatchResult detailedResolve() {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.myExpansionRequest, this.mySchema, this.myPosition, false);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        MatchResult result = this.detailedResolve();
        LinkedList<JsonSchemaObject> list = new LinkedList<JsonSchemaObject>();
        list.addAll(result.mySchemas);
        for (Collection<? extends JsonSchemaObject> myExcludingSchema : result.myExcludingSchemas) {
            list.addAll(myExcludingSchema);
        }
        LinkedList<JsonSchemaObject> linkedList = list;
        if (linkedList == null) {
            JsonSchemaResolver.$$$reportNull$$$0(10);
        }
        return linkedList;
    }

    @Nullable
    public PsiElement findNavigationTarget(@Nullable PsiElement element) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.myExpansionRequest, this.mySchema, this.myPosition, true);
        JsonSchemaObject schema = JsonSchemaResolver.selectSchema(node, element, this.myPosition.isEmpty());
        if (schema == null) {
            return null;
        }
        VirtualFile file = JsonSchemaService.Impl.get(this.myProject).resolveSchemaFile(schema);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)psiFile, schema);
        return walker == null ? null : JsonSchemaResolver.resolvePosition(walker, (PsiElement)psiFile, JsonPointerPosition.parsePointer(schema.getPointer()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static PsiElement resolvePosition(@NotNull JsonLikePsiWalker walker, @Nullable PsiElement element, @NotNull JsonPointerPosition position) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (walker == null) {
            JsonSchemaResolver.$$$reportNull$$$0(11);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(12);
        }
        PsiElement psiElement3 = psiElement2 = element instanceof PsiFile ? (PsiElement)ContainerUtil.getFirstItem(walker.getRoots((PsiFile)element)) : element;
        if (psiElement2 == null) {
            return null;
        }
        JsonValueAdapter value = walker.createValueAdapter(psiElement2);
        while (position != null && !position.isEmpty()) {
            block14: {
                int index;
                if (value instanceof JsonObjectValueAdapter) {
                    String name = position.getFirstName();
                    if (name == null) {
                        return null;
                    }
                    JsonPropertyAdapter property = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, name);
                    if (property != null) {
                        value = JsonSchemaResolver.getValue(property);
                        if (value == null) {
                            return null;
                        }
                        break block14;
                    } else {
                        JsonPropertyAdapter props = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "properties");
                        if (props != null) {
                            value = JsonSchemaResolver.getValue(props);
                            continue;
                        }
                        JsonPropertyAdapter defs = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "definitions");
                        if (defs != null) {
                            value = JsonSchemaResolver.getValue(defs);
                            continue;
                        }
                        JsonPropertyAdapter defs9 = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "$defs");
                        if (defs9 == null) return null;
                        value = JsonSchemaResolver.getValue(defs9);
                        continue;
                    }
                }
                if (value instanceof JsonArrayValueAdapter && (index = position.getFirstIndex()) >= 0) {
                    List<JsonValueAdapter> values = ((JsonArrayValueAdapter)value).getElements();
                    if (values.size() <= index) return null;
                    value = values.get(index);
                }
            }
            position = position.skip(1);
        }
        if (value == null) {
            return null;
        }
        PsiElement delegate = value.getDelegate();
        PsiElement propertyNameElement = walker.getPropertyNameElement(delegate.getParent());
        if (propertyNameElement == null) {
            psiElement = delegate;
            return psiElement;
        }
        psiElement = propertyNameElement;
        return psiElement;
    }

    @Nullable
    private static JsonValueAdapter getValue(@NotNull JsonPropertyAdapter property) {
        Collection<JsonValueAdapter> values;
        if (property == null) {
            JsonSchemaResolver.$$$reportNull$$$0(13);
        }
        return (values = property.getValues()).size() == 1 ? values.iterator().next() : null;
    }

    @Nullable
    private static JsonPropertyAdapter findProperty(@NotNull JsonObjectValueAdapter value, @NotNull String name) {
        if (value == null) {
            JsonSchemaResolver.$$$reportNull$$$0(14);
        }
        if (name == null) {
            JsonSchemaResolver.$$$reportNull$$$0(15);
        }
        List<JsonPropertyAdapter> list = value.getPropertyList();
        return (JsonPropertyAdapter)ContainerUtil.find(list, p -> name.equals(p.getName()));
    }

    @Nullable
    public static JsonSchemaObject selectSchema(@NotNull JsonSchemaTreeNode resolveRoot, @Nullable PsiElement element, boolean topLevelSchema) {
        JsonValueAdapter parentAdapter;
        JsonValueAdapter adapter;
        if (resolveRoot == null) {
            JsonSchemaResolver.$$$reportNull$$$0(16);
        }
        MatchResult matchResult = MatchResult.create(resolveRoot);
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(matchResult.mySchemas);
        schemas.addAll(matchResult.myExcludingSchemas.stream().flatMap(Collection::stream).toList());
        JsonSchemaObject firstSchema = JsonSchemaResolver.getFirstValidSchema(schemas);
        if (element == null || schemas.size() == 1 || firstSchema == null) {
            return firstSchema;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, firstSchema);
        if (walker == null || (adapter = walker.createValueAdapter(element)) == null) {
            return null;
        }
        if (topLevelSchema) {
            parentAdapter = null;
        } else {
            PsiElement parentValue = walker.getParentContainer(element);
            if (parentValue == null || (parentAdapter = walker.createValueAdapter(parentValue)) == null) {
                return null;
            }
        }
        Ref schemaRef = new Ref();
        MatchResult.iterateTree(resolveRoot, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            JsonSchemaTreeNode parent = node.getParent();
            if (node.getSchema() == null || parentAdapter != null && parent != null && parent.isNothing()) {
                return true;
            }
            if (!JsonSchemaResolver.isCorrect(adapter, node.getSchema())) {
                return true;
            }
            if (parentAdapter == null || parent == null || parent.getSchema() == null || parent.isAny() || JsonSchemaResolver.isCorrect(parentAdapter, parent.getSchema())) {
                schemaRef.set((Object)node.getSchema());
                return false;
            }
            return true;
        }));
        return (JsonSchemaObject)schemaRef.get();
    }

    @Nullable
    private static JsonSchemaObject getFirstValidSchema(List<JsonSchemaObject> schemas) {
        return schemas.stream().findFirst().orElse(null);
    }

    public static boolean isCorrect(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        if (value == null) {
            JsonSchemaResolver.$$$reportNull$$$0(17);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(18);
        }
        return JsonSchemaValidityCacheKt.getOrComputeAdapterValidityAgainstGivenSchema(value, schema);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expansionRequest";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolvePosition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectSchema";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

