/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitDataCache;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.InMemoryStorage;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.data.VcsLogUserResolverBase;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDiagnosticRunner;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VcsLogData
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogData.class);
    public static final VcsLogProgress.ProgressKey DATA_PACK_REFRESH = new VcsLogProgress.ProgressKey("data pack");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    @NotNull
    private final CheckedDisposable myDisposableFlag;
    private final Map<VirtualFile, VcsUser> myCurrentUser;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogUserResolver myUserResolver;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresherImpl myRefresher;
    @NotNull
    private final List<DataPackChangeListener> myDataPackChangeListeners;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final IndexDiagnosticRunner myIndexDiagnosticRunner;
    @NotNull
    private final Object myLock;
    @NotNull
    private State myState;
    @Nullable
    private SingleTaskController.SingleTask myInitialization;

    public VcsLogData(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogErrorHandler errorHandler, boolean isIndexEnabled, @NotNull Disposable parentDisposable) {
        if (project == null) {
            VcsLogData.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            VcsLogData.$$$reportNull$$$0(1);
        }
        if (errorHandler == null) {
            VcsLogData.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            VcsLogData.$$$reportNull$$$0(3);
        }
        this.myDisposableFlag = Disposer.newCheckedDisposable();
        this.myCurrentUser = new ConcurrentHashMap<VirtualFile, VcsUser>();
        this.myDataPackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLock = new Object();
        this.myState = State.CREATED;
        this.myInitialization = null;
        this.myProject = project;
        this.myLogProviders = logProviders;
        this.myUserRegistry = (VcsUserRegistryImpl)project.getService(VcsUserRegistry.class);
        this.myErrorHandler = errorHandler;
        VcsLogProgress progress = new VcsLogProgress(this);
        Pair<VcsLogStorage, VcsLogModifiableIndex> storageAndIndex = this.createStorageAndIndex(progress, isIndexEnabled);
        this.myStorage = (VcsLogStorage)storageAndIndex.first;
        this.myIndex = (VcsLogModifiableIndex)storageAndIndex.second;
        this.myTopCommitsDetailsCache = new TopCommitsCache(this.myStorage);
        this.myMiniDetailsGetter = new MiniDetailsGetter(this.myProject, this.myStorage, logProviders, this.myTopCommitsDetailsCache, this.myIndex, this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myStorage, logProviders, this);
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myStorage, this.myLogProviders, this.myUserRegistry, this.myIndex, progress, this.myTopCommitsDetailsCache, this::fireDataPackChangeEvent, VcsLogData.getRecentCommitsCount());
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
        this.myUserResolver = new MyVcsLogUserResolver();
        this.myIndexDiagnosticRunner = new IndexDiagnosticRunner(this.myIndex, this.myStorage, this.myLogProviders.keySet(), (Function0<? extends DataPack>)((Function0)this::getDataPack), this.myDetailsGetter, this.myErrorHandler, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myInitialization != null) {
                    this.myInitialization.cancel();
                }
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myDisposableFlag);
    }

    @NotNull
    private Pair<VcsLogStorage, VcsLogModifiableIndex> createStorageAndIndex(@NotNull VcsLogProgress progress, boolean isIndexEnabled) {
        VcsLogStorageBackend indexBackend;
        VcsLogStorage storage;
        if (progress == null) {
            VcsLogData.$$$reportNull$$$0(4);
        }
        if (!VcsLogCachesInvalidator.getInstance().isValid()) {
            LOG.error("Could not delete caches at " + PersistentUtil.LOG_CACHE);
            this.myErrorHandler.displayMessage(VcsLogBundle.message("vcs.log.fatal.error.message", PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()));
            return new Pair((Object)new InMemoryStorage(), (Object)new EmptyIndex());
        }
        String logId = PersistentUtil.calcLogId(this.myProject, this.myLogProviders);
        Map<VirtualFile, VcsLogIndexer> indexers = VcsLogPersistentIndex.getAvailableIndexers(this.myLogProviders);
        boolean isIndexSwitchedOnInRegistry = VcsLogData.isIndexSwitchedOnInRegistry();
        boolean isIndexSwitchedOn = isIndexEnabled && isIndexSwitchedOnInRegistry;
        try {
            if (Registry.is((String)"vcs.log.index.sqlite.storage", (boolean)false)) {
                SqliteVcsLogStorageBackend sqliteBackend;
                storage = sqliteBackend = new SqliteVcsLogStorageBackend(this.myProject, logId, this.myLogProviders, this.myErrorHandler, this);
                indexBackend = sqliteBackend;
            } else {
                LinkedHashSet<VirtualFile> indexingRoots = isIndexSwitchedOn ? new LinkedHashSet<VirtualFile>(indexers.keySet()) : Collections.emptySet();
                Pair<VcsLogStorage, VcsLogStorageBackend> storageAndIndexBackend = VcsLogStorageImpl.createStorageAndIndexBackend(this.myProject, logId, this.myLogProviders, indexingRoots, this.myErrorHandler, this);
                storage = (VcsLogStorage)storageAndIndexBackend.first;
                indexBackend = (VcsLogStorageBackend)storageAndIndexBackend.second;
            }
        }
        catch (IOException e) {
            LOG.error("Falling back to in-memory hashes", (Throwable)e);
            return new Pair((Object)new InMemoryStorage(), (Object)new EmptyIndex());
        }
        if (indexBackend == null || !isIndexSwitchedOn || indexers.isEmpty()) {
            if (!isIndexSwitchedOnInRegistry) {
                LOG.info("Vcs log index is turned off in the registry");
            }
            if (!isIndexEnabled) {
                LOG.info("Vcs log index is turned off for " + VcsLogUtil.getProvidersMapText(this.myLogProviders));
            }
            if (indexers.isEmpty()) {
                LOG.info("No indexers found for project " + this.myProject.getName());
            }
            return new Pair((Object)storage, (Object)new EmptyIndex());
        }
        VcsLogPersistentIndex index = new VcsLogPersistentIndex(this.myProject, this.myLogProviders, indexers, storage, indexBackend, progress, this.myErrorHandler, this);
        return new Pair((Object)storage, (Object)index);
    }

    public void initialize() {
        this.myRefresher.initialize();
        this.readCurrentUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCurrentUser() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState.equals((Object)State.CREATED)) {
                this.myState = State.INITIALIZED;
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, VcsLogBundle.message("vcs.log.initial.reading.current.user.process", new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator.setIndeterminate(true);
                        VcsLogData.this.resetState();
                        VcsLogData.this.doReadCurrentUser();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onCancel() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            LOG.error(error);
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/vcs/log/data/VcsLogData$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                CoreProgressManager manager = (CoreProgressManager)ProgressManager.getInstance();
                ProgressIndicator indicator = this.myRefresher.getProgress().createProgressIndicator(DATA_PACK_REFRESH);
                Future future = manager.runProcessWithProgressAsynchronously(backgroundable, indicator, null);
                this.myInitialization = new SingleTaskController.SingleTaskImpl(future, indicator);
            }
        }
    }

    private void doReadCurrentUser() {
        Span span = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.ReadingCurrentUser.getName()).startSpan();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        span.end();
    }

    private void fireDataPackChangeEvent(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            VcsLogData.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (DataPackChangeListener listener2 : this.myDataPackChangeListeners) {
                listener2.onDataPackChange(dataPack);
            }
        }, o -> this.myDisposableFlag.isDisposed());
    }

    public void addDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            VcsLogData.$$$reportNull$$$0(6);
        }
        this.myDataPackChangeListeners.add(listener2);
    }

    public void removeDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            VcsLogData.$$$reportNull$$$0(7);
        }
        this.myDataPackChangeListeners.remove(listener2);
    }

    @NotNull
    public DataPack getDataPack() {
        DataPack dataPack = this.myRefresher.getCurrentDataPack();
        if (dataPack == null) {
            VcsLogData.$$$reportNull$$$0(8);
        }
        return dataPack;
    }

    @Nullable
    public CommitId getCommitId(int commitIndex) {
        VcsCommitMetadata cachedData = this.myMiniDetailsGetter.getCachedData(commitIndex);
        if (cachedData != null) {
            return new CommitId((Hash)cachedData.getId(), cachedData.getRoot());
        }
        return this.myStorage.getCommitId(commitIndex);
    }

    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            VcsLogData.$$$reportNull$$$0(9);
        }
        if (root == null) {
            VcsLogData.$$$reportNull$$$0(10);
        }
        return this.myStorage.getCommitIndex(hash, root);
    }

    @NotNull
    public VcsLogStorage getStorage() {
        VcsLogStorage vcsLogStorage = this.myStorage;
        if (vcsLogStorage == null) {
            VcsLogData.$$$reportNull$$$0(11);
        }
        return vcsLogStorage;
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        Set<VcsUser> set = this.myUserRegistry.getUsers();
        if (set == null) {
            VcsLogData.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        Map<VirtualFile, VcsUser> map = this.myCurrentUser;
        if (map == null) {
            VcsLogData.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VcsLogData.$$$reportNull$$$0(14);
        }
        return project;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Set<VirtualFile> set = this.myLogProviders.keySet();
        if (set == null) {
            VcsLogData.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myLogProviders;
        if (map == null) {
            VcsLogData.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        ContainingBranchesGetter containingBranchesGetter = this.myContainingBranchesGetter;
        if (containingBranchesGetter == null) {
            VcsLogData.$$$reportNull$$$0(17);
        }
        return containingBranchesGetter;
    }

    public void refresh(@NotNull Collection<VirtualFile> roots, boolean optimized) {
        if (roots == null) {
            VcsLogData.$$$reportNull$$$0(18);
        }
        this.initialize();
        this.myRefresher.refresh(roots, optimized);
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            VcsLogData.$$$reportNull$$$0(19);
        }
        this.refresh(roots, false);
    }

    @NotNull
    public CommitDetailsGetter getCommitDetailsGetter() {
        CommitDetailsGetter commitDetailsGetter = this.myDetailsGetter;
        if (commitDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(20);
        }
        return commitDetailsGetter;
    }

    @NotNull
    public VcsLogCommitDataCache<VcsFullCommitDetails> getFullCommitDetailsCache() {
        CommitDetailsGetter commitDetailsGetter = this.getCommitDetailsGetter();
        if (commitDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(21);
        }
        return commitDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        MiniDetailsGetter miniDetailsGetter = this.myMiniDetailsGetter;
        if (miniDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(22);
        }
        return miniDetailsGetter;
    }

    @NotNull
    public VcsLogCommitDataCache<VcsCommitMetadata> getCommitMetadataCache() {
        MiniDetailsGetter miniDetailsGetter = this.getMiniDetailsGetter();
        if (miniDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(23);
        }
        return miniDetailsGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SingleTaskController.SingleTask initialization;
        Object object = this.myLock;
        synchronized (object) {
            initialization = this.myInitialization;
            this.myInitialization = null;
            this.myState = State.DISPOSED;
        }
        if (initialization != null) {
            initialization.cancel();
            try {
                initialization.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogData.$$$reportNull$$$0(24);
        }
        VcsLogProvider vcsLogProvider = this.myLogProviders.get(root);
        if (vcsLogProvider == null) {
            VcsLogData.$$$reportNull$$$0(25);
        }
        return vcsLogProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        VcsUserRegistryImpl vcsUserRegistryImpl = this.myUserRegistry;
        if (vcsUserRegistryImpl == null) {
            VcsLogData.$$$reportNull$$$0(26);
        }
        return vcsUserRegistryImpl;
    }

    @NotNull
    public VcsLogUserResolver getUserNameResolver() {
        VcsLogUserResolver vcsLogUserResolver = this.myUserResolver;
        if (vcsLogUserResolver == null) {
            VcsLogData.$$$reportNull$$$0(27);
        }
        return vcsLogUserResolver;
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myRefresher.getProgress();
        if (vcsLogProgress == null) {
            VcsLogData.$$$reportNull$$$0(28);
        }
        return vcsLogProgress;
    }

    @NotNull
    public TopCommitsCache getTopCommitsCache() {
        TopCommitsCache topCommitsCache = this.myTopCommitsDetailsCache;
        if (topCommitsCache == null) {
            VcsLogData.$$$reportNull$$$0(29);
        }
        return topCommitsCache;
    }

    @NotNull
    public VcsLogIndex getIndex() {
        VcsLogModifiableIndex vcsLogModifiableIndex = this.getModifiableIndex();
        if (vcsLogModifiableIndex == null) {
            VcsLogData.$$$reportNull$$$0(30);
        }
        return vcsLogModifiableIndex;
    }

    @TestOnly
    @NotNull
    VcsLogModifiableIndex getModifiableIndex() {
        VcsLogModifiableIndex vcsLogModifiableIndex = this.myIndex;
        if (vcsLogModifiableIndex == null) {
            VcsLogData.$$$reportNull$$$0(31);
        }
        return vcsLogModifiableIndex;
    }

    public static boolean isIndexSwitchedOnInRegistry() {
        return VcsLogData.getIndexingRegistryValue().asBoolean();
    }

    @NotNull
    public static RegistryValue getIndexingRegistryValue() {
        RegistryValue registryValue = Registry.get((String)"vcs.log.index.enable");
        if (registryValue == null) {
            VcsLogData.$$$reportNull$$$0(32);
        }
        return registryValue;
    }

    public static int getRecentCommitsCount() {
        return Registry.intValue((String)"vcs.log.recent.commits.count");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUser";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranchesGetter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitDetailsGetter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullCommitDetailsCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiniDetailsGetter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMetadataCache";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProvider";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserRegistry";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserNameResolver";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgress";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopCommitsCache";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableIndex";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingRegistryValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStorageAndIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fireDataPackChangeEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDataPackChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeDataPackChangeListener";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLogProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        DISPOSED;

    }

    private class MyVcsLogUserResolver
    extends VcsLogUserResolverBase
    implements Disposable {
        @NotNull
        private final DataPackChangeListener myListener = newDataPack -> this.clearCache();

        MyVcsLogUserResolver() {
            VcsLogData.this.addDataPackChangeListener(this.myListener);
            Disposer.register((Disposable)VcsLogData.this, (Disposable)this);
        }

        @Override
        @NotNull
        public Map<VirtualFile, VcsUser> getCurrentUsers() {
            Map<VirtualFile, VcsUser> map = VcsLogData.this.getCurrentUser();
            if (map == null) {
                MyVcsLogUserResolver.$$$reportNull$$$0(0);
            }
            return map;
        }

        @Override
        @NotNull
        public Set<VcsUser> getAllUsers() {
            Set<VcsUser> set = VcsLogData.this.getAllUsers();
            if (set == null) {
                MyVcsLogUserResolver.$$$reportNull$$$0(1);
            }
            return set;
        }

        public void dispose() {
            VcsLogData.this.removeDataPackChangeListener(this.myListener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/data/VcsLogData$MyVcsLogUserResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentUsers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUsers";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

