/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.dataextractor;

import com.intellij.driver.model.TextData;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.ExtractorGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextToKeyCache;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.AttributedCharacterIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\"\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\"\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\"\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001dH\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/DataExtractorGraphics2d;", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/ExtractorGraphics2d;", "g", "Ljava/awt/Graphics2D;", "extractionData", "", "Lcom/intellij/driver/model/TextData;", "location", "Ljava/awt/Point;", "textToKey", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextToKeyCache;", "<init>", "(Ljava/awt/Graphics2D;Ljava/util/List;Ljava/awt/Point;Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextToKeyCache;)V", "addTextData", "", "text", "", "x", "", "y", "create", "Ljava/awt/Graphics;", "drawString", "str", "", "iterator", "Ljava/text/AttributedCharacterIterator;", "translate", "tx", "", "ty", "rotation", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/DataExtractorGraphics2d$Rotation;", "rotate", "theta", "Rotation", "intellij.performanceTesting.remoteDriver"})
public final class DataExtractorGraphics2d
extends ExtractorGraphics2d {
    @NotNull
    private final Graphics2D g;
    @NotNull
    private final List<TextData> extractionData;
    @NotNull
    private final Point location;
    @NotNull
    private final TextToKeyCache textToKey;
    @Nullable
    private Rotation rotation;

    public DataExtractorGraphics2d(@NotNull Graphics2D g, @NotNull List<TextData> extractionData, @NotNull Point location, @NotNull TextToKeyCache textToKey) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(extractionData, (String)"extractionData");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)textToKey, (String)"textToKey");
        super(g);
        this.g = g;
        this.extractionData = extractionData;
        this.location = location;
        this.textToKey = textToKey;
    }

    private final void addTextData(String text, int x, int y) {
        if (this.rotation != null) {
            Rotation rotation = this.rotation;
            Intrinsics.checkNotNull((Object)rotation);
            double a = rotation.getTheta();
            double rx = (double)x * Math.cos(a) - (double)y * Math.sin(a);
            double ry = (double)(-x) * Math.sin(a) + (double)y * Math.cos(a);
            v1 = this.extractionData.add(new TextData(text, new Point(this.location.x + (int)rx, this.location.y + (int)ry), TextToKeyCache.INSTANCE.findKey(text)));
        } else {
            v1 = this.extractionData.add(new TextData(text, new Point(this.location.x + x + 3, this.location.y + y - 3), TextToKeyCache.INSTANCE.findKey(text)));
        }
    }

    @Override
    @NotNull
    public Graphics create() {
        Graphics graphics = this.g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = this.location.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Point");
        return new DataExtractorGraphics2d(graphics2D, this.extractionData, (Point)object, this.textToKey);
    }

    @Override
    public void drawString(@Nullable String str, int x, int y) {
        if (str != null) {
            this.addTextData(str, x, y);
        }
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable String str, float x, float y) {
        if (str != null) {
            this.addTextData(str, (int)x, (int)y);
        }
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator2, int x, int y) {
        if (iterator2 != null) {
            this.addTextData(iterator2.toString(), x, y);
        }
        this.g.drawString(iterator2, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator2, float x, float y) {
        if (iterator2 != null) {
            this.addTextData(iterator2.toString(), (int)x, (int)y);
        }
        this.g.drawString(iterator2, x, y);
    }

    @Override
    public void translate(int x, int y) {
        this.location.x += x;
        this.location.y += y;
        this.g.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.location.x += (int)tx;
        this.location.y += (int)ty;
        this.g.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.g.rotate(theta);
        this.rotation = new Rotation(theta, null, null, 6, null);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
        this.rotation = new Rotation(theta, x, y);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/DataExtractorGraphics2d$Rotation;", "", "theta", "", "x", "y", "<init>", "(DLjava/lang/Double;Ljava/lang/Double;)V", "getTheta", "()D", "getX", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getY", "component1", "component2", "component3", "copy", "(DLjava/lang/Double;Ljava/lang/Double;)Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/DataExtractorGraphics2d$Rotation;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.performanceTesting.remoteDriver"})
    public static final class Rotation {
        private final double theta;
        @Nullable
        private final Double x;
        @Nullable
        private final Double y;

        public Rotation(double theta, @Nullable Double x, @Nullable Double y) {
            this.theta = theta;
            this.x = x;
            this.y = y;
        }

        public /* synthetic */ Rotation(double d, Double d2, Double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d2 = null;
            }
            if ((n & 4) != 0) {
                d3 = null;
            }
            this(d, d2, d3);
        }

        public final double getTheta() {
            return this.theta;
        }

        @Nullable
        public final Double getX() {
            return this.x;
        }

        @Nullable
        public final Double getY() {
            return this.y;
        }

        public final double component1() {
            return this.theta;
        }

        @Nullable
        public final Double component2() {
            return this.x;
        }

        @Nullable
        public final Double component3() {
            return this.y;
        }

        @NotNull
        public final Rotation copy(double theta, @Nullable Double x, @Nullable Double y) {
            return new Rotation(theta, x, y);
        }

        public static /* synthetic */ Rotation copy$default(Rotation rotation, double d, Double d2, Double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = rotation.theta;
            }
            if ((n & 2) != 0) {
                d2 = rotation.x;
            }
            if ((n & 4) != 0) {
                d3 = rotation.y;
            }
            return rotation.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "Rotation(theta=" + this.theta + ", x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.theta);
            result = result * 31 + (this.x == null ? 0 : ((Object)this.x).hashCode());
            result = result * 31 + (this.y == null ? 0 : ((Object)this.y).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rotation)) {
                return false;
            }
            Rotation rotation = (Rotation)other;
            if (Double.compare(this.theta, rotation.theta) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.x, (Object)rotation.x)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.y, (Object)rotation.y);
        }
    }
}

