/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.Injection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseInjection
implements Injection,
PersistentStateComponent<Element> {
    public static final Key<BaseInjection> INJECTION_KEY = Key.create((String)"INJECTION_KEY");
    @NotNull
    @NlsSafe
    private final String mySupportId;
    @Nls
    private String myDisplayName;
    @NlsSafe
    private String myInjectedLanguageId;
    private String myPrefix;
    private String mySuffix;
    @NonNls
    private String myValuePattern;
    private Pattern myCompiledValuePattern;
    @NonNls
    private String myIgnorePattern;
    private Pattern myCompiledIgnorePattern;
    private boolean mySingleFile;
    private InjectionPlace @NotNull [] myPlaces;

    public BaseInjection(@NotNull String id) {
        if (id == null) {
            BaseInjection.$$$reportNull$$$0(0);
        }
        this.myDisplayName = "";
        this.myInjectedLanguageId = "";
        this.myPrefix = "";
        this.mySuffix = "";
        this.myValuePattern = "";
        this.myIgnorePattern = "";
        this.myPlaces = InjectionPlace.EMPTY_ARRAY;
        this.mySupportId = id;
    }

    public BaseInjection(@NotNull String supportId, @NotNull String injectedLanguageId, @NotNull String prefix, @NotNull String suffix, InjectionPlace ... places) {
        if (supportId == null) {
            BaseInjection.$$$reportNull$$$0(1);
        }
        if (injectedLanguageId == null) {
            BaseInjection.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            BaseInjection.$$$reportNull$$$0(3);
        }
        if (suffix == null) {
            BaseInjection.$$$reportNull$$$0(4);
        }
        if (places == null) {
            BaseInjection.$$$reportNull$$$0(5);
        }
        this.myDisplayName = "";
        this.myInjectedLanguageId = "";
        this.myPrefix = "";
        this.mySuffix = "";
        this.myValuePattern = "";
        this.myIgnorePattern = "";
        this.myPlaces = InjectionPlace.EMPTY_ARRAY;
        this.mySupportId = supportId;
        this.myInjectedLanguageId = injectedLanguageId;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myPlaces = places;
    }

    @Nullable
    public Language getInjectedLanguage() {
        return InjectorUtils.getLanguage(this);
    }

    public InjectionPlace @NotNull [] getInjectionPlaces() {
        if (this.myPlaces == null) {
            BaseInjection.$$$reportNull$$$0(6);
        }
        return this.myPlaces;
    }

    public void setInjectionPlaces(InjectionPlace ... places) {
        if (places == null) {
            BaseInjection.$$$reportNull$$$0(7);
        }
        this.myPlaces = places;
    }

    @NotNull
    @NlsSafe
    public String getSupportId() {
        String string = this.mySupportId;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getInjectedLanguageId() {
        String string = this.myInjectedLanguageId;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setDisplayName(@Nls @NotNull String displayName) {
        if (displayName == null) {
            BaseInjection.$$$reportNull$$$0(11);
        }
        this.myDisplayName = displayName;
    }

    public void setInjectedLanguageId(@NotNull String injectedLanguageId) {
        if (injectedLanguageId == null) {
            BaseInjection.$$$reportNull$$$0(12);
        }
        this.myInjectedLanguageId = injectedLanguageId;
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setPrefix(@NotNull String prefix) {
        if (prefix == null) {
            BaseInjection.$$$reportNull$$$0(14);
        }
        this.myPrefix = prefix;
    }

    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setSuffix(@NotNull String suffix) {
        if (suffix == null) {
            BaseInjection.$$$reportNull$$$0(16);
        }
        this.mySuffix = suffix;
    }

    public boolean shouldBeIgnored(@NotNull Iterator<PsiLanguageInjectionHost> elements, @Nullable String delimiter) {
        if (elements == null) {
            BaseInjection.$$$reportNull$$$0(17);
        }
        if (this.myCompiledIgnorePattern == null) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        while (elements.hasNext()) {
            PsiLanguageInjectionHost element = elements.next();
            LiteralTextEscaper textEscaper = element.createLiteralTextEscaper();
            textEscaper.decode(ElementManipulators.getValueTextRange((PsiElement)element), buffer);
            if (delimiter == null || !elements.hasNext()) continue;
            buffer.append(delimiter);
        }
        return this.myCompiledIgnorePattern.matcher(StringPattern.newBombedCharSequence((CharSequence)buffer)).find();
    }

    public boolean shouldBeIgnored(@NotNull PsiElement element) {
        if (element == null) {
            BaseInjection.$$$reportNull$$$0(18);
        }
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return false;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)element;
        return this.shouldBeIgnored(Collections.singleton(host).iterator(), null);
    }

    @Override
    @NotNull
    public List<TextRange> getInjectedArea(PsiElement element) {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (this.myCompiledValuePattern == null) {
            List<TextRange> list = Collections.singletonList(textRange);
            if (list == null) {
                BaseInjection.$$$reportNull$$$0(19);
            }
            return list;
        }
        LiteralTextEscaper textEscaper = ((PsiLanguageInjectionHost)element).createLiteralTextEscaper();
        StringBuilder sb = new StringBuilder();
        textEscaper.decode(textRange, sb);
        List<TextRange> ranges = BaseInjection.getMatchingRanges(this.myCompiledValuePattern.matcher(StringPattern.newBombedCharSequence((CharSequence)sb)), sb.length());
        List list = !ranges.isEmpty() ? ContainerUtil.map(ranges, s -> new TextRange(textEscaper.getOffsetInHost(s.getStartOffset(), textRange), textEscaper.getOffsetInHost(s.getEndOffset(), textRange))) : Collections.emptyList();
        if (list == null) {
            BaseInjection.$$$reportNull$$$0(20);
        }
        return list;
    }

    public boolean isEnabled() {
        for (InjectionPlace place : this.myPlaces) {
            if (place.getElementPattern() == null || !place.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsPsiElement(PsiElement element) {
        ProgressManager.checkCanceled();
        for (InjectionPlace place : this.myPlaces) {
            if (!place.isEnabled() || place.getElementPattern() == null || !place.getElementPattern().accepts((Object)element)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsWith(BaseInjection template) {
        if (!Objects.equals(this.getInjectedLanguageId(), template.getInjectedLanguageId())) {
            return false;
        }
        for (InjectionPlace other : template.getInjectionPlaces()) {
            if (!ArrayUtil.contains((Object)other, (Object[])this.myPlaces)) continue;
            return true;
        }
        return false;
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!this.myInjectedLanguageId.equals(that.myInjectedLanguageId)) {
            return false;
        }
        if (!this.myPrefix.equals(that.myPrefix)) {
            return false;
        }
        if (!this.mySuffix.equals(that.mySuffix)) {
            return false;
        }
        if (!this.myValuePattern.equals(that.myValuePattern)) {
            return false;
        }
        return this.mySingleFile == that.mySingleFile;
    }

    public BaseInjection copy() {
        return new BaseInjection(this.mySupportId).copyFrom(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseInjection)) {
            return false;
        }
        BaseInjection that = (BaseInjection)o;
        if (!Objects.equals(this.getDisplayName(), that.getDisplayName())) {
            return false;
        }
        if (!this.sameLanguageParameters(that)) {
            return false;
        }
        if (this.myPlaces.length != that.myPlaces.length) {
            return false;
        }
        int len = this.myPlaces.length;
        for (int i = 0; i < len; ++i) {
            if (this.myPlaces[i].isEnabled() == that.myPlaces[i].isEnabled()) continue;
            return false;
        }
        return Arrays.equals(this.myPlaces, that.myPlaces);
    }

    public int hashCode() {
        int result = this.myInjectedLanguageId.hashCode();
        result = 31 * result + this.myPrefix.hashCode();
        result = 31 * result + this.mySuffix.hashCode();
        result = 31 * result + this.myValuePattern.hashCode();
        result = 31 * result + this.myIgnorePattern.hashCode();
        return result;
    }

    public BaseInjection copyFrom(@NotNull BaseInjection other) {
        if (other == null) {
            BaseInjection.$$$reportNull$$$0(21);
        }
        assert (this != other);
        this.myInjectedLanguageId = other.getInjectedLanguageId();
        this.myPrefix = other.getPrefix();
        this.mySuffix = other.getSuffix();
        this.myDisplayName = other.getDisplayName();
        this.setValuePattern(other.getValuePattern());
        this.setIgnorePattern(other.getIgnorePattern());
        this.mySingleFile = other.mySingleFile;
        this.myPlaces = (InjectionPlace[])other.getInjectionPlaces().clone();
        return this;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            BaseInjection.$$$reportNull$$$0(22);
        }
        PatternCompiler<PsiElement> helper = this.getCompiler();
        @NlsSafe String displayName = element.getChildTextTrim("display-name");
        this.myDisplayName = StringUtil.notNullize((String)displayName);
        this.myInjectedLanguageId = StringUtil.notNullize((String)element.getAttributeValue("language"));
        this.myPrefix = StringUtil.notNullize((String)BaseInjection.getValueOrContent(element, "prefix"));
        this.mySuffix = StringUtil.notNullize((String)BaseInjection.getValueOrContent(element, "suffix"));
        this.setValuePattern(BaseInjection.getValueOrContent(element, "value-pattern"));
        this.setIgnorePattern(BaseInjection.getValueOrContent(element, "ignore-pattern"));
        Element singleFileElement = element.getChild("single-file");
        this.mySingleFile = singleFileElement == null || Boolean.parseBoolean(singleFileElement.getAttributeValue("value", "true"));
        this.readExternalImpl(element);
        List placeElements = element.getChildren("place");
        this.myPlaces = (InjectionPlace[])InjectionPlace.ARRAY_FACTORY.create(placeElements.size());
        int placeElementsSize = placeElements.size();
        for (int i = 0; i < placeElementsSize; ++i) {
            Element placeElement = (Element)placeElements.get(i);
            boolean enabled = !Boolean.parseBoolean(placeElement.getAttributeValue("disabled"));
            String text = placeElement.getText();
            this.myPlaces[i] = new InjectionPlace((ElementPattern<? extends PsiElement>)helper.createElementPattern(text, this.getDisplayName()), enabled);
        }
        if (this.myPlaces.length == 0) {
            this.generatePlaces();
        }
    }

    private static String getValueOrContent(@NotNull Element element, String cname) {
        Element child;
        if (element == null) {
            BaseInjection.$$$reportNull$$$0(23);
        }
        if ((child = element.getChild(cname)) == null) {
            return null;
        }
        String attributeValue = child.getAttributeValue("value");
        if (attributeValue != null) {
            return attributeValue;
        }
        return child.getText();
    }

    public PatternCompiler<PsiElement> getCompiler() {
        return PatternCompilerFactory.getFactory().getPatternCompiler((Class[])InjectorUtils.getPatternClasses(this.getSupportId()));
    }

    public void generatePlaces() {
    }

    protected void readExternalImpl(Element e) {
    }

    public final Element getState() {
        Element e = new Element("injection");
        e.setAttribute("language", this.myInjectedLanguageId);
        e.setAttribute("injector-id", this.mySupportId);
        e.addContent(BaseInjection.withValueOrContent("display-name", this.getDisplayName()));
        if (StringUtil.isNotEmpty((String)this.myPrefix)) {
            e.addContent(BaseInjection.withValueOrContent("prefix", this.myPrefix));
        }
        if (StringUtil.isNotEmpty((String)this.mySuffix)) {
            e.addContent(BaseInjection.withValueOrContent("suffix", this.mySuffix));
        }
        if (StringUtil.isNotEmpty((String)this.myValuePattern)) {
            e.addContent(BaseInjection.withValueOrContent("value-pattern", this.myValuePattern));
        }
        if (StringUtil.isNotEmpty((String)this.myIgnorePattern)) {
            e.addContent(BaseInjection.withValueOrContent("ignore-pattern", this.myIgnorePattern));
        }
        e.addContent(new Element("single-file").setAttribute("value", this.mySingleFile ? "true" : "false"));
        Arrays.sort(this.myPlaces, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText())));
        for (InjectionPlace place : this.myPlaces) {
            Element child = new Element("place").setContent((Content)new CDATA(place.getText()));
            if (!place.isEnabled()) {
                child.setAttribute("disabled", "true");
            }
            e.addContent(child);
        }
        this.writeExternalImpl(e);
        return e;
    }

    private static Element withValueOrContent(String name, String value) {
        Element element = new Element(name);
        if (!value.isEmpty() && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            return element.setAttribute("value", value);
        }
        return element.setText(value);
    }

    protected void writeExternalImpl(Element e) {
    }

    @NotNull
    public String getValuePattern() {
        String string = this.myValuePattern;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void setValuePattern(@RegExp @Nullable String pattern) {
        try {
            if (pattern != null && pattern.length() > 0) {
                this.myValuePattern = pattern;
                this.myCompiledValuePattern = Pattern.compile(pattern, 32);
            } else {
                this.myValuePattern = "";
                this.myCompiledValuePattern = null;
            }
        }
        catch (Exception ex) {
            this.myCompiledValuePattern = null;
            Logger.getInstance((String)this.getClass().getName()).info("Invalid value-pattern", (Throwable)ex);
        }
    }

    @NotNull
    public String getIgnorePattern() {
        String string = this.myIgnorePattern;
        if (string == null) {
            BaseInjection.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void setIgnorePattern(@RegExp @Nullable String pattern) {
        try {
            if (pattern != null && pattern.length() > 0) {
                this.myIgnorePattern = pattern;
                this.myCompiledIgnorePattern = Pattern.compile(pattern, 32);
            } else {
                this.myIgnorePattern = "";
                this.myCompiledIgnorePattern = null;
            }
        }
        catch (Exception ex) {
            this.myCompiledIgnorePattern = null;
            Logger.getInstance((String)this.getClass().getName()).info("Invalid ignore-pattern", (Throwable)ex);
        }
    }

    public boolean isSingleFile() {
        return this.mySingleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.mySingleFile = singleFile;
    }

    public boolean isTerminal() {
        return this.myCompiledValuePattern == null;
    }

    private static List<TextRange> getMatchingRanges(Matcher matcher, int length) {
        SmartList list = new SmartList();
        int start = 0;
        while (start < length && matcher.find(start)) {
            int groupCount = matcher.groupCount();
            if (groupCount != 0) {
                for (int i = 1; i <= groupCount; ++i) {
                    start = matcher.start(i);
                    if (start == -1) continue;
                    list.add(new TextRange(start, matcher.end(i)));
                }
                if (start >= matcher.end()) break;
            }
            start = matcher.end();
        }
        return list;
    }

    public void mergeOriginalPlacesFrom(BaseInjection injection, boolean enabled) {
        for (InjectionPlace place : injection.getInjectionPlaces()) {
            if (ArrayUtil.contains((Object)place, (Object[])this.myPlaces)) continue;
            this.myPlaces = (InjectionPlace[])ArrayUtil.append((Object[])this.myPlaces, (Object)(enabled || !place.isEnabled() ? place : place.enabled(false)), InjectionPlace.ARRAY_FACTORY);
        }
    }

    public void setPlaceEnabled(@Nullable String text, boolean enabled) {
        for (int i = 0; i < this.myPlaces.length; ++i) {
            InjectionPlace cur = this.myPlaces[i];
            if (text != null && !Objects.equals(text, cur.getText()) || cur.isEnabled() == enabled) continue;
            this.myPlaces[i] = cur.enabled(enabled);
        }
    }

    public boolean acceptForReference(PsiElement element) {
        return this.acceptsPsiElement(element);
    }

    public String toString() {
        return this.getInjectedLanguageId() + "->" + this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 13, 15, 19, 20, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportId";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageId";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/config/BaseInjection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/config/BaseInjection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPlaces";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedLanguageId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedArea";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePattern";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnorePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setInjectionPlaces";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setInjectedLanguageId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setPrefix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSuffix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeIgnored";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getValueOrContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 13, 15, 19, 20, 24, 25 -> new IllegalStateException(string);
        };
    }
}

