/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferPool {
    public static final DirectByteBufferPool DEFAULT_POOL = new DirectByteBufferPool(it -> {});
    private static final int MIN_SIZE = 2048;
    private static final int MAX_POOL_SIZE = 32;
    private final ConcurrentSkipListMap<Integer, ByteBuffer> pool;
    private final AtomicInteger count;
    @NotNull
    private final Consumer<? super ByteBuffer> releaser;

    public DirectByteBufferPool(@NotNull Consumer<? super ByteBuffer> releaser) {
        if (releaser == null) {
            DirectByteBufferPool.$$$reportNull$$$0(0);
        }
        this.pool = new ConcurrentSkipListMap();
        this.count = new AtomicInteger();
        this.releaser = releaser;
    }

    @NotNull
    public ByteBuffer allocate(int requiredSize) {
        ByteBuffer result;
        Map.Entry<Integer, ByteBuffer> entry;
        int size = DirectByteBufferPool.roundUpInt(requiredSize, 2048);
        while ((entry = this.pool.ceilingEntry(size)) != null && !this.pool.remove(entry.getKey(), entry.getValue())) {
        }
        if (entry == null) {
            result = ByteBuffer.allocateDirect(size);
        } else {
            this.count.decrementAndGet();
            result = entry.getValue();
        }
        result.limit(requiredSize);
        ByteBuffer byteBuffer = result;
        if (byteBuffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(1);
        }
        return byteBuffer;
    }

    public void release(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(2);
        }
        if (buffer.isReadOnly()) {
            return;
        }
        buffer.rewind();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (this.count.get() < 32 && this.pool.putIfAbsent(buffer.capacity(), buffer) == null) {
            this.count.incrementAndGet();
        } else {
            this.releaser.accept(buffer);
        }
    }

    public void releaseAll() {
        Iterator<ByteBuffer> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            ByteBuffer buffer = iterator.next();
            iterator.remove();
            this.releaser.accept(buffer);
        }
    }

    private static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/DirectByteBufferPool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/DirectByteBufferPool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

