/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001f\u0010\u0013\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0005H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/editorconfig/language/codeinsight/actions/EditorConfigStatementUpDownMover;", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineMover;", "<init>", "()V", "checkAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "info", "Lcom/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover$MoveInfo;", "down", "orderMoveOption", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "orderMoveSection", "section", "Lorg/editorconfig/language/psi/EditorConfigSection;", "findOtherSection", "Lorg/jetbrains/annotations/Nullable;", "canMove", "range", "Lcom/intellij/codeInsight/editorActions/moveUpDown/LineRange;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigStatementUpDownMover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigStatementUpDownMover.kt\norg/editorconfig/language/codeinsight/actions/EditorConfigStatementUpDownMover\n+ 2 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n*L\n1#1,85:1\n23#2,2:86\n23#2,2:88\n*S KotlinDebug\n*F\n+ 1 EditorConfigStatementUpDownMover.kt\norg/editorconfig/language/codeinsight/actions/EditorConfigStatementUpDownMover\n*L\n27#1:86,2\n29#1:88,2\n*E\n"})
public final class EditorConfigStatementUpDownMover
extends LineMover {
    /*
     * WARNING - void declaration
     */
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        void $receiver$iv;
        EditorConfigPsiTreeUtil $receiver$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!(file instanceof EditorConfigPsiFile)) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return super.checkAvailable(editor, file, info, down);
        }
        LineRange lineRange = StatementUpDownMover.getLineRangeFromSelection((Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)lineRange, (String)"getLineRangeFromSelection(...)");
        LineRange range = lineRange;
        if (!this.canMove(editor, range, down)) {
            return false;
        }
        Pair pair = LineMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)range);
        if (pair == null) {
            return false;
        }
        PsiElement startElement = (PsiElement)ExtensionsKt.component1((Pair)pair);
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        Intrinsics.checkNotNull((Object)startElement);
        PsiElement psiElement = startElement;
        Class[] stopAt$iv = new Class[]{};
        boolean strict$iv22 = false;
        boolean $i$f$getParentOfType = false;
        EditorConfigOption option = (EditorConfigOption)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, EditorConfigOption.class, (boolean)strict$iv22, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length));
        if (option != null) {
            return this.orderMoveOption(info, down, option);
        }
        $receiver$iv2 = EditorConfigPsiTreeUtil.INSTANCE;
        PsiElement strict$iv22 = startElement;
        Class[] stopAt$iv2 = new Class[]{};
        boolean strict$iv = false;
        boolean $i$f$getParentOfType2 = false;
        EditorConfigSection section = (EditorConfigSection)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, EditorConfigSection.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv2, stopAt$iv2.length));
        if (section != null) {
            return this.orderMoveSection(info, down, section);
        }
        return info.prohibitMove();
    }

    private final boolean orderMoveOption(StatementUpDownMover.MoveInfo info, boolean down, EditorConfigOption option) {
        EditorConfigOption otherOptionInSection;
        info.toMove = new LineRange((PsiElement)option, (PsiElement)option);
        EditorConfigOption editorConfigOption = otherOptionInSection = down ? (EditorConfigOption)PsiTreeUtil.getNextSiblingOfType((PsiElement)option, EditorConfigOption.class) : (EditorConfigOption)PsiTreeUtil.getPrevSiblingOfType((PsiElement)option, EditorConfigOption.class);
        if (otherOptionInSection != null) {
            info.toMove2 = new LineRange((PsiElement)otherOptionInSection, (PsiElement)otherOptionInSection);
            return true;
        }
        EditorConfigSection section = option.getSection();
        EditorConfigSection otherSection = this.findOtherSection(section, down);
        if (otherSection == null) {
            return info.prohibitMove();
        }
        if (down) {
            int nextLine = info.toMove.endLine;
            int headerLine = new LineRange((PsiElement)((PsiElement)otherSection.getHeader()), (PsiElement)((PsiElement)otherSection.getHeader())).endLine;
            info.toMove2 = new LineRange(nextLine, headerLine);
        } else {
            LineRange otherSectionLineRange = new LineRange((PsiElement)otherSection, (PsiElement)otherSection);
            int lastLineInOtherSection = otherSectionLineRange.endLine;
            int lineBeforeCurrentOption = info.toMove.startLine;
            info.toMove2 = new LineRange(lastLineInOtherSection, lineBeforeCurrentOption);
        }
        return true;
    }

    private final boolean orderMoveSection(StatementUpDownMover.MoveInfo info, boolean down, EditorConfigSection section) {
        EditorConfigSection otherSection = this.findOtherSection(section, down);
        if (otherSection == null) {
            return info.prohibitMove();
        }
        info.toMove = new LineRange((PsiElement)section, (PsiElement)section);
        info.toMove2 = new LineRange((PsiElement)otherSection, (PsiElement)otherSection);
        return true;
    }

    private final EditorConfigSection findOtherSection(EditorConfigSection section, boolean down) {
        return down ? (EditorConfigSection)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)section), EditorConfigSection.class) : (EditorConfigSection)PsiTreeUtil.getPrevSiblingOfType((PsiElement)((PsiElement)section), EditorConfigSection.class);
    }

    private final boolean canMove(Editor editor, LineRange range, boolean down) {
        if (range.startLine == 0 && !down) {
            return false;
        }
        int maxLine = editor.offsetToLogicalPosition((int)editor.getDocument().getTextLength()).line;
        return !down || range.endLine <= maxLine;
    }
}

