/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class UriResolver {
    private String _baseUri;

    public String resolve(String uri) {
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this._baseUri == null) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.LOAD_BASE_URL_IS_NULL_TRYING_TO_CONFIGURE_ONE);
            try {
                URL result2 = new URL(uri);
                this.setBaseUri(result2.toExternalForm());
            }
            catch (MalformedURLException e) {
                try {
                    this.setBaseUri(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_DEFAULT_USERAGENT_IS_NOT_ABLE_TO_RESOLVE_BASE_URL_FOR, uri);
                    return null;
                }
            }
        }
        try {
            return new URL(uri).toString();
        }
        catch (MalformedURLException e) {
            XRLog.log(Level.FINE, LogMessageId.LogMessageId2Param.LOAD_COULD_NOT_READ_URI_AT_URL_MAY_BE_RELATIVE, (Object)uri, (Object)this._baseUri);
            try {
                URL result3 = new URL(new URL(this._baseUri), uri);
                ret = result3.toString();
                XRLog.log(Level.FINE, LogMessageId.LogMessageId2Param.LOAD_WAS_ABLE_TO_READ_FROM_URI_USING_PARENT_URL, (Object)uri, (Object)this._baseUri);
            }
            catch (MalformedURLException e1) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.EXCEPTION_DEFAULT_USERAGENT_IS_NOT_ABLE_TO_RESOLVE_URL_WITH_BASE_URL, (Object)uri, (Object)this._baseUri);
            }
            return ret;
        }
    }

    public void setBaseUri(String baseUri) {
        this._baseUri = baseUri;
    }

    public String getBaseUri() {
        return this._baseUri;
    }
}

