/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.style.derived;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.Idents;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.Conversions;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.LengthValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FSLinearGradient {
    private final List<StopPoint> _stopPoints;
    private final float _angle;
    private int x1;
    private int x2;
    private int y1;
    private int y2;

    public FSLinearGradient(CalculatedStyle style, FSFunction function, int boxWidth, int boxHeight, CssContext ctx2) {
        List<PropertyValue> params = function.getParameters();
        int stopsStartIndex = this.getStopsStartIndex(params);
        float prelimAngle = this.calculateAngle(params, stopsStartIndex);
        prelimAngle %= 360.0f;
        if (prelimAngle < 0.0f) {
            prelimAngle += 360.0f;
        }
        this._angle = prelimAngle;
        this._stopPoints = this.calculateStopPoints(params, style, ctx2, boxWidth, stopsStartIndex);
        this.endPointsFromAngle(this._angle, boxWidth, boxHeight);
    }

    private float deg2rad(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void endPointsFromAngle(float angleDeg, int w, int h) {
        float yEnd;
        float xEnd;
        if (angleDeg == 0.0f) {
            this.x1 = 0;
            this.y1 = h;
            this.x2 = 0;
            this.y2 = 0;
            return;
        }
        if (angleDeg == 90.0f) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = w;
            this.y2 = 0;
            return;
        }
        if (angleDeg == 180.0f) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = 0;
            this.y2 = h;
            return;
        }
        if (angleDeg == 270.0f) {
            this.x1 = w;
            this.y1 = 0;
            this.x2 = 0;
            this.y2 = 0;
            return;
        }
        float slope = (float)Math.tan(this.deg2rad(90.0f - angleDeg));
        float perpendicularSlope = -1.0f / slope;
        float halfHeight = h / 2;
        float halfWidth = w / 2;
        if (angleDeg < 90.0f) {
            xEnd = halfWidth;
            yEnd = halfHeight;
        } else if (angleDeg < 180.0f) {
            xEnd = halfWidth;
            yEnd = -halfHeight;
        } else if (angleDeg < 270.0f) {
            xEnd = -halfWidth;
            yEnd = -halfHeight;
        } else {
            xEnd = -halfWidth;
            yEnd = halfHeight;
        }
        float c = yEnd - perpendicularSlope * xEnd;
        float endX = c / (slope - perpendicularSlope);
        float endY = perpendicularSlope * endX + c;
        this.x2 = (int)(halfWidth + endX);
        this.y2 = (int)(halfHeight - endY);
        this.x1 = (int)(halfWidth - endX);
        this.y1 = (int)(halfHeight + endY);
    }

    private boolean isLengthOrPercentage(PropertyValue value2) {
        return AbstractPropertyBuilder.isLengthHelper(value2) || value2.getPrimitiveType() == 2;
    }

    private List<StopPoint> calculateStopPoints(List<PropertyValue> params, CalculatedStyle style, CssContext ctx2, float boxWidth, int stopsStartIndex) {
        ArrayList<IntermediateStopPoint> points = new ArrayList<IntermediateStopPoint>();
        int i = stopsStartIndex;
        while (i < params.size()) {
            PropertyValue value2 = params.get(i);
            FSColor color = value2.getPrimitiveType() == 21 ? Conversions.getColor(value2.getStringValue()) : value2.getFSColor();
            if (i + 1 < params.size() && this.isLengthOrPercentage(params.get(i + 1))) {
                PropertyValue lengthValue = params.get(i + 1);
                float length = LengthValue.calcFloatProportionalValue(style, CSSName.BACKGROUND_IMAGE, "", lengthValue.getFloatValue(), lengthValue.getPrimitiveType(), boxWidth, ctx2);
                points.add(new StopPoint(color, length));
                i += 2;
                continue;
            }
            points.add(new IntermediateStopPoint(color));
            ++i;
        }
        ArrayList<StopPoint> ret = new ArrayList<StopPoint>(points.size());
        for (int i2 = 0; i2 < points.size(); ++i2) {
            boolean intermediate;
            IntermediateStopPoint pt = (IntermediateStopPoint)points.get(i2);
            boolean bl = intermediate = pt.getClass() == IntermediateStopPoint.class;
            if (!intermediate) {
                ret.add((StopPoint)pt);
                continue;
            }
            if (i2 == 0) {
                ret.add(new StopPoint(pt.getColor(), 0.0f));
                continue;
            }
            if (i2 == points.size() - 1) {
                float len = this.get100PercentDefaultStopLength(style, ctx2, boxWidth);
                ret.add(new StopPoint(pt.getColor(), len));
                continue;
            }
            int nextWithLengthIndex = this.getNextStopPointWithLengthIndex(points, i2 + 1);
            int prevWithLengthIndex = this.getPrevStopPointWithLengthIndex(points, i2 - 1);
            float nextLength = nextWithLengthIndex == -1 ? this.get100PercentDefaultStopLength(style, ctx2, boxWidth) : ((StopPoint)points.get(nextWithLengthIndex)).getLength();
            float prevLength = prevWithLengthIndex == -1 ? 0.0f : ((StopPoint)points.get(prevWithLengthIndex)).getLength();
            float range = nextLength - prevLength;
            int topRangeIndex = nextWithLengthIndex == -1 ? points.size() - 1 : nextWithLengthIndex;
            int bottomRangeIndex = prevWithLengthIndex == -1 ? 0 : prevWithLengthIndex;
            int rangeCount = topRangeIndex - bottomRangeIndex + 1;
            int thisCount = i2 - bottomRangeIndex;
            if (rangeCount == 0) continue;
            float interval = range / (float)rangeCount;
            float thisLength = prevLength + interval * (float)thisCount;
            ret.add(new StopPoint(pt.getColor(), thisLength));
        }
        return ret;
    }

    private int getPrevStopPointWithLengthIndex(List<IntermediateStopPoint> points, int maxIndex) {
        for (int i = maxIndex; i >= 0; --i) {
            if (!this.isStopPointWithLength(points.get(i))) continue;
            return i;
        }
        return -1;
    }

    private float get100PercentDefaultStopLength(CalculatedStyle style, CssContext ctx2, float boxWidth) {
        return LengthValue.calcFloatProportionalValue(style, CSSName.BACKGROUND_IMAGE, "100%", 100.0f, (short)2, boxWidth, ctx2);
    }

    private boolean isStopPointWithLength(IntermediateStopPoint pt) {
        return pt.getClass() == StopPoint.class;
    }

    private int getNextStopPointWithLengthIndex(List<IntermediateStopPoint> points, int startIndex) {
        for (int i = startIndex; i < points.size(); ++i) {
            if (!this.isStopPointWithLength(points.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getStopsStartIndex(List<PropertyValue> params) {
        if (Objects.equals(params.get(0).getStringValue(), "to")) {
            int i;
            for (i = 1; i < params.size() && params.get(i).getStringValue() != null && Idents.looksLikeABGPosition(params.get(i).getStringValue()); ++i) {
            }
            return i;
        }
        return 1;
    }

    private float calculateAngle(List<PropertyValue> params, int stopsStartIndex) {
        if (Objects.equals(params.get(0).getStringValue(), "to")) {
            ArrayList<String> positions = new ArrayList<String>(2);
            for (int i = 1; i < stopsStartIndex; ++i) {
                positions.add(params.get(i).getStringValue());
            }
            if (positions.contains("top") && positions.contains("left")) {
                return 315.0f;
            }
            if (positions.contains("top") && positions.contains("right")) {
                return 45.0f;
            }
            if (positions.contains("bottom") && positions.contains("left")) {
                return 225.0f;
            }
            if (positions.contains("bottom") && positions.contains("right")) {
                return 135.0f;
            }
            if (positions.contains("bottom")) {
                return 180.0f;
            }
            if (positions.contains("left")) {
                return 270.0f;
            }
            if (positions.contains("right")) {
                return 90.0f;
            }
            return 0.0f;
        }
        if (params.get(0).getPrimitiveType() == 11) {
            return params.get(0).getFloatValue();
        }
        if (params.get(0).getPrimitiveType() == 12) {
            return params.get(0).getFloatValue() * 57.29578f;
        }
        return 0.0f;
    }

    public List<StopPoint> getStopPoints() {
        return this._stopPoints;
    }

    public float getAngle() {
        return this._angle;
    }

    public int getX1() {
        return this.x1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public String toString() {
        return "FSLinearGradient [_angle=" + this._angle + ", _stopPoints=" + this._stopPoints + ", x1=" + this.x1 + ", x2=" + this.x2 + ", y1=" + this.y1 + ", y2=" + this.y2 + "]";
    }

    public static class StopPoint
    extends IntermediateStopPoint {
        private final float _length;

        StopPoint(FSColor color, float length) {
            super(color);
            this._length = length;
        }

        public float getLength() {
            return this._length;
        }

        public String toString() {
            return "StopPoint [length=" + this._length + ", color=" + this.getColor() + "]";
        }
    }

    private static class IntermediateStopPoint {
        private final FSColor _color;

        IntermediateStopPoint(FSColor color) {
            this._color = color;
        }

        public FSColor getColor() {
            return this._color;
        }
    }
}

