/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.UIThemeExportableBean;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.NewUI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.bridge.BridgeOverride;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.UiThemeExtensionsKt;
import org.jetbrains.jewel.foundation.InternalJewelApi;
import org.jetbrains.jewel.foundation.theme.JewelTheme;
import org.jetbrains.jewel.ui.painter.PainterHint;
import org.jetbrains.jewel.ui.painter.PalettePainterHintsProvider;
import org.jetbrains.jewel.ui.painter.hints.ColorBasedPaletteReplacementKt;
import org.jetbrains.jewel.ui.painter.hints.DarkAndStrokeKt;
import org.jetbrains.jewel.ui.painter.hints.HiDpiKt;
import org.jetbrains.jewel.ui.painter.hints.KeyBasedPaletteReplacementKt;
import org.jetbrains.jewel.ui.util.ColorExtensionsKt;

@InternalJewelApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!BY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J,\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0017\u00a2\u0006\u0002\u0010 R\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/jewel/bridge/BridgePainterHintsProvider;", "Lorg/jetbrains/jewel/ui/painter/PalettePainterHintsProvider;", "isDark", "", "intellijIconPalette", "", "", "themeIconPalette", "themeColorPalette", "Landroidx/compose/ui/graphics/Color;", "<init>", "(ZLjava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "checkBoxByColorPaletteHint", "Lorg/jetbrains/jewel/ui/painter/PainterHint;", "getCheckBoxByColorPaletteHint", "()Lorg/jetbrains/jewel/ui/painter/PainterHint;", "checkBoxByKeyPaletteHint", "getCheckBoxByKeyPaletteHint", "treePaletteHint", "getTreePaletteHint", "uiPaletteHint", "getUiPaletteHint", "registerColorBasedReplacement", "", "map", "", "key", "value", "registerIdBasedReplacement", "hints", "", "path", "(Ljava/lang/String;Landroidx/compose/runtime/Composer;I)Ljava/util/List;", "Companion", "ide-laf-bridge"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nBridgePainterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgePainterHintsProvider.kt\norg/jetbrains/jewel/bridge/BridgePainterHintsProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n24#2:146\n*S KotlinDebug\n*F\n+ 1 BridgePainterHintsProvider.kt\norg/jetbrains/jewel/bridge/BridgePainterHintsProvider\n*L\n104#1:146\n*E\n"})
public final class BridgePainterHintsProvider
extends PalettePainterHintsProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PainterHint checkBoxByColorPaletteHint;
    @NotNull
    private final PainterHint checkBoxByKeyPaletteHint;
    @NotNull
    private final PainterHint treePaletteHint;
    @NotNull
    private final PainterHint uiPaletteHint;
    public static final int $stable;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> supportedCheckboxKeys;

    private BridgePainterHintsProvider(boolean isDark, Map<String, String> intellijIconPalette, Map<String, String> themeIconPalette, Map<String, Color> themeColorPalette) {
        super(isDark, intellijIconPalette, themeIconPalette, themeColorPalette);
        Map ui = new LinkedHashMap();
        Map checkBoxesByColor = new LinkedHashMap();
        Map checkBoxesByKey = new LinkedHashMap();
        Map trees = new LinkedHashMap();
        for (Map.Entry<String, String> entry : themeIconPalette.entrySet()) {
            Map<Color, Color> map;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            if (StringsKt.startsWith$default((String)key, (String)"Checkbox.", (boolean)false, (int)2, null) && NewUI.isEnabled()) {
                this.registerIdBasedReplacement(checkBoxesByKey, key, value);
            }
            if (this.selectMap(key, checkBoxesByColor, trees, ui) == null) continue;
            this.registerColorBasedReplacement(map, key, value);
        }
        this.checkBoxByKeyPaletteHint = KeyBasedPaletteReplacementKt.KeyBasedPaletteReplacement(checkBoxesByKey);
        this.checkBoxByColorPaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement(checkBoxesByColor);
        this.treePaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement(trees);
        this.uiPaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement(ui);
    }

    /* synthetic */ BridgePainterHintsProvider(boolean bl, Map map, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(bl, map, map2, map3);
    }

    @Override
    @NotNull
    protected PainterHint getCheckBoxByColorPaletteHint() {
        return this.checkBoxByColorPaletteHint;
    }

    @Override
    @NotNull
    protected PainterHint getCheckBoxByKeyPaletteHint() {
        return this.checkBoxByKeyPaletteHint;
    }

    @Override
    @NotNull
    protected PainterHint getTreePaletteHint() {
        return this.treePaletteHint;
    }

    @Override
    @NotNull
    protected PainterHint getUiPaletteHint() {
        return this.uiPaletteHint;
    }

    private final void registerColorBasedReplacement(Map<Color, Color> map, String key, String value) {
        Color color = this.resolveKeyColor-8tov2TA(key, this.getIntellijIconPalette(), this.isDark());
        if (color == null) {
            return;
        }
        long keyAsColor = color.unbox-impl();
        Color color2 = this.resolveColor-ijrfgN4(value);
        if (color2 == null) {
            return;
        }
        long resolvedColor = color2.unbox-impl();
        Color color3 = Color.box-impl(keyAsColor);
        Color color4 = Color.box-impl(resolvedColor);
        map.put(color3, color4);
    }

    private final void registerIdBasedReplacement(Map<String, Color> map, String key, String value) {
        Color parsedValue;
        String adjustedKey;
        String string2 = adjustedKey = this.isDark() ? StringsKt.removeSuffix((String)key, (CharSequence)".Dark") : key;
        if (!supportedCheckboxKeys.contains(adjustedKey)) {
            logger.debug((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " is not supported, will be ignored");
            return;
        }
        if (!Intrinsics.areEqual((Object)adjustedKey, (Object)key)) {
            logger.warn((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " is deprecated, use " + adjustedKey + " instead");
        }
        if ((parsedValue = this.resolveColor-ijrfgN4(value)) == null) {
            logger.info((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " has invalid value: '" + value + "'");
            return;
        }
        map.put(adjustedKey, parsedValue);
    }

    @Override
    @Composable
    @NotNull
    public List<PainterHint> hints(@NotNull String path, @Nullable Composer $composer, int $changed) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $composer.startReplaceGroup(1115015623);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart(1115015623, $changed, -1, "org.jetbrains.jewel.bridge.BridgePainterHintsProvider.hints (BridgePainterHintsProvider.kt:95)");
        }
        List $this$hints_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$hints_u24lambda_u240.add(BridgeOverride.INSTANCE);
        $this$hints_u24lambda_u240.add(this.getPaletteHint(path, BridgeUtilsKt.isNewUiTheme()));
        $this$hints_u24lambda_u240.add(HiDpiKt.HiDpi());
        $this$hints_u24lambda_u240.add(DarkAndStrokeKt.Dark(JewelTheme.Companion.isDark($composer, 6)));
        List list3 = CollectionsKt.build((List)list2);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return list3;
    }

    public /* synthetic */ BridgePainterHintsProvider(boolean isDark, Map intellijIconPalette, Map themeIconPalette, Map themeColorPalette, DefaultConstructorMarker $constructor_marker) {
        this(isDark, intellijIconPalette, themeIconPalette, themeColorPalette);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BridgePainterHintsProvider.logger = logger;
        Object[] objectArray = new String[]{"Checkbox.Background.Default", "Checkbox.Border.Default", "Checkbox.Foreground.Selected", "Checkbox.Background.Selected", "Checkbox.Border.Selected", "Checkbox.Focus.Wide", "Checkbox.Foreground.Disabled", "Checkbox.Background.Disabled", "Checkbox.Border.Disabled"};
        supportedCheckboxKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/jewel/bridge/BridgePainterHintsProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "invoke", "Lorg/jetbrains/jewel/ui/painter/PalettePainterHintsProvider;", "isDark", "", "supportedCheckboxKeys", "", "", "ide-laf-bridge"})
    @SourceDebugExtension(value={"SMAP\nBridgePainterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgePainterHintsProvider.kt\norg/jetbrains/jewel/bridge/BridgePainterHintsProvider$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n462#2:146\n412#2:147\n462#2:152\n412#2:153\n1246#3,4:148\n1246#3,4:154\n*S KotlinDebug\n*F\n+ 1 BridgePainterHintsProvider.kt\norg/jetbrains/jewel/bridge/BridgePainterHintsProvider$Companion\n*L\n113#1:146\n113#1:147\n121#1:152\n121#1:153\n113#1:148,4\n121#1:154,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PalettePainterHintsProvider invoke(boolean isDark) {
            void $this$mapValuesTo$iv$iv;
            Object object;
            Object object2;
            Object k;
            Object object3;
            void $this$mapValuesTo$iv$iv2;
            UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = UiThemeExtensionsKt.currentUiThemeOrNull();
            if (uIThemeLookAndFeelInfo == null) {
                return new BridgePainterHintsProvider(isDark, null, null, null, 14, null);
            }
            UIThemeLookAndFeelInfo uiTheme = uIThemeLookAndFeelInfo;
            logger.info("Parsing theme info from theme " + uiTheme.getName() + " (id: " + uiTheme.getId() + ", isDark: " + uiTheme.isDark() + ")");
            UIThemeExportableBean bean = uiTheme.describe();
            Map map = bean.getColorPalette();
            Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map $this$mapValues$iv = map;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                object3 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = map3;
                boolean bl2 = false;
                Object value = it.getValue();
                object = value instanceof String ? (String)value : (value instanceof java.awt.Color ? ColorExtensionsKt.toRgbaHexString((java.awt.Color)value) : null);
                object2.put(k, object);
            }
            Map iconColorPalette = destination$iv$iv;
            Map keyPalette = UITheme.Companion.getColorPalette();
            Map $this$mapValues$iv2 = bean.getColors();
            boolean $i$f$mapValues2 = false;
            Map $i$f$mapValuesTo22 = $this$mapValues$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it$iv$iv;
                Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv2;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = object3;
                boolean bl3 = false;
                int v = ((Number)entry.getValue()).intValue();
                object = Color.box-impl(ColorKt.Color(v));
                object2.put(k, object);
            }
            Map themeColors = destination$iv$iv2;
            return new BridgePainterHintsProvider(isDark, keyPalette, iconColorPalette, themeColors, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

