/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.UpdateInteractionRequest;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class UpdateInteractionTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateInteractionTransportAction.class);
    Client client;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public UpdateInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, OpenSearchConversationalMemoryHandler cmHandler, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/interaction/update", transportService, actionFilters, UpdateInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        if (!this.featureIsEnabled) {
            listener.onFailure((Exception)new OpenSearchException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        UpdateInteractionRequest updateInteractionRequest = UpdateInteractionRequest.fromActionRequest(request);
        String interactionId = updateInteractionRequest.getInteractionId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            Map<String, Object> updateContent = updateInteractionRequest.getUpdateContent();
            this.cmHandler.updateInteraction(interactionId, updateContent, this.getUpdateResponseListener(interactionId, listener, context));
        }
        catch (Exception e) {
            log.error("Failed to update Message with ID " + interactionId, (Throwable)e);
            listener.onFailure(e);
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String interactionId, ActionListener<UpdateResponse> actionListener, ThreadContext.StoredContext context) {
        return ActionListener.runBefore((ActionListener)ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("Successfully updated the Message with ID: {}", (Object)interactionId);
                actionListener.onResponse(updateResponse);
            } else {
                log.info("Failed to update the Message with ID: {}", (Object)interactionId);
                actionListener.onResponse(updateResponse);
            }
        }, exception -> {
            log.error("Failed to update ML Message with ID " + interactionId, (Throwable)exception);
            actionListener.onFailure(exception);
        }), () -> ((ThreadContext.StoredContext)context).restore());
    }
}

