/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.AnomalyDetectorExecutionInput;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.PreviewAnomalyDetectorAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestPreviewAnomalyDetectorAction
extends BaseRestHandler {
    public static final String PREVIEW_ANOMALY_DETECTOR_ACTION = "preview_anomaly_detector";
    private static final Logger logger = LogManager.getLogger(RestPreviewAnomalyDetectorAction.class);

    public String getName() {
        return PREVIEW_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        AnomalyDetectorExecutionInput input = this.getConfigExecutionInput(request);
        return channel -> {
            String rawPath = request.rawPath();
            String error = this.validateAdExecutionInput(input);
            if (StringUtils.isNotBlank((String)error)) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, error));
                return;
            }
            PreviewAnomalyDetectorRequest previewRequest = new PreviewAnomalyDetectorRequest(input.getDetector(), input.getDetectorId(), input.getPeriodStart(), input.getPeriodEnd());
            client.execute((ActionType)PreviewAnomalyDetectorAction.INSTANCE, (ActionRequest)previewRequest, (ActionListener)new RestToXContentListener(channel));
        };
    }

    private AnomalyDetectorExecutionInput getConfigExecutionInput(RestRequest request) throws IOException {
        String detectorId = null;
        if (request.hasParam("detectorID")) {
            detectorId = request.param("detectorID");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        AnomalyDetectorExecutionInput input = AnomalyDetectorExecutionInput.parse(parser, detectorId);
        return input;
    }

    private String validateAdExecutionInput(AnomalyDetectorExecutionInput input) {
        if (input.getPeriodStart() == null || input.getPeriodEnd() == null) {
            return "Must set both period start and end date with epoch of milliseconds";
        }
        if (!input.getPeriodStart().isBefore(input.getPeriodEnd())) {
            return "Period start date should be before end date";
        }
        if (Strings.isEmpty((CharSequence)input.getDetectorId()) && input.getDetector() == null) {
            return "Must set detector id or detector";
        }
        return null;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s", "/_plugins/_anomaly_detection/detectors", "_preview")));
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_preview"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_preview")));
    }
}

