/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.rest.AbstractForecasterAction;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.IndexForecasterAction;
import org.opensearch.forecast.transport.IndexForecasterRequest;
import org.opensearch.forecast.transport.IndexForecasterResponse;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.owasp.encoder.Encode;

public class RestIndexForecasterAction
extends AbstractForecasterAction {
    private static final String INDEX_FORECASTER_ACTION = "index_forecaster_action";
    private final Logger logger = LogManager.getLogger(RestIndexForecasterAction.class);

    public RestIndexForecasterAction(Settings settings, ClusterService clusterService) {
        super(settings, clusterService);
    }

    public String getName() {
        return INDEX_FORECASTER_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterId = request.param("forecasterID", "");
            this.logger.info("Forecaster {} action for forecasterId {}", (Object)request.method(), (Object)forecasterId);
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Forecaster forecaster = Forecaster.parse(parser, forecasterId, null, this.forecastInterval, this.forecastWindowDelay);
            long seqNo = request.paramAsLong("if_seq_no", -2L);
            long primaryTerm = request.paramAsLong("if_primary_term", 0L);
            WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
            RestRequest.Method method = request.getHttpRequest().method();
            if (method == RestRequest.Method.POST && forecasterId != "") {
                forecasterId = "";
            }
            IndexForecasterRequest indexAnomalyDetectorRequest = new IndexForecasterRequest(forecasterId, seqNo, primaryTerm, refreshPolicy, forecaster, method, this.requestTimeout, this.maxSingleStreamForecasters, this.maxHCForecasters, this.maxForecastFeatures, this.maxCategoricalFields);
            return channel -> client.execute((ActionType)IndexForecasterAction.INSTANCE, (ActionRequest)indexAnomalyDetectorRequest, this.indexForecasterResponse((RestChannel)channel, method));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
        catch (ValidationException e) {
            throw new OpenSearchStatusException(e.getMessage(), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_forecast/forecasters"), (Object)new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_forecast/forecasters", "forecasterID")));
    }

    private RestResponseListener<IndexForecasterResponse> indexForecasterResponse(RestChannel channel, final RestRequest.Method method) {
        return new RestResponseListener<IndexForecasterResponse>(channel){

            public RestResponse buildResponse(IndexForecasterResponse response) throws Exception {
                RestStatus restStatus = RestStatus.CREATED;
                if (method == RestRequest.Method.PUT) {
                    restStatus = RestStatus.OK;
                }
                BytesRestResponse bytesRestResponse = new BytesRestResponse(restStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restStatus == RestStatus.CREATED) {
                    String location = String.format(Locale.ROOT, "%s/%s", "/_plugins/_forecast", response.getId());
                    bytesRestResponse.addHeader("Location", location);
                }
                return bytesRestResponse;
            }
        };
    }
}

