/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.annotation.Generated;

public class ForecastResultBucket
implements ToXContentObject,
Writeable {
    public static final String BUCKETS_FIELD = "buckets";
    public static final String KEY_FIELD = "key";
    public static final String DOC_COUNT_FIELD = "doc_count";
    public static final String BUCKET_INDEX_FIELD = "bucket_index";
    private final Map<String, Object> key;
    private final int docCount;
    private final Map<String, Double> aggregations;
    private final int bucketIndex;

    public ForecastResultBucket(Map<String, Object> key, int docCount, Map<String, Double> aggregations, int bucketIndex) {
        this.key = key;
        this.docCount = docCount;
        this.aggregations = aggregations;
        this.bucketIndex = bucketIndex;
    }

    public ForecastResultBucket(StreamInput input) throws IOException {
        this.key = input.readMap();
        this.docCount = input.readInt();
        this.aggregations = input.readMap(StreamInput::readString, StreamInput::readDouble);
        this.bucketIndex = input.readInt();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(KEY_FIELD, this.key).field(DOC_COUNT_FIELD, this.docCount).field(BUCKET_INDEX_FIELD, this.bucketIndex);
        for (Map.Entry<String, Double> entry : this.aggregations.entrySet()) {
            xContentBuilder.field(entry.getKey(), entry.getValue());
        }
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.key);
        out.writeInt(this.docCount);
        out.writeMap(this.aggregations, StreamOutput::writeString, StreamOutput::writeDouble);
        out.writeInt(this.bucketIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecastResultBucket that = (ForecastResultBucket)o;
        return Objects.equal(this.key, that.getKey()) && Objects.equal((Object)this.docCount, (Object)that.getDocCount()) && Objects.equal(this.aggregations, that.getAggregations()) && Objects.equal((Object)this.bucketIndex, (Object)that.getBucketIndex());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.docCount, this.aggregations, this.bucketIndex});
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append(KEY_FIELD, this.key).append("docCount", this.docCount).append("aggregations", this.aggregations).append("bucketIndex", this.bucketIndex).toString();
    }

    public Map<String, Object> getKey() {
        return this.key;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public Map<String, Double> getAggregations() {
        return this.aggregations;
    }

    public int getBucketIndex() {
        return this.bucketIndex;
    }
}

