/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport;

import java.time.Instant;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.StepListener;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.PutTIFJobRequest;
import org.opensearch.securityanalytics.threatIntel.action.ThreatIntelIndicesResponse;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.TIFJobParameter;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobParameterService;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobUpdateService;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportPutTIFJobAction
extends HandledTransportAction<PutTIFJobRequest, AcknowledgedResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportPutTIFJobAction.class);
    private final TIFJobParameterService tifJobParameterService;
    private final TIFJobUpdateService tifJobUpdateService;
    private final TIFLockService lockService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportPutTIFJobAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, TIFJobParameterService tifJobParameterService, TIFJobUpdateService tifJobUpdateService, TIFLockService lockService, Settings settings) {
        super("cluster:admin/security_analytics/tifjob/put", transportService, actionFilters, PutTIFJobRequest::new);
        this.tifJobParameterService = tifJobParameterService;
        this.tifJobUpdateService = tifJobUpdateService;
        this.lockService = lockService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
    }

    protected void doExecute(Task task, PutTIFJobRequest request, ActionListener<AcknowledgedResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        try {
            this.lockService.acquireLock(request.getName(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> {
                if (lock == null) {
                    listener.onFailure((Exception)new ConcurrentModificationException("another processor is holding a lock on the resource. Try again later"));
                    log.error("another processor is a lock, BAD_REQUEST error", (Object)RestStatus.BAD_REQUEST);
                    return;
                }
                try {
                    this.internalDoExecute(request, (LockModel)lock, listener);
                }
                catch (Exception e) {
                    log.error("Failed execution to put tif job action", (Throwable)e);
                    this.lockService.releaseLock((LockModel)lock, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId());
                        listener.onFailure(e);
                    }, ex -> {
                        log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), request.getName()), (Throwable)ex);
                        listener.onFailure(e);
                    }));
                }
            }, exception -> {
                listener.onFailure(exception);
                log.error("execution failed", (Throwable)exception);
            }));
        }
        catch (Exception e) {
            log.error("Failed to acquire lock for job", (Throwable)e);
            listener.onFailure(e);
        }
    }

    protected void internalDoExecute(PutTIFJobRequest request, LockModel lock, ActionListener<AcknowledgedResponse> listener) {
        StepListener createIndexStepListener = new StepListener();
        createIndexStepListener.whenComplete(v -> {
            try {
                TIFJobParameter tifJobParameter = TIFJobParameter.Builder.build(request);
                this.tifJobParameterService.saveTIFJobParameter(tifJobParameter, this.postIndexingTifJobParameter(tifJobParameter, lock, listener));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, exception -> {
            log.error("Failed to save tif job parameter", (Throwable)exception);
            this.lockService.releaseLock(lock, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId());
                listener.onFailure(exception);
            }, ex -> {
                log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), request.getName()), (Throwable)ex);
                listener.onFailure(exception);
            }));
        });
        this.tifJobParameterService.createJobIndexIfNotExists((StepListener<Void>)createIndexStepListener);
    }

    protected ActionListener<IndexResponse> postIndexingTifJobParameter(TIFJobParameter tifJobParameter, LockModel lock, ActionListener<AcknowledgedResponse> listener) {
        return ActionListener.wrap(indexResponse -> {
            AtomicReference<LockModel> lockReference = new AtomicReference<LockModel>(lock);
            this.createThreatIntelFeedData(tifJobParameter, this.lockService.getRenewLockRunnable(lockReference), (ActionListener<ThreatIntelIndicesResponse>)ActionListener.wrap(threatIntelIndicesResponse -> {
                if (threatIntelIndicesResponse.isAcknowledged().booleanValue()) {
                    this.lockService.releaseLock((LockModel)lockReference.get(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId());
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }, ex -> {
                        log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), tifJobParameter.getName()), (Throwable)ex);
                        listener.onFailure(ex);
                    }));
                } else {
                    listener.onFailure((Exception)new OpenSearchStatusException("creation of threat intel feed data failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            Exception exception;
            if (e instanceof VersionConflictEngineException) {
                log.error("tifJobParameter already exists");
                exception = new ResourceAlreadyExistsException("tifJobParameter [{}] already exists", new Object[]{tifJobParameter.getName()});
            } else {
                log.error("Internal server error");
                exception = e;
            }
            this.lockService.releaseLock(lock, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                log.debug("Released tif job parameter lock with id [{}]", (Object)lock.getLockId());
                listener.onFailure(exception);
            }, ex -> {
                log.error(String.format("Unexpected failure while trying to release lock [%s] for tif job parameter [%s].", lock.getLockId(), tifJobParameter.getName()), (Throwable)ex);
                listener.onFailure(exception);
            }));
        });
    }

    protected void createThreatIntelFeedData(TIFJobParameter tifJobParameter, Runnable renewLock, ActionListener<ThreatIntelIndicesResponse> listener) {
        if (!TIFJobState.CREATING.equals((Object)tifJobParameter.getState())) {
            log.error("Invalid tifJobParameter state. Expecting {} but received {}", (Object)TIFJobState.CREATING, (Object)tifJobParameter.getState());
            this.markTIFJobAsCreateFailed(tifJobParameter, listener);
            return;
        }
        try {
            this.tifJobUpdateService.createThreatIntelFeedData(tifJobParameter, renewLock, listener);
        }
        catch (Exception e) {
            log.error("Failed to create tifJobParameter for {}", (Object)tifJobParameter.getName(), (Object)e);
            this.markTIFJobAsCreateFailed(tifJobParameter, listener);
        }
    }

    private void markTIFJobAsCreateFailed(TIFJobParameter tifJobParameter, ActionListener<ThreatIntelIndicesResponse> listener) {
        tifJobParameter.getUpdateStats().setLastFailedAt(Instant.now());
        tifJobParameter.setState(TIFJobState.CREATE_FAILED);
        try {
            this.tifJobParameterService.updateJobSchedulerParameter(tifJobParameter, listener);
        }
        catch (Exception e) {
            log.error("Failed to mark tifJobParameter state as CREATE_FAILED for {}", (Object)tifJobParameter.getName(), (Object)e);
        }
    }
}

