/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.template.delete.DeleteComponentTemplateAction;
import org.opensearch.action.admin.indices.template.delete.DeleteComposableIndexTemplateAction;
import org.opensearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.securityanalytics.mapper.IndexTemplateUtils;
import org.opensearch.securityanalytics.model.CreateMappingResult;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.securityanalytics.util.XContentUtils;

public class IndexTemplateManager {
    private static final Logger log = LogManager.getLogger(IndexTemplateManager.class);
    public static String OPENSEARCH_SAP_COMPONENT_TEMPLATE_PREFIX = ".opensearch-sap-alias-mappings-component-";
    public static String OPENSEARCH_SAP_INDEX_TEMPLATE_PREFIX = ".opensearch-sap-alias-mappings-index-template-";
    private Client client;
    private ClusterService clusterService;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private NamedXContentRegistry xContentRegistry;

    public IndexTemplateManager(Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.xContentRegistry = xContentRegistry;
    }

    public void upsertIndexTemplateWithAliasMappings(String indexName, Collection<CreateMappingResult> createMappingResults, ActionListener<AcknowledgedResponse> actionListener) {
        ClusterState state = this.clusterService.state();
        if (IndexUtils.isConcreteIndex(indexName, state)) {
            actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException("Can't upsert index template for concrete index!")));
            return;
        }
        String concreteIndexName = IndexUtils.getWriteIndex(indexName, state);
        if (concreteIndexName == null) {
            String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.LENIENT_EXPAND_OPEN, new String[]{indexName});
            if (concreteIndices.length == 0) {
                actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException("Can't upsert index template for concrete index!")));
                return;
            }
            concreteIndexName = IndexUtils.getNewestIndexByCreationDate(concreteIndices, state);
        }
        String cin = concreteIndexName;
        Optional<CreateMappingResult> createMappingResult = createMappingResults.stream().filter(e -> e.getConcreteIndexName().equals(cin)).findFirst();
        if (!createMappingResult.isPresent()) {
            actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException("Can't upsert index template for concrete index!")));
            return;
        }
        Map<String, Object> mappings = createMappingResult.get().getMappings();
        StepListener upsertComponentTemplateStepListener = new StepListener();
        this.upsertComponentTemplate(indexName, this.client, state, mappings, (ActionListener<AcknowledgedResponse>)upsertComponentTemplateStepListener);
        upsertComponentTemplateStepListener.whenComplete(acknowledgedResponse -> {
            ComposableIndexTemplate template;
            String templateName = MetadataIndexTemplateService.findV2Template((Metadata)state.metadata(), (String)IndexTemplateUtils.normalizeIndexName(indexName), (boolean)false);
            if (templateName == null) {
                templateName = MetadataIndexTemplateService.findV2Template((Metadata)state.metadata(), (String)IndexTemplateUtils.normalizeIndexName(cin), (boolean)false);
            }
            if (templateName == null) {
                Map conflictingTemplates = MetadataIndexTemplateService.findConflictingV2Templates((ClusterState)state, (String)IndexTemplateUtils.computeIndexTemplateName(indexName), List.of(this.computeIndexPattern(indexName)));
                if (conflictingTemplates.size() == 1) {
                    String conflictingTemplateName = (String)conflictingTemplates.keySet().iterator().next();
                    if (conflictingTemplateName.startsWith(OPENSEARCH_SAP_INDEX_TEMPLATE_PREFIX)) {
                        templateName = conflictingTemplateName;
                    } else {
                        String errorMessage = "Found conflicting template: [" + conflictingTemplateName + "]";
                        log.error(errorMessage);
                        actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException(errorMessage)));
                    }
                } else if (conflictingTemplates.size() > 1) {
                    String errorMessage = "Found conflicting templates: [" + String.join((CharSequence)", ", conflictingTemplates.keySet()) + "]";
                    log.error(errorMessage);
                    actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException(errorMessage)));
                    return;
                }
            }
            String componentName = IndexTemplateUtils.computeComponentTemplateName(indexName);
            if (templateName == null) {
                template = new ComposableIndexTemplate(List.of(this.computeIndexPattern(indexName)), null, List.of(componentName), null, null, null);
                templateName = IndexTemplateUtils.computeIndexTemplateName(indexName);
                this.upsertIndexTemplate(this.client, true, template, templateName, actionListener);
            } else {
                template = (ComposableIndexTemplate)state.metadata().templatesV2().get(templateName);
                if (!template.composedOf().contains(componentName)) {
                    ArrayList<String> newComposedOf = new ArrayList<String>(template.composedOf());
                    ArrayList<String> indexPatterns = new ArrayList<String>(template.indexPatterns());
                    indexPatterns.add(this.computeIndexPattern(indexName));
                    newComposedOf.add(componentName);
                    try {
                        template = new ComposableIndexTemplate(indexPatterns, IndexTemplateUtils.copyTemplate(template.template()), newComposedOf, template.priority(), template.version(), template.metadata(), template.getDataStreamTemplate());
                        this.upsertIndexTemplate(this.client, false, template, templateName, actionListener);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                        actionListener.onFailure((Exception)e);
                    }
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }
        }, arg_0 -> actionListener.onFailure(arg_0));
    }

    private String computeIndexPattern(String indexName) {
        return !indexName.endsWith("*") ? indexName + "*" : indexName;
    }

    private void upsertIndexTemplate(Client client, boolean create, ComposableIndexTemplate indexTemplate, String templateName, final ActionListener<AcknowledgedResponse> actionListener) {
        client.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)new PutComposableIndexTemplateAction.Request(templateName).indexTemplate(indexTemplate).create(create), (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                actionListener.onResponse((Object)acknowledgedResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void upsertComponentTemplate(String indexName, Client client, ClusterState state, Map<String, Object> mappings, final ActionListener<AcknowledgedResponse> actionListener) {
        String componentName = IndexTemplateUtils.computeComponentTemplateName(indexName);
        boolean create = !state.metadata().componentTemplates().containsKey(componentName);
        this.upsertComponentTemplate(componentName, create, client, mappings, new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                actionListener.onResponse((Object)acknowledgedResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void upsertComponentTemplate(String componentName, boolean create, Client client, Map<String, Object> mappings, final ActionListener<AcknowledgedResponse> actionListener) {
        try {
            String mappingsJson = XContentUtils.parseMapToJsonString(mappings);
            ComponentTemplate componentTemplate = new ComponentTemplate(new Template(null, new CompressedXContent(mappingsJson), null), Long.valueOf(0L), null);
            PutComponentTemplateAction.Request req = new PutComponentTemplateAction.Request(componentName).componentTemplate(componentTemplate).create(create);
            client.execute((ActionType)PutComponentTemplateAction.INSTANCE, (ActionRequest)req, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    actionListener.onResponse((Object)acknowledgedResponse);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            actionListener.onFailure((Exception)e);
        }
    }

    public void deleteAllUnusedTemplates(ActionListener<Void> actionListener) {
        Map<String, ComposableIndexTemplate> allSapTemplates = IndexTemplateUtils.getAllSapComposableIndexTemplates(this.clusterService.state());
        StepListener getDetectorInputsListener = new StepListener();
        DetectorUtils.getAllDetectorInputs(this.client, this.xContentRegistry, (ActionListener<Set<String>>)getDetectorInputsListener);
        getDetectorInputsListener.whenComplete(allInputIndices -> {
            StepListener doDeleteUnusedTemplatesListener = new StepListener();
            this.doDeleteUnusedTemplates(allSapTemplates, (Set<String>)allInputIndices, (ActionListener<Map<String, ComposableIndexTemplate>>)doDeleteUnusedTemplatesListener);
            doDeleteUnusedTemplatesListener.whenComplete(deletedTemplates -> {
                this.doDeleteUnusedComponentTemplates(actionListener);
                actionListener.onResponse(null);
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0));
        }, arg_0 -> actionListener.onFailure(arg_0));
    }

    private void doDeleteUnusedComponentTemplates(final ActionListener<Void> actionListener) {
        Set<String> componentTemplates = IndexTemplateUtils.getAllSapComponentTemplates(this.clusterService.state());
        this.clusterService.state().metadata().templatesV2().forEach((name, template) -> template.composedOf().forEach(componentTemplates::remove));
        if (componentTemplates.size() == 0) {
            actionListener.onResponse(null);
        }
        GroupedActionListener deleteMultipleComponentTemplatesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<AcknowledgedResponse>>(){

            public void onResponse(Collection<AcknowledgedResponse> responses) {
                actionListener.onResponse(null);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        }, componentTemplates.size());
        componentTemplates.forEach(name -> this.client.execute((ActionType)DeleteComponentTemplateAction.INSTANCE, (ActionRequest)new DeleteComponentTemplateAction.Request(name), (ActionListener)deleteMultipleComponentTemplatesListener));
    }

    private void doDeleteUnusedTemplates(Map<String, ComposableIndexTemplate> allSapTemplates, Set<String> allDetectorInputIndices, final ActionListener<Map<String, ComposableIndexTemplate>> actionListener) {
        final HashMap<String, ComposableIndexTemplate> toDeleteTemplates = new HashMap<String, ComposableIndexTemplate>();
        for (Map.Entry<String, ComposableIndexTemplate> entry : allSapTemplates.entrySet()) {
            String templateName = entry.getKey();
            ComposableIndexTemplate template2 = entry.getValue();
            boolean matched = false;
            for (String index : allDetectorInputIndices) {
                if (IndexUtils.isConcreteIndex(index, this.clusterService.state()) || !template2.indexPatterns().stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)IndexTemplateUtils.normalizeIndexName(index)))) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            toDeleteTemplates.put(templateName, template2);
        }
        if (toDeleteTemplates.size() == 0) {
            actionListener.onResponse(toDeleteTemplates);
            return;
        }
        GroupedActionListener deleteMultipleTemplatesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<AcknowledgedResponse>>(){

            public void onResponse(Collection<AcknowledgedResponse> responses) {
                actionListener.onResponse((Object)toDeleteTemplates);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        }, toDeleteTemplates.size());
        toDeleteTemplates.forEach((name, template) -> this.client.execute((ActionType)DeleteComposableIndexTemplateAction.INSTANCE, (ActionRequest)new DeleteComposableIndexTemplateAction.Request(name), (ActionListener)deleteMultipleTemplatesListener));
    }
}

