/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.utilities.SimpleMath;

public class DCGScorer
extends MetricScorer {
    protected static double[] discount = null;
    protected static double[] gain = null;

    public DCGScorer() {
        this.k = 10;
        if (discount == null) {
            int i;
            discount = new double[5000];
            for (i = 0; i < discount.length; ++i) {
                DCGScorer.discount[i] = 1.0 / SimpleMath.logBase2(i + 2);
            }
            gain = new double[6];
            for (i = 0; i < 6; ++i) {
                DCGScorer.gain[i] = (1 << i) - 1;
            }
        }
    }

    public DCGScorer(int k) {
        this.k = k;
        if (discount == null) {
            int i;
            discount = new double[5000];
            for (i = 0; i < discount.length; ++i) {
                DCGScorer.discount[i] = 1.0 / SimpleMath.logBase2(i + 2);
            }
            gain = new double[6];
            for (i = 0; i < 6; ++i) {
                DCGScorer.gain[i] = (1 << i) - 1;
            }
        }
    }

    @Override
    public MetricScorer copy() {
        return new DCGScorer();
    }

    @Override
    public double score(RankList rl) {
        if (rl.size() == 0) {
            return 0.0;
        }
        int size = this.k;
        if (this.k > rl.size() || this.k <= 0) {
            size = rl.size();
        }
        int[] rel = this.getRelevanceLabels(rl);
        return this.getDCG(rel, size);
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int[] rel = this.getRelevanceLabels(rl);
        int size = rl.size() > this.k ? this.k : rl.size();
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
        }
        for (i = 0; i < size; ++i) {
            for (int j = i + 1; j < rl.size(); ++j) {
                double d = (this.discount(i) - this.discount(j)) * (this.gain(rel[i]) - this.gain(rel[j]));
                changes[i][j] = d;
                changes[j][i] = d;
            }
        }
        return changes;
    }

    @Override
    public String name() {
        return "DCG@" + this.k;
    }

    protected double getDCG(int[] rel, int topK) {
        double dcg = 0.0;
        for (int i = 0; i < topK; ++i) {
            dcg += this.gain(rel[i]) * this.discount(i);
        }
        return dcg;
    }

    protected double discount(int index) {
        int cacheSize;
        if (index < discount.length) {
            return discount[index];
        }
        for (cacheSize = discount.length + 1000; cacheSize <= index; cacheSize += 1000) {
        }
        double[] tmp = new double[cacheSize];
        System.arraycopy(discount, 0, tmp, 0, discount.length);
        for (int i = discount.length; i < tmp.length; ++i) {
            tmp[i] = 1.0 / SimpleMath.logBase2(i + 2);
        }
        discount = tmp;
        return discount[index];
    }

    protected double gain(int rel) {
        int cacheSize;
        if (rel < gain.length) {
            return gain[rel];
        }
        for (cacheSize = gain.length + 10; cacheSize <= rel; cacheSize += 10) {
        }
        double[] tmp = new double[cacheSize];
        System.arraycopy(gain, 0, tmp, 0, gain.length);
        for (int i = gain.length; i < tmp.length; ++i) {
            tmp[i] = (1 << i) - 1;
        }
        gain = tmp;
        return gain[rel];
    }
}

