/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.internal.InternalSearchResponse;

public class RestActionUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(RestActionUtils.class);
    private static final Logger logger = LogManager.getLogger(RestActionUtils.class);
    public static final String SECURITY_AUTHCZ_ADMIN_DN = "plugins.security.authcz.admin_dn";
    public static final String PARAMETER_ALGORITHM = "algorithm";
    public static final String PARAMETER_ASYNC = "async";
    public static final String PARAMETER_RETURN_CONTENT = "return_content";
    public static final String PARAMETER_MODEL_ID = "model_id";
    public static final String PARAMETER_AGENT_ID = "agent_id";
    public static final String PARAMETER_TASK_ID = "task_id";
    public static final String PARAMETER_CONNECTOR_ID = "connector_id";
    public static final String PARAMETER_DEPLOY_MODEL = "deploy";
    public static final String PARAMETER_VERSION = "version";
    public static final String PARAMETER_MODEL_GROUP_ID = "model_group_id";
    public static final String PARAMETER_CONFIG_ID = "config_id";
    public static final String OPENSEARCH_DASHBOARDS_USER_AGENT = "OpenSearch Dashboards";
    public static final String[] UI_METADATA_EXCLUDE = new String[]{"ui_metadata"};
    public static final String PARAMETER_TOOL_NAME = "tool_name";
    public static final String OPENDISTRO_SECURITY_CONFIG_PREFIX = "_opendistro_security_";
    public static final String OPENDISTRO_SECURITY_USER = "_opendistro_security_user";
    static final Set<LdapName> adminDn = new HashSet<LdapName>();
    static final Set<String> adminUsernames = new HashSet<String>();
    static final ObjectMapper objectMapper = new ObjectMapper();

    public static String getAlgorithm(RestRequest request) {
        String algorithm = request.param(PARAMETER_ALGORITHM);
        if (Strings.isNullOrEmpty((String)algorithm)) {
            throw new IllegalArgumentException("Request should contain algorithm!");
        }
        return algorithm.toUpperCase(Locale.ROOT);
    }

    public static boolean isAsync(RestRequest request) {
        return request.paramAsBoolean(PARAMETER_ASYNC, false);
    }

    public static boolean returnContent(RestRequest request) {
        return request.paramAsBoolean(PARAMETER_RETURN_CONTENT, false);
    }

    public static String getParameterId(RestRequest request, String idName) {
        String id = request.param(idName);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("Request should contain " + idName);
        }
        return id;
    }

    public static FetchSourceContext getSourceContext(RestRequest request, SearchSourceBuilder searchSourceBuilder) {
        String userAgent = RestActionUtils.coalesceToEmpty(request.header("User-Agent"));
        if (searchSourceBuilder.fetchSource() != null) {
            Object[] includes = searchSourceBuilder.fetchSource().includes();
            Object[] excludes = searchSourceBuilder.fetchSource().excludes();
            if (!ArrayUtils.contains((Object[])includes, (Object)"model_content")) {
                ArrayUtils.add((Object[])excludes, (Object)"model_content");
            }
            if (!ArrayUtils.contains((Object[])includes, (Object)"content")) {
                ArrayUtils.add((Object[])excludes, (Object)"content");
            }
            String[] metadataExcludes = new String[excludes.length + 1];
            if (!userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
                if (excludes.length == 0) {
                    return new FetchSourceContext(true, (String[])includes, UI_METADATA_EXCLUDE);
                }
                System.arraycopy(excludes, 0, metadataExcludes, 0, excludes.length);
                metadataExcludes[metadataExcludes.length - 1] = "ui_metadata";
                return new FetchSourceContext(true, (String[])includes, metadataExcludes);
            }
            return new FetchSourceContext(true, (String[])includes, (String[])excludes);
        }
        Object[] excludes = new String[]{"content", "model_content"};
        if (!userAgent.contains(OPENSEARCH_DASHBOARDS_USER_AGENT)) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])ArrayUtils.add((Object[])excludes, (Object)"ui_metadata"));
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])excludes);
    }

    public static FetchSourceContext getFetchSourceContext(boolean returnModelContent) {
        if (!returnModelContent) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, new String[]{"content", "model_content"});
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    public static String[] getAllNodes(ClusterService clusterService) {
        Iterator iterator = clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    public static void onFailure(RestChannel channel, RestStatus status, String errorMessage, Exception exception) {
        BytesRestResponse bytesRestResponse;
        try {
            bytesRestResponse = new BytesRestResponse(channel, exception);
        }
        catch (Exception e) {
            bytesRestResponse = new BytesRestResponse(status, errorMessage);
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    @VisibleForTesting
    public static Optional<String[]> splitCommaSeparatedParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName)).map(s -> s.split(","));
    }

    private static String coalesceToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    public static Optional<String> getStringParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName));
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Current user is " + userStr);
        return User.parse((String)userStr);
    }

    public static boolean isSuperAdminUser(ClusterService clusterService, Client client) {
        List adminDnsA = clusterService.getSettings().getAsList(SECURITY_AUTHCZ_ADMIN_DN, Collections.emptyList());
        for (String dn : adminDnsA) {
            try {
                logger.debug("{} is registered as an admin dn", (Object)dn);
                adminDn.add(new LdapName(dn));
            }
            catch (InvalidNameException e) {
                logger.debug("Unable to parse admin dn {}", (Object)dn, (Object)e);
                adminUsernames.add(dn);
            }
        }
        Object userObject = client.threadPool().getThreadContext().getTransient(OPENDISTRO_SECURITY_USER);
        if (userObject == null) {
            return false;
        }
        try {
            return AccessController.doPrivileged(() -> {
                String userContext = objectMapper.writeValueAsString(userObject);
                JsonNode node = objectMapper.readTree(userContext);
                String userName = node.get("name").asText();
                return RestActionUtils.isAdminDN(userName);
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAdminDN(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return RestActionUtils.isAdminDN(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return adminUsernames.contains(dn);
        }
    }

    private static boolean isAdminDN(LdapName dn) {
        if (dn == null) {
            return false;
        }
        boolean isAdmin = adminDn.contains(dn);
        if (logger.isTraceEnabled()) {
            logger.trace("Is principal {} an admin cert? {}", (Object)dn.toString(), (Object)isAdmin);
        }
        return isAdmin;
    }

    public static void wrapListenerToHandleSearchIndexNotFound(Exception e, ActionListener<SearchResponse> listener) {
        if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException || ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.debug("Connectors index not created yet, therefore we will swallow the exception and return an empty search result");
            InternalSearchResponse internalSearchResponse = InternalSearchResponse.empty();
            SearchResponse emptySearchResponse = new SearchResponse((SearchResponseSections)internalSearchResponse, null, 0, 0, 0, 0L, new ShardSearchFailure[0], SearchResponse.Clusters.EMPTY, null);
            listener.onResponse((Object)emptySearchResponse);
        } else {
            listener.onFailure(e);
        }
    }

    public static String getActionTypeFromRestRequest(RestRequest request) {
        String path = request.path();
        String[] segments = path.split("/");
        String methodName = segments[segments.length - 1];
        String string = methodName = methodName.startsWith("_") ? methodName.substring(1) : methodName;
        if (!ConnectorAction.ActionType.isValidAction((String)methodName) && segments.length > 3) {
            methodName = segments[3];
            methodName = methodName.contains("_") ? methodName.split("_")[1] : methodName;
        }
        return methodName;
    }
}

