/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.settings;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.common.settings.SettingsChangeListener;
import org.opensearch.ml.settings.MLCommonsSettings;

public class MLFeatureEnabledSetting {
    private volatile Boolean isRemoteInferenceEnabled;
    private volatile Boolean isAgentFrameworkEnabled;
    private volatile Boolean isLocalModelEnabled;
    private volatile AtomicBoolean isConnectorPrivateIpEnabled;
    private volatile Boolean isControllerEnabled;
    private volatile Boolean isBatchIngestionEnabled;
    private volatile Boolean isBatchInferenceEnabled;
    private volatile Boolean isMultiTenancyEnabled;
    private final List<SettingsChangeListener> listeners = new ArrayList<SettingsChangeListener>();

    public MLFeatureEnabledSetting(ClusterService clusterService, Settings settings) {
        this.isRemoteInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED.get(settings);
        this.isAgentFrameworkEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED.get(settings);
        this.isLocalModelEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED.get(settings);
        this.isConnectorPrivateIpEnabled = new AtomicBoolean((Boolean)MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED.get(settings));
        this.isControllerEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_CONTROLLER_ENABLED.get(settings);
        this.isBatchIngestionEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INGESTION_ENABLED.get(settings);
        this.isBatchInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INFERENCE_ENABLED.get(settings);
        this.isMultiTenancyEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MULTI_TENANCY_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, it -> {
            this.isRemoteInferenceEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED, it -> {
            this.isAgentFrameworkEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED, it -> {
            this.isLocalModelEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED, it -> this.isConnectorPrivateIpEnabled.set((boolean)it));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONTROLLER_ENABLED, it -> {
            this.isControllerEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INGESTION_ENABLED, it -> {
            this.isBatchIngestionEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INFERENCE_ENABLED, it -> {
            this.isBatchInferenceEnabled = it;
        });
    }

    public boolean isRemoteInferenceEnabled() {
        return this.isRemoteInferenceEnabled;
    }

    public boolean isAgentFrameworkEnabled() {
        return this.isAgentFrameworkEnabled;
    }

    public boolean isLocalModelEnabled() {
        return this.isLocalModelEnabled;
    }

    public AtomicBoolean isConnectorPrivateIpEnabled() {
        return this.isConnectorPrivateIpEnabled;
    }

    public Boolean isControllerEnabled() {
        return this.isControllerEnabled;
    }

    public Boolean isOfflineBatchIngestionEnabled() {
        return this.isBatchIngestionEnabled;
    }

    public Boolean isOfflineBatchInferenceEnabled() {
        return this.isBatchInferenceEnabled;
    }

    public boolean isMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }

    public void addListener(SettingsChangeListener listener) {
        this.listeners.add(listener);
    }

    @VisibleForTesting
    void notifyMultiTenancyListeners(boolean isEnabled) {
        for (SettingsChangeListener listener : this.listeners) {
            listener.onMultiTenancyEnabledChanged(isEnabled);
        }
    }
}

