/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.memory.action.conversation.UpdateInteractionAction;
import org.opensearch.ml.memory.action.conversation.UpdateInteractionRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMemoryUpdateInteractionAction
extends BaseRestHandler {
    private static final String ML_UPDATE_INTERACTION_ACTION = "ml_update_interaction_action";

    public String getName() {
        return ML_UPDATE_INTERACTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_ml/memory/message/{message_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateInteractionRequest updateInteractionRequest = this.getRequest(request);
        return restChannel -> client.execute((ActionType)UpdateInteractionAction.INSTANCE, (ActionRequest)updateInteractionRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    @VisibleForTesting
    private UpdateInteractionRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new OpenSearchParseException("Failed to update interaction: Request body is empty", new Object[0]);
        }
        String interactionId = RestActionUtils.getParameterId(request, "message_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return UpdateInteractionRequest.parse((XContentParser)parser, (String)interactionId);
    }
}

