/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupAction;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUpdateModelGroupAction
extends BaseRestHandler {
    private static final String ML_UPDATE_MODEL_GROUP_ACTION = "ml_update_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/model_groups/{%s}", "/_plugins/_ml", "model_group_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateModelGroupRequest updateModelGroupRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUpdateModelGroupAction.INSTANCE, (ActionRequest)updateModelGroupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLUpdateModelGroupRequest getRequest(RestRequest request) throws IOException {
        String modelGroupID = RestActionUtils.getParameterId(request, "model_group_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        boolean hasContent = request.hasContent();
        if (!hasContent) {
            throw new IOException("Model group request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLUpdateModelGroupInput input = MLUpdateModelGroupInput.parse((XContentParser)parser);
        input.setModelGroupID(modelGroupID);
        input.setTenantId(tenantId);
        return new MLUpdateModelGroupRequest(input);
    }
}

