/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class CertificateInfo
implements Writeable,
ToXContent {
    private final String subject;
    private final String san;
    private final String issuer;
    private final String notAfter;
    private final String notBefore;

    public CertificateInfo(String subject, String san, String issuer, String notAfter, String notBefore) {
        this.subject = subject;
        this.san = san;
        this.issuer = issuer;
        this.notAfter = notAfter;
        this.notBefore = notBefore;
    }

    public CertificateInfo(StreamInput in) throws IOException {
        this.subject = in.readOptionalString();
        this.san = in.readOptionalString();
        this.issuer = in.readOptionalString();
        this.notAfter = in.readOptionalString();
        this.notBefore = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.subject);
        out.writeOptionalString(this.san);
        out.writeOptionalString(this.issuer);
        out.writeOptionalString(this.notAfter);
        out.writeOptionalString(this.notBefore);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("subject_dn", this.subject).field("san", this.san).field("issuer_dn", this.issuer).field("not_after", this.notAfter).field("not_before", this.notAfter).endObject();
    }

    public static CertificateInfo from(X509Certificate x509Certificate, String subjectAlternativeNames) {
        String subject = null;
        String issuer = null;
        String notAfter = null;
        String notBefore = null;
        if (x509Certificate != null) {
            if (x509Certificate.getSubjectX500Principal() != null) {
                subject = x509Certificate.getSubjectX500Principal().getName();
            }
            if (x509Certificate.getIssuerX500Principal() != null) {
                issuer = x509Certificate.getIssuerX500Principal().getName();
            }
            if (x509Certificate.getNotAfter() != null) {
                notAfter = x509Certificate.getNotAfter().toInstant().toString();
            }
            if (x509Certificate.getNotBefore() != null) {
                notBefore = x509Certificate.getNotBefore().toInstant().toString();
            }
        }
        return new CertificateInfo(subject, subjectAlternativeNames, issuer, notAfter, notBefore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateInfo that = (CertificateInfo)o;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.san, that.san) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.notAfter, that.notAfter) && Objects.equals(this.notBefore, that.notBefore);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.san, this.issuer, this.notAfter, this.notBefore);
    }
}

