/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.ExactMatchDimFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.NumericMapper;

abstract class NumericDecimalFieldMapper
extends NumericMapper {
    NumericDecimalFieldMapper() {
    }

    @Override
    public DimensionFilter getExactMatchFilter(MappedFieldType mappedFieldType, List<Object> rawValues) {
        NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)mappedFieldType;
        ArrayList<Object> convertedValues = new ArrayList<Object>(rawValues.size());
        for (Object rawValue : rawValues) {
            convertedValues.add(this.convertToDocValues(numberFieldType.numberType().parse(rawValue, true)));
        }
        return new ExactMatchDimFilter(mappedFieldType.name(), convertedValues);
    }

    @Override
    public DimensionFilter getRangeMatchFilter(MappedFieldType mappedFieldType, Object rawLow, Object rawHigh, boolean includeLow, boolean includeHigh) {
        NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)mappedFieldType;
        Number l = Long.MIN_VALUE;
        Number u = Long.MAX_VALUE;
        if (rawLow != null) {
            l = numberFieldType.numberType().parse(rawLow, false);
            if (!includeLow) {
                l = this.getNextHigh(l);
            }
            l = this.convertToDocValues(l);
        }
        if (rawHigh != null) {
            u = numberFieldType.numberType().parse(rawHigh, false);
            if (!includeHigh) {
                u = this.getNextLow(u);
            }
            u = this.convertToDocValues(u);
        }
        return new RangeMatchDimFilter(numberFieldType.name(), l, u, true, true);
    }

    abstract long convertToDocValues(Number var1);

    abstract Number getNextLow(Number var1);

    abstract Number getNextHigh(Number var1);
}

