/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Setting;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.tasks.Task;

@PublicApi(since="1.0.0")
public abstract class BaseRestHandler
implements RestHandler {
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);
    private final LongAdder usageCount = new LongAdder();
    @Deprecated
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected static final String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    public abstract String getName();

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestChannelConsumer action = this.prepareRequest(request, client);
        SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams().contains(p)).collect(Collectors.toCollection(TreeSet::new));
        if (!unconsumedParams.isEmpty()) {
            HashSet<String> candidateParams = new HashSet<String>();
            candidateParams.addAll(request.consumedParams());
            candidateParams.addAll(this.responseParams());
            throw new IllegalArgumentException(this.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
        }
        this.usageCount.increment();
        action.accept(channel);
    }

    public static String unrecognizedStrings(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder(String.format(Locale.ROOT, "request [%s] contains unrecognized %s%s: ", request.path(), detail, invalids.size() > 1 ? "s" : ""));
        boolean first = true;
        for (String invalid : invalids) {
            LevenshteinDistance ld = new LevenshteinDistance();
            ArrayList<Tuple> scoredParams = new ArrayList<Tuple>();
            for (String candidate : candidates) {
                float distance = ld.getDistance(invalid, candidate);
                if (!(distance > 0.5f)) continue;
                scoredParams.add(new Tuple((Object)Float.valueOf(distance), (Object)candidate));
            }
            CollectionUtil.timSort(scoredParams, (a, b) -> {
                int compare = ((Float)a.v1()).compareTo((Float)b.v1());
                if (compare != 0) {
                    return -compare;
                }
                return ((String)a.v2()).compareTo((String)b.v2());
            });
            if (!first) {
                message.append(", ");
            }
            message.append("[").append(invalid).append("]");
            List keys = scoredParams.stream().map(Tuple::v2).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                message.append(" -> did you mean ");
                if (keys.size() == 1) {
                    message.append("[").append((String)keys.get(0)).append("]");
                } else {
                    message.append("any of ").append(keys.toString());
                }
                message.append("?");
            }
            first = false;
        }
        return message.toString();
    }

    protected final String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        return BaseRestHandler.unrecognizedStrings(request, invalids, candidates, detail);
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    public static void parseDeprecatedMasterTimeoutParameter(ClusterManagerNodeRequest mnr, RestRequest request) {
        if (request.hasParam("master_timeout")) {
            if (request.hasParam("cluster_manager_timeout")) {
                throw new OpenSearchParseException(DUPLICATE_PARAMETER_ERROR_MESSAGE, new Object[0]);
            }
            mnr.clusterManagerNodeTimeout(request.paramAsTime("master_timeout", mnr.clusterManagerNodeTimeout()));
        }
    }

    public RestChannelConsumer sendTask(String nodeId, Task task) {
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", nodeId + ":" + task.getId());
                builder.endObject();
                channel.sendResponse(new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception> {
    }

    public static class Wrapper
    extends BaseRestHandler {
        protected final BaseRestHandler delegate;

        public Wrapper(BaseRestHandler delegate) {
            this.delegate = Objects.requireNonNull(delegate, "BaseRestHandler delegate can not be null");
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public List<RestHandler.Route> routes() {
            return this.delegate.routes();
        }

        @Override
        public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
            return this.delegate.deprecatedRoutes();
        }

        @Override
        public List<RestHandler.ReplacedRoute> replacedRoutes() {
            return this.delegate.replacedRoutes();
        }

        @Override
        protected RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            return this.delegate.prepareRequest(request, client);
        }

        @Override
        protected Set<String> responseParams() {
            return this.delegate.responseParams();
        }

        @Override
        public boolean canTripCircuitBreaker() {
            return this.delegate.canTripCircuitBreaker();
        }

        @Override
        public boolean supportsContentStream() {
            return this.delegate.supportsContentStream();
        }

        @Override
        public boolean allowsUnsafeBuffers() {
            return this.delegate.allowsUnsafeBuffers();
        }

        @Override
        public boolean allowSystemIndexAccessByDefault() {
            return this.delegate.allowSystemIndexAccessByDefault();
        }

        @Override
        public boolean supportsStreaming() {
            return this.delegate.supportsStreaming();
        }
    }

    @FunctionalInterface
    @ExperimentalApi
    protected static interface StreamingRestChannelConsumer
    extends CheckedConsumer<StreamingRestChannel, Exception> {
    }
}

