/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.opensearch.knn.common.KNNVectorUtil;
import org.opensearch.knn.index.codec.nativeindex.IndexBuildSetup;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.QuantizationIndexUtils;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.codec.transfer.OffHeapVectorTransfer;
import org.opensearch.knn.index.codec.transfer.OffHeapVectorTransferFactory;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.jni.JNIService;

final class MemOptimizedNativeIndexBuildStrategy
implements NativeIndexBuildStrategy {
    private static MemOptimizedNativeIndexBuildStrategy INSTANCE = new MemOptimizedNativeIndexBuildStrategy();

    public static MemOptimizedNativeIndexBuildStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public void buildAndWriteIndex(BuildIndexParams indexInfo) throws IOException {
        KNNVectorValues<?> knnVectorValues = indexInfo.getVectorValues();
        KNNCodecUtil.initializeVectorValues(knnVectorValues);
        KNNEngine engine = indexInfo.getKnnEngine();
        Map<String, Object> indexParameters = indexInfo.getParameters();
        IndexBuildSetup indexBuildSetup = QuantizationIndexUtils.prepareIndexBuild(knnVectorValues, indexInfo);
        long indexMemoryAddress = AccessController.doPrivileged(() -> JNIService.initIndex(indexInfo.getTotalLiveDocs(), indexBuildSetup.getDimensions(), indexParameters, engine));
        try (OffHeapVectorTransfer<Object> vectorTransfer = OffHeapVectorTransferFactory.getVectorTransfer(indexInfo.getVectorDataType(), indexBuildSetup.getBytesPerVector(), indexInfo.getTotalLiveDocs());){
            ArrayList<Integer> transferredDocIds = new ArrayList<Integer>(vectorTransfer.getTransferLimit());
            while (knnVectorValues.docId() != Integer.MAX_VALUE) {
                Object vector = QuantizationIndexUtils.processAndReturnVector(knnVectorValues, indexBuildSetup);
                boolean transferred = vectorTransfer.transfer(vector, false);
                transferredDocIds.add(knnVectorValues.docId());
                if (transferred) {
                    long vectorAddress = vectorTransfer.getVectorAddress();
                    AccessController.doPrivileged(() -> {
                        JNIService.insertToIndex(KNNVectorUtil.intListToArray(transferredDocIds), vectorAddress, indexBuildSetup.getDimensions(), indexParameters, indexMemoryAddress, engine);
                        return null;
                    });
                    transferredDocIds.clear();
                }
                knnVectorValues.nextDoc();
            }
            boolean flush = vectorTransfer.flush(false);
            if (flush) {
                long vectorAddress = vectorTransfer.getVectorAddress();
                AccessController.doPrivileged(() -> {
                    JNIService.insertToIndex(KNNVectorUtil.intListToArray(transferredDocIds), vectorAddress, indexBuildSetup.getDimensions(), indexParameters, indexMemoryAddress, engine);
                    return null;
                });
                transferredDocIds.clear();
            }
            AccessController.doPrivileged(() -> {
                JNIService.writeIndex(indexInfo.getIndexOutputWithBuffer(), indexMemoryAddress, engine, indexParameters);
                return null;
            });
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to build index, field name [" + indexInfo.getFieldName() + "], parameters " + String.valueOf(indexInfo), exception);
        }
    }

    @Generated
    private MemOptimizedNativeIndexBuildStrategy() {
    }
}

