/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;

public class IssuerFingerprint
extends SignatureSubpacket {
    public IssuerFingerprint(boolean bl, boolean bl2, byte[] byArray) {
        super(33, bl, bl2, byArray);
    }

    public IssuerFingerprint(boolean bl, int n, byte[] byArray) {
        super(33, bl, false, Arrays.prepend((byte[])byArray, (byte)((byte)n)));
    }

    public int getKeyVersion() {
        return this.data[0] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange((byte[])this.data, (int)1, (int)this.data.length);
    }

    public long getKeyID() {
        if (this.getKeyVersion() == 4) {
            return FingerprintUtil.keyIdFromV4Fingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 5) {
            return FingerprintUtil.keyIdFromLibrePgpFingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 6) {
            return FingerprintUtil.keyIdFromV6Fingerprint(this.getFingerprint());
        }
        return 0L;
    }
}

