/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.PrebuiltFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.lucene.search.Query;
import org.opensearch.common.Nullable;

public class PrebuiltFeatureSet
implements FeatureSet {
    private final List<Query> features;
    private final String name;

    public PrebuiltFeatureSet(@Nullable String name, List<PrebuiltFeature> features) {
        this.name = name;
        this.features = new ArrayList<Query>((Collection)Objects.requireNonNull(features));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Query> toQueries(LtrQueryContext context, Map<String, Object> params) {
        return this.features;
    }

    @Override
    public int featureOrdinal(String featureName) {
        int ord = this.findFeatureIndexByName(featureName);
        if (ord < 0) {
            throw new IllegalArgumentException("Unknown feature [" + featureName + "]");
        }
        return ord;
    }

    @Override
    public Feature feature(int ord) {
        return (PrebuiltFeature)this.features.get(ord);
    }

    @Override
    public PrebuiltFeature feature(String name) {
        return (PrebuiltFeature)this.features.get(this.featureOrdinal(name));
    }

    @Override
    public boolean hasFeature(String name) {
        return this.findFeatureIndexByName(name) >= 0;
    }

    @Override
    public int size() {
        return this.features.size();
    }

    private int findFeatureIndexByName(String featureName) {
        return IntStream.range(0, this.features.size()).filter(i -> Objects.equals(((PrebuiltFeature)this.features.get(i)).name(), featureName)).findFirst().orElse(-1);
    }
}

