/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.index.mapper.MapperService;

public class CreateIndexStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(CreateIndexStep.class);
    private final Client client;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "create_index";

    public CreateIndexStep(Client client, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.client = client;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        PlainActionFuture createIndexFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("index_name", "configurations");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            String indexName = (String)inputs.get("index_name");
            String configurations = (String)inputs.get("configurations");
            byte[] byteArr = configurations.getBytes(StandardCharsets.UTF_8);
            BytesArray configurationsBytes = new BytesArray(byteArr);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            try {
                if (!configurations.isEmpty()) {
                    Map<String, Object> sourceAsMap = (Map<String, Object>)XContentHelper.convertToMap((BytesReference)configurationsBytes, (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
                    sourceAsMap = CreateIndexStep.prepareMappings(sourceAsMap);
                    createIndexRequest.source(sourceAsMap, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
                }
            }
            catch (Exception ex2) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to create the index {}, _doc is not permitted in mapping", (Object)indexName).getFormattedMessage();
                logger.error(errorMessage, (Throwable)ex2);
                createIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, RestStatus.BAD_REQUEST)));
            }
            this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(acknowledgedResponse -> {
                logger.info("Created index: {}", (Object)indexName);
                this.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, currentNodeId, this.getName(), indexName, tenantId, (ActionListener<WorkflowData>)createIndexFuture);
            }, ex -> {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed to create the index {}", (Object)indexName).getFormattedMessage() : e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                createIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }));
        }
        catch (Exception e) {
            createIndexFuture.onFailure(e);
        }
        return createIndexFuture;
    }

    private static Map<String, Object> prepareMappings(Map<String, Object> source) {
        if (!source.containsKey("mappings") || !(source.get("mappings") instanceof Map)) {
            return source;
        }
        HashMap<String, Object> newSource = new HashMap<String, Object>(source);
        Map mappings = (Map)source.get("mappings");
        if (MapperService.isMappingSourceTyped((String)"_doc", (Map)mappings)) {
            throw new WorkflowStepException("The mapping definition cannot be nested under a type", RestStatus.BAD_REQUEST);
        }
        newSource.put("mappings", Collections.singletonMap("_doc", mappings));
        return newSource;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

