/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.model.WorkflowState;

public class WorkflowResponse
extends ActionResponse
implements ToXContentObject {
    private String workflowId;
    private WorkflowState workflowState;

    public WorkflowResponse(String workflowId) {
        this.workflowId = workflowId;
    }

    public WorkflowResponse(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readString();
        if (in.getVersion().onOrAfter(Version.V_2_19_0)) {
            this.workflowState = (WorkflowState)in.readOptionalWriteable(WorkflowState::new);
        }
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nullable
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public WorkflowResponse(String workflowId, WorkflowState workflowState) {
        this.workflowId = workflowId;
        this.workflowState = WorkflowState.builder().workflowId(workflowId).error(workflowState.getError()).state(workflowState.getState()).resourcesCreated(workflowState.resourcesCreated()).build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.workflowId);
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            out.writeOptionalWriteable((Writeable)this.workflowState);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.workflowState != null) {
            return this.workflowState.toXContent(builder, params);
        }
        return builder.startObject().field("workflow_id", this.workflowId).endObject();
    }
}

