/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CodecService;
import org.opensearch.index.codec.customcodecs.QatDeflate912Codec;
import org.opensearch.index.codec.customcodecs.QatLz4912Codec;
import org.opensearch.index.codec.customcodecs.QatZipperFactory;
import org.opensearch.index.codec.customcodecs.Zstd912Codec;
import org.opensearch.index.codec.customcodecs.ZstdNoDict912Codec;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99QatCodec;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.MapperService;

public class CustomCodecService
extends CodecService {
    private final Map<String, Codec> codecs;
    public static final String ZSTD_CODEC = "zstd";
    public static final String ZSTD_NO_DICT_CODEC = "zstd_no_dict";
    public static final String QAT_LZ4_CODEC = "qat_lz4";
    public static final String QAT_DEFLATE_CODEC = "qat_deflate";

    public CustomCodecService(MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        super(mapperService, indexSettings, logger);
        int compressionLevel = (Integer)indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
        MapBuilder codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put((Object)ZSTD_CODEC, (Object)new Zstd912Codec(compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDict912Codec(compressionLevel));
            if (QatZipperFactory.isQatAvailable()) {
                codecs.put((Object)QAT_LZ4_CODEC, (Object)new QatLz4912Codec(compressionLevel, () -> (QatZipper.Mode)indexSettings.getValue(Lucene99QatCodec.INDEX_CODEC_QAT_MODE_SETTING)));
                codecs.put((Object)QAT_DEFLATE_CODEC, (Object)new QatDeflate912Codec(compressionLevel, () -> (QatZipper.Mode)indexSettings.getValue(Lucene99QatCodec.INDEX_CODEC_QAT_MODE_SETTING)));
            }
        } else {
            codecs.put((Object)ZSTD_CODEC, (Object)new Zstd912Codec(mapperService, logger, compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDict912Codec(mapperService, logger, compressionLevel));
            if (QatZipperFactory.isQatAvailable()) {
                codecs.put((Object)QAT_LZ4_CODEC, (Object)new QatLz4912Codec(mapperService, logger, compressionLevel, () -> (QatZipper.Mode)indexSettings.getValue(Lucene99QatCodec.INDEX_CODEC_QAT_MODE_SETTING)));
                codecs.put((Object)QAT_DEFLATE_CODEC, (Object)new QatDeflate912Codec(mapperService, logger, compressionLevel, () -> (QatZipper.Mode)indexSettings.getValue(Lucene99QatCodec.INDEX_CODEC_QAT_MODE_SETTING)));
            }
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            return super.codec(name);
        }
        return codec;
    }

    public String[] availableCodecs() {
        return (String[])Stream.concat(Arrays.stream(super.availableCodecs()), this.codecs.keySet().stream()).toArray(String[]::new);
    }
}

