/*
 * Decompiled with CFR 0.152.
 */
package RequiredEncryptionContextCMM_Compile;

import CMM_Compile.VerifiableInterface;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsManager;

public class RequiredEncryptionContextCMM
implements VerifiableInterface,
ICryptographicMaterialsManager {
    public ICryptographicMaterialsManager _underlyingCMM = null;
    public DafnySequence<? extends DafnySequence<? extends Byte>> _requiredEncryptionContextKeys = DafnySequence.empty(ValidUTF8Bytes._typeDescriptor());
    private static final TypeDescriptor<RequiredEncryptionContextCMM> _TYPE = TypeDescriptor.referenceWithInitializer(RequiredEncryptionContextCMM.class, () -> null);

    @Override
    public Result<DecryptMaterialsOutput, Error> DecryptMaterials(DecryptMaterialsInput input) {
        Result<DecryptMaterialsOutput, Error> _out2 = _Companion_ICryptographicMaterialsManager.DecryptMaterials(this, input);
        return _out2;
    }

    @Override
    public Result<GetEncryptionMaterialsOutput, Error> GetEncryptionMaterials(GetEncryptionMaterialsInput input) {
        Result<GetEncryptionMaterialsOutput, Error> _out2 = _Companion_ICryptographicMaterialsManager.GetEncryptionMaterials(this, input);
        return _out2;
    }

    public void __ctor(ICryptographicMaterialsManager inputCMM, DafnySet<? extends DafnySequence<? extends Byte>> inputKeys) {
        DafnySet<? extends DafnySequence<? extends Byte>> _0_keySet = inputKeys;
        DafnySequence<? extends DafnySequence<? extends Byte>> _1_keySeq = SortedSets.__default.SetToSequence(ValidUTF8Bytes._typeDescriptor(), _0_keySet);
        this._underlyingCMM = inputCMM;
        this._requiredEncryptionContextKeys = _1_keySeq;
    }

    @Override
    public Result<GetEncryptionMaterialsOutput, Error> GetEncryptionMaterials_k(GetEncryptionMaterialsInput input) {
        Result<GetEncryptionMaterialsOutput, Error> output = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), ((Function<GetEncryptionMaterialsInput, Boolean>)_1_input -> Helpers.Quantifier((Iterable)this.requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _2_k = _forall_var_0;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_2_k)) {
                return !this.requiredEncryptionContextKeys().contains((Object)_2_k) || _1_input.dtor_encryptionContext().contains((Object)_2_k);
            }
            return true;
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context does not contain required keys.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), GetEncryptionMaterialsOutput._typeDescriptor());
            return output;
        }
        Result<GetEncryptionMaterialsOutput, Error> _3_valueOrError1 = null;
        GetEncryptionMaterialsInput _pat_let_tv0 = input;
        Result<GetEncryptionMaterialsOutput, Error> _out0 = this.underlyingCMM().GetEncryptionMaterials((GetEncryptionMaterialsInput)Helpers.Let((Object)input, boxed16 -> {
            GetEncryptionMaterialsInput _pat_let8_0 = boxed16;
            return (GetEncryptionMaterialsInput)Helpers.Let((Object)_pat_let8_0, boxed17 -> {
                GetEncryptionMaterialsInput _4_dt__update__tmp_h0 = boxed17;
                return (GetEncryptionMaterialsInput)Helpers.Let(Option.create_Some(DafnySequence._typeDescriptor(ValidUTF8Bytes._typeDescriptor()), DafnySequence.concatenate(_pat_let_tv0.dtor_requiredEncryptionContextKeys().UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Byte>>>)DafnySequence._typeDescriptor(ValidUTF8Bytes._typeDescriptor()), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty(ValidUTF8Bytes._typeDescriptor())), this.requiredEncryptionContextKeys())), boxed18 -> {
                    Option _pat_let9_0 = boxed18;
                    return (GetEncryptionMaterialsInput)Helpers.Let((Object)_pat_let9_0, boxed19 -> {
                        Option _5_dt__update_hrequiredEncryptionContextKeys_h0 = boxed19;
                        return GetEncryptionMaterialsInput.create(_4_dt__update__tmp_h0.dtor_encryptionContext(), _4_dt__update__tmp_h0.dtor_commitmentPolicy(), _4_dt__update__tmp_h0.dtor_algorithmSuiteId(), _4_dt__update__tmp_h0.dtor_maxPlaintextLength(), _5_dt__update_hrequiredEncryptionContextKeys_h0);
                    });
                });
            });
        }));
        _3_valueOrError1 = _out0;
        if (_3_valueOrError1.IsFailure(GetEncryptionMaterialsOutput._typeDescriptor(), Error._typeDescriptor())) {
            output = _3_valueOrError1.PropagateFailure(GetEncryptionMaterialsOutput._typeDescriptor(), Error._typeDescriptor(), GetEncryptionMaterialsOutput._typeDescriptor());
            return output;
        }
        GetEncryptionMaterialsOutput _6_result = _3_valueOrError1.Extract(GetEncryptionMaterialsOutput._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _7_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError2 = __default.Need(Error._typeDescriptor(), ((Function<GetEncryptionMaterialsOutput, Boolean>)_8_result -> Helpers.Quantifier((Iterable)this.requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_1_boxed0 -> {
            DafnySequence _forall_var_1 = _forall_var_1_boxed0;
            DafnySequence _9_k = _forall_var_1;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_9_k)) {
                return !this.requiredEncryptionContextKeys().contains((Object)_9_k) || _8_result.dtor_encryptionMaterials().dtor_requiredEncryptionContextKeys().contains((Object)_9_k);
            }
            return true;
        })).apply(_6_result), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Expected encryption context keys do not exist in keys to only authenticate.")));
        if (_7_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _7_valueOrError2.PropagateFailure(Error._typeDescriptor(), GetEncryptionMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _10_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _10_valueOrError3 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.EncryptionMaterialsHasPlaintextDataKey(_6_result.dtor_encryptionMaterials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Could not retrieve materials required for encryption")));
        if (_10_valueOrError3.IsFailure(Error._typeDescriptor())) {
            output = _10_valueOrError3.PropagateFailure(Error._typeDescriptor(), GetEncryptionMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _11_valueOrError4 = Outcome.Default(Error._typeDescriptor());
        _11_valueOrError4 = __default.Need(Error._typeDescriptor(), CMM_Compile.__default.RequiredEncryptionContextKeys_q(input.dtor_requiredEncryptionContextKeys(), _6_result.dtor_encryptionMaterials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring returned an invalid response")));
        if (_11_valueOrError4.IsFailure(Error._typeDescriptor())) {
            output = _11_valueOrError4.PropagateFailure(Error._typeDescriptor(), GetEncryptionMaterialsOutput._typeDescriptor());
            return output;
        }
        output = Result.create_Success(GetEncryptionMaterialsOutput._typeDescriptor(), Error._typeDescriptor(), _6_result);
        return output;
    }

    @Override
    public Result<DecryptMaterialsOutput, Error> DecryptMaterials_k(DecryptMaterialsInput input) {
        Result<DecryptMaterialsOutput, Error> output = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), input.dtor_reproducedEncryptionContext().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"No reproduced encryption context on decrypt.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _1_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _1_valueOrError1 = __default.Need(Error._typeDescriptor(), CMM_Compile.__default.ReproducedEncryptionContext_q(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context does not match reproduced encryption context.")));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _2_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError2 = __default.Need(Error._typeDescriptor(), ((Function<DecryptMaterialsInput, Boolean>)_3_input -> Helpers.Quantifier((Iterable)this.requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _4_k = _forall_var_0;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_4_k)) {
                return !this.requiredEncryptionContextKeys().contains((Object)_4_k) || _3_input.dtor_reproducedEncryptionContext().dtor_value().contains((Object)_4_k);
            }
            return true;
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Reproduced encryption context missing required keys.")));
        if (_2_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _2_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        Result<DecryptMaterialsOutput, Error> _5_valueOrError3 = null;
        Result<DecryptMaterialsOutput, Error> _out0 = this.underlyingCMM().DecryptMaterials(input);
        _5_valueOrError3 = _out0;
        if (_5_valueOrError3.IsFailure(DecryptMaterialsOutput._typeDescriptor(), Error._typeDescriptor())) {
            output = _5_valueOrError3.PropagateFailure(DecryptMaterialsOutput._typeDescriptor(), Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        DecryptMaterialsOutput _6_result = _5_valueOrError3.Extract(DecryptMaterialsOutput._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _7_valueOrError4 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError4 = __default.Need(Error._typeDescriptor(), ((Function<DecryptMaterialsOutput, Boolean>)_8_result -> Helpers.Quantifier((Iterable)this.requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_1_boxed0 -> {
            DafnySequence _forall_var_1 = _forall_var_1_boxed0;
            DafnySequence _9_k = _forall_var_1;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_9_k)) {
                return !this.requiredEncryptionContextKeys().contains((Object)_9_k) || _8_result.dtor_decryptionMaterials().dtor_encryptionContext().contains((Object)_9_k);
            }
            return true;
        })).apply(_6_result), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Final encryption context missing required keys.")));
        if (_7_valueOrError4.IsFailure(Error._typeDescriptor())) {
            output = _7_valueOrError4.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _10_valueOrError5 = Outcome.Default(Error._typeDescriptor());
        _10_valueOrError5 = __default.Need(Error._typeDescriptor(), CMM_Compile.__default.EncryptionContextComplete(input, _6_result.dtor_decryptionMaterials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Reproduced encryption context missing from encryption context.")));
        if (_10_valueOrError5.IsFailure(Error._typeDescriptor())) {
            output = _10_valueOrError5.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        Outcome<Error> _11_valueOrError6 = Outcome.Default(Error._typeDescriptor());
        _11_valueOrError6 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithPlaintextDataKey(_6_result.dtor_decryptionMaterials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring.OnDecrypt failed to decrypt the plaintext data key.")));
        if (_11_valueOrError6.IsFailure(Error._typeDescriptor())) {
            output = _11_valueOrError6.PropagateFailure(Error._typeDescriptor(), DecryptMaterialsOutput._typeDescriptor());
            return output;
        }
        output = Result.create_Success(DecryptMaterialsOutput._typeDescriptor(), Error._typeDescriptor(), _6_result);
        return output;
    }

    public ICryptographicMaterialsManager underlyingCMM() {
        return this._underlyingCMM;
    }

    public DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys() {
        return this._requiredEncryptionContextKeys;
    }

    public static TypeDescriptor<RequiredEncryptionContextCMM> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RequiredEncryptionContextCMM.RequiredEncryptionContextCMM";
    }
}

