/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.fips.EcDhcBasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.EcDhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcDhuPublicParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

class EcDhcuBasicAgreement {
    EcDhuPrivateParameters privParams;

    EcDhcuBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.privParams = (EcDhuPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        EcDhuPublicParameters ecDhuPublicParameters = (EcDhuPublicParameters)cipherParameters;
        EcDhcBasicAgreement ecDhcBasicAgreement = new EcDhcBasicAgreement();
        EcDhcBasicAgreement ecDhcBasicAgreement2 = new EcDhcBasicAgreement();
        ecDhcBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = ecDhcBasicAgreement.calculateAgreement(ecDhuPublicParameters.getStaticPublicKey());
        ecDhcBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = ecDhcBasicAgreement2.calculateAgreement(ecDhuPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

