/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class BooleanConstantNode
extends ConstantNode {
    boolean booleanValue;
    boolean unknownValue;

    BooleanConstantNode(ContextManager cm) throws StandardException {
        super(TypeId.BOOLEAN_ID, true, 1, cm);
        this.setValue(null);
    }

    BooleanConstantNode(boolean value, ContextManager cm) throws StandardException {
        super(TypeId.BOOLEAN_ID, false, 1, cm);
        super.setValue(new SQLBoolean(value));
        this.booleanValue = value;
    }

    BooleanConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(t, true, 0, cm);
        this.unknownValue = true;
    }

    @Override
    Object getConstantValueAsObject() {
        return this.booleanValue ? Boolean.TRUE : Boolean.FALSE;
    }

    String getValueAsString() {
        if (this.booleanValue) {
            return "true";
        }
        return "false";
    }

    @Override
    boolean isBooleanTrue() {
        return this.booleanValue && !this.unknownValue;
    }

    @Override
    boolean isBooleanFalse() {
        return !this.booleanValue && !this.unknownValue;
    }

    @Override
    public double selectivity(Optimizable optTable) {
        if (this.isBooleanTrue()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) {
        if (!underNotNode) {
            return this;
        }
        this.booleanValue = !this.booleanValue;
        super.setValue(new SQLBoolean(this.booleanValue));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) {
        mb.push(this.booleanValue);
    }

    @Override
    void setValue(DataValueDescriptor value) {
        super.setValue(value);
        this.unknownValue = true;
        try {
            if (value != null && value.isNotNull().getBoolean()) {
                this.booleanValue = value.getBoolean();
                this.unknownValue = false;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }
}

