/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.profile.builtin.Invocation;
import org.jruby.runtime.profile.builtin.ProfilePrinter;
import org.jruby.runtime.profile.builtin.ProfiledMethod;
import org.jruby.runtime.profile.builtin.ProfiledMethods;

public class ProfileData
implements ProfileCollection {
    private Invocation currentInvocation;
    private Invocation topInvocation;
    private int[] methodRecursion;
    private final ThreadContext threadContext;
    private final ProfiledMethods profiledMethods;

    public ProfileData(ThreadContext context, ProfiledMethods profiledMethods) {
        this.threadContext = context;
        this.profiledMethods = profiledMethods;
        this.clear();
    }

    private ProfiledMethod getProfiledMethod(long serial) {
        return this.profiledMethods.getProfiledMethod(serial);
    }

    @Override
    public void profileEnter(long calledMethod) {
        Invocation parentInvocation = this.currentInvocation;
        Invocation childInvocation = parentInvocation.childInvocationFor((int)calledMethod);
        childInvocation.incrementCount();
        this.currentInvocation = childInvocation;
    }

    @Override
    public void profileExit(long callingMethod, long startTime) {
        long now2 = System.nanoTime();
        long duration = now2 - startTime;
        int oldSerial = this.currentInvocation.getMethodSerialNumber();
        this.currentInvocation.addDuration(duration);
        if (this.currentInvocation == this.topInvocation) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = this.currentInvocation.copyWithNewSerialAndParent((int)callingMethod, newTopInvocation);
            newTopInvocation.addChild(newCurrentInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
        } else if (this.currentInvocation.getParent() == this.topInvocation && callingMethod != 0L) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = newTopInvocation.childInvocationFor((int)callingMethod);
            Invocation newChildInvocation = this.currentInvocation.copyWithNewSerialAndParent(this.currentInvocation.getMethodSerialNumber(), newCurrentInvocation);
            newCurrentInvocation.addChild(newChildInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
        } else {
            this.currentInvocation = this.currentInvocation.getParent();
        }
    }

    public void clear() {
        this.methodRecursion = new int[1000];
        this.topInvocation = this.currentInvocation = new Invocation(0);
    }

    public long totalTime() {
        return this.topInvocation.childTime();
    }

    public Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public Invocation getCurrentInvocation() {
        return this.currentInvocation;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public Invocation computeResults() {
        Invocation singleTopChild;
        int serial;
        this.setRecursiveDepths();
        if (this.topInvocation.getChildren().size() != 1) {
            return ProfileData.setDuration(this.topInvocation);
        }
        if (this.topInvocation.getChildren().size() == 1 && "JRuby::Profiler.profile".equals(this.methodName(serial = (singleTopChild = this.topInvocation.getChildren().values().iterator().next()).getMethodSerialNumber()))) {
            for (Invocation inv : singleTopChild.getChildren().values()) {
                serial = inv.getMethodSerialNumber();
                if (!"JRuby::Profiler.profiled_code".equals(this.methodName(serial))) continue;
                return ProfileData.setDuration(inv.copyWithNewSerialAndParent(0, null));
            }
        }
        return ProfileData.setDuration(this.topInvocation);
    }

    private static Invocation setDuration(Invocation inv) {
        inv.setDuration(inv.childTime());
        return inv;
    }

    protected void decRecursionFor(int serial) {
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = mr[serial] - 1;
    }

    protected int incRecursionFor(int serial) {
        int inc;
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = inc = mr[serial] + 1;
        return inc;
    }

    private void ensureRecursionSize(int index2) {
        int[] mr = this.methodRecursion;
        int length2 = mr.length;
        if (length2 <= index2) {
            int[] newRecursion = new int[(int)((double)index2 * 1.5 + 1.0)];
            System.arraycopy(mr, 0, newRecursion, 0, length2);
            this.methodRecursion = newRecursion;
        }
    }

    private void setRecursiveDepths() {
        int topSerial = this.topInvocation.getMethodSerialNumber();
        int depth = this.incRecursionFor(topSerial);
        this.topInvocation.setRecursiveDepth(depth);
        this.setRecursiveDepths1(this.topInvocation);
    }

    private void setRecursiveDepths1(Invocation inv) {
        for (Invocation child : inv.getChildren().values()) {
            int childSerial = child.getMethodSerialNumber();
            int depth = this.incRecursionFor(childSerial);
            child.setRecursiveDepth(depth);
            this.setRecursiveDepths1(child);
            this.decRecursionFor(childSerial);
        }
    }

    String methodName(int serial) {
        if (serial == 0) {
            return "(top)";
        }
        return ProfilePrinter.methodName(this.getProfiledMethod(serial));
    }
}

