/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class KeyUtils {
    private static final Logger LOG = Logger.getLogger(KeyUtils.class);
    public static final Pattern UUID_PATTERN = Pattern.compile("[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}");
    public static final Pattern EXPECTED_KEY_PATTERN = Pattern.compile(UUID_PATTERN.pattern() + "|f:" + UUID_PATTERN.pattern() + ":.*|lightweight-" + UUID_PATTERN.pattern());

    public static boolean isValidKey(String key) {
        return key == null || EXPECTED_KEY_PATTERN.matcher(key).matches();
    }

    public static void assertValidKey(String key) throws IllegalArgumentException {
        if (!KeyUtils.isValidKey(key)) {
            LOG.warnf("The given key is not a valid key per specification, future migration might fail: %s", (Object)key);
        }
    }
}

