/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialAction;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class AcrStore {
    private static final Logger logger = Logger.getLogger(AcrStore.class);
    private final KeycloakSession session;
    private final AuthenticationSessionModel authSession;

    public AcrStore(KeycloakSession session, AuthenticationSessionModel authSession) {
        this.session = session;
        this.authSession = authSession;
    }

    public boolean isLevelOfAuthenticationForced() {
        return Boolean.parseBoolean(this.authSession.getClientNote("force-level-of-authentication"));
    }

    public int getRequestedLevelOfAuthentication(AuthenticationFlowModel executionModel) {
        String requiredLoa = this.authSession.getClientNote("requested-level-of-authentication");
        int requestedLoaByClient = requiredLoa == null ? -1 : Integer.parseInt(requiredLoa);
        int requestedLoaByKcAction = this.getRequestedLevelOfAuthenticationByKcAction(executionModel);
        logger.tracef("Level requested by client: %d, level requested by kc_action parameter: %d", requestedLoaByClient, requestedLoaByKcAction);
        return Math.max(requestedLoaByClient, requestedLoaByKcAction);
    }

    private int getRequestedLevelOfAuthenticationByKcAction(AuthenticationFlowModel topLevelFlow) {
        Map<String, Integer> credentialTypesToLoa;
        Integer credentialTypeLevel;
        String credentialType;
        RequiredActionProvider reqAction;
        RealmModel realm = this.authSession.getRealm();
        UserModel user = this.authSession.getAuthenticatedUser();
        String kcAction = this.authSession.getClientNote("kc_action");
        if (user != null && kcAction != null && (reqAction = (RequiredActionProvider)this.session.getProvider(RequiredActionProvider.class, kcAction)) instanceof CredentialAction && (credentialType = ((CredentialAction)reqAction).getCredentialType(this.session, this.authSession)) != null && (credentialTypeLevel = (credentialTypesToLoa = LoAUtil.getCredentialTypesToLoAMap(this.session, realm, topLevelFlow)).get(credentialType)) != null) {
            MultivaluedHashMap<Integer, String> loaToCredentialTypes = this.reverse(credentialTypesToLoa);
            return this.getHighestLevelAvailableForUser(user, loaToCredentialTypes, credentialTypeLevel);
        }
        return -1;
    }

    private MultivaluedHashMap<Integer, String> reverse(Map<String, Integer> orig) {
        MultivaluedHashMap reverse = new MultivaluedHashMap();
        orig.forEach((key, value) -> reverse.add(value, key));
        return reverse;
    }

    private Integer getHighestLevelAvailableForUser(UserModel user, MultivaluedHashMap<Integer, String> loaToCredentialTypes, int levelToTry) {
        if (levelToTry <= -1) {
            return levelToTry;
        }
        List currentLevelCredentialTypes = (List)loaToCredentialTypes.get((Object)levelToTry);
        if (currentLevelCredentialTypes == null || currentLevelCredentialTypes.isEmpty()) {
            return levelToTry;
        }
        boolean hasCredentialOfLevel = user.credentialManager().getStoredCredentialsStream().anyMatch(credentialModel -> currentLevelCredentialTypes.contains(credentialModel.getType()));
        if (hasCredentialOfLevel) {
            logger.tracef("User %s has credential of level %d available", (Object)user.getUsername(), (Object)levelToTry);
            return levelToTry;
        }
        return this.getHighestLevelAvailableForUser(user, loaToCredentialTypes, levelToTry - 1);
    }

    public boolean isLevelOfAuthenticationSatisfiedFromCurrentAuthentication(AuthenticationFlowModel topFlow) {
        return this.getRequestedLevelOfAuthentication(topFlow) <= this.getAuthenticatedLevelCurrentAuthentication();
    }

    public static int getCurrentLevelOfAuthentication(AuthenticatedClientSessionModel clientSession) {
        String clientSessionLoaNote = clientSession.getNote("level-of-authentication");
        return clientSessionLoaNote == null ? -1 : Integer.parseInt(clientSessionLoaNote);
    }

    public boolean isLevelAuthenticatedInPreviousAuth(int level, int maxAge) {
        if (AuthenticatorUtil.isForcedReauthentication(this.authSession)) {
            return false;
        }
        Map<Integer, Integer> levels = this.getCurrentAuthenticatedLevelsMap();
        if (levels == null) {
            return false;
        }
        Integer levelAuthTime = levels.get(level);
        if (levelAuthTime == null) {
            return false;
        }
        int currentTime = Time.currentTime();
        return levelAuthTime + maxAge >= currentTime;
    }

    public int getLevelOfAuthenticationFromCurrentAuthentication() {
        String authSessionLoaNote = this.authSession.getAuthNote("level-of-authentication");
        return authSessionLoaNote == null ? -1 : Integer.parseInt(authSessionLoaNote);
    }

    public void setLevelAuthenticated(int level) {
        this.setLevelAuthenticatedToCurrentRequest(level);
        this.setLevelAuthenticatedToMap(level);
    }

    public void setLevelAuthenticatedToCurrentRequest(int level) {
        this.authSession.setAuthNote("level-of-authentication", String.valueOf(level));
    }

    private void setLevelAuthenticatedToMap(int level) {
        Map<Integer, Integer> levels = this.getCurrentAuthenticatedLevelsMap();
        if (levels == null) {
            levels = new HashMap<Integer, Integer>();
        }
        levels.put(level, Time.currentTime());
        this.saveCurrentAuthenticatedLevelsMap(levels);
    }

    private int getAuthenticatedLevelCurrentAuthentication() {
        String authSessionLoaNote = this.authSession.getAuthNote("level-of-authentication");
        return authSessionLoaNote == null ? -1 : Integer.parseInt(authSessionLoaNote);
    }

    public int getHighestAuthenticatedLevelFromPreviousAuthentication(String flowId) {
        Map<Integer, Integer> levels = this.getCurrentAuthenticatedLevelsMap();
        if (levels == null || levels.isEmpty()) {
            return -1;
        }
        int maxLevel = 0;
        int currentTime = Time.currentTime();
        Map<Integer, Integer> configuredMaxAges = LoAUtil.getLoaMaxAgesConfiguredInRealmFlow(this.authSession.getRealm(), flowId);
        levels = new TreeMap<Integer, Integer>(levels);
        for (Map.Entry<Integer, Integer> entry : levels.entrySet()) {
            int levelAuthTime;
            int levelExpiration;
            Integer levelMaxAge = configuredMaxAges.get(entry.getKey());
            if (levelMaxAge == null) {
                logger.warnf("No condition found for level '%d' in the authentication flow", (Object)entry.getKey());
                levelMaxAge = 0;
            }
            if (currentTime > (levelExpiration = (levelAuthTime = entry.getValue().intValue()) + levelMaxAge)) break;
            maxLevel = entry.getKey();
        }
        logger.tracef("Highest authenticated level from previous authentication of client '%s' in authentication '%s' was: %d", (Object)this.authSession.getClient().getClientId(), (Object)this.authSession.getParentSession().getId(), (Object)maxLevel);
        return maxLevel;
    }

    private Map<Integer, Integer> getCurrentAuthenticatedLevelsMap() {
        String loaMap = this.authSession.getAuthNote("loa-map");
        if (loaMap == null) {
            return null;
        }
        try {
            return (Map)JsonSerialization.readValue((String)loaMap, (TypeReference)new TypeReference<Map<Integer, Integer>>(){});
        }
        catch (IOException e) {
            logger.warnf("Invalid format of the LoA map. Saved value was: %s", (Object)loaMap);
            throw new IllegalStateException(e);
        }
    }

    private void saveCurrentAuthenticatedLevelsMap(Map<Integer, Integer> levelInfoMap) {
        try {
            String note = JsonSerialization.writeValueAsString(levelInfoMap);
            this.authSession.setAuthNote("loa-map", note);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

