/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.CommonCloseAction;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.JDefaultButton;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.MonitorableDataEntryPanel;
import ca.sqlpower.swingui.Resizable;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.validation.Validated;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DataEntryPanelBuilder {
    static Logger logger = Logger.getLogger(DataEntryPanelBuilder.class);
    public static final String OK_BUTTON_LABEL = Messages.getString("DataEntryPanelBuilder.okButton");
    public static final String CANCEL_BUTTON_LABEL = Messages.getString("DataEntryPanelBuilder.cancelButton");

    public static JDialog createDataEntryPanelDialog(DataEntryPanel dataEntry, Component dialogParent, String dialogTitle, String actionButtonTitle, Callable<Boolean> okCall, Callable<Boolean> cancelCall) {
        return DataEntryPanelBuilder.createDataEntryPanelDialog(dataEntry, dialogParent, dialogTitle, actionButtonTitle, okCall, cancelCall, false);
    }

    public static JDialog createDataEntryPanelDialog(DataEntryPanel dataEntry, Component dialogParent, String dialogTitle, String actionButtonTitle, final Callable<Boolean> okCall, final Callable<Boolean> cancelCall, final boolean oneShot) {
        AbstractAction okAction;
        final JDialog d = DataEntryPanelBuilder.createDialog(dialogParent, dialogTitle);
        JComponent panel = dataEntry.getPanel();
        if (dataEntry instanceof MonitorableDataEntryPanel) {
            MonitorableDataEntryPanel mdep = (MonitorableDataEntryPanel)dataEntry;
            mdep.setDialog(d);
            okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        this.setEnabled(false);
                        okCall.call();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        if (!oneShot) {
                            this.setEnabled(true);
                        }
                    }
                }
            };
        } else {
            okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        this.setEnabled(false);
                        boolean close = (Boolean)okCall.call();
                        if (close) {
                            d.dispose();
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        if (!oneShot) {
                            this.setEnabled(true);
                        }
                    }
                }
            };
        }
        if (dataEntry instanceof ValidatableDataEntryPanel) {
            ValidatableDataEntryPanel vdep = (ValidatableDataEntryPanel)dataEntry;
            ValidationHandler handler = vdep.getValidationHandler();
            handler.setValidatedAction(okAction);
        }
        final JDefaultButton okButton = new JDefaultButton(okAction);
        okButton.setText(actionButtonTitle);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean close = (Boolean)cancelCall.call();
                    if (close) {
                        d.dispose();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        d.setDefaultCloseOperation(0);
        d.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    boolean close = (Boolean)cancelCall.call();
                    if (close) {
                        d.dispose();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        if (dataEntry instanceof Validated) {
            ValidationHandler handler = ((Validated)((Object)dataEntry)).getHandler();
            handler.setValidatedAction(okAction);
        }
        if (dataEntry instanceof Resizable) {
            ComponentListener cl = new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    d.setSize(d.getPreferredSize());
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }
            };
            ((Resizable)((Object)dataEntry)).addResizeListener(cl);
        }
        SPSUtils.makeJDialogCancellable(d, closeAction);
        JButton cancelButton = new JButton(closeAction);
        cancelButton.setText(CANCEL_BUTTON_LABEL);
        d.getRootPane().setDefaultButton(okButton);
        JPanel cp = new JPanel(new BorderLayout());
        final JLabel errorLabel = new JLabel();
        errorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        cp.add((Component)errorLabel, "North");
        errorLabel.setVisible(false);
        if (dataEntry instanceof ChangeListeningDataEntryPanel) {
            ((ChangeListeningDataEntryPanel)dataEntry).addErrorTextListener(new ChangeListeningDataEntryPanel.ErrorTextListener(){

                @Override
                public void textChanged(String s) {
                    errorLabel.setText(s);
                    boolean noError = s == null || s.trim().equals("");
                    errorLabel.setVisible(!noError);
                    okButton.setEnabled(noError);
                    d.pack();
                }
            });
        }
        cp.add((Component)panel, "Center");
        cp.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton), "South");
        cp.setBorder(Borders.DIALOG_BORDER);
        d.setContentPane(cp);
        d.pack();
        d.setBounds((int)d.getBounds().getX(), (int)d.getBounds().getY(), (int)Math.min(d.getBounds().getWidth(), d.getToolkit().getScreenSize().getWidth()), (int)Math.min(d.getBounds().getHeight(), d.getToolkit().getScreenSize().getHeight()));
        d.setLocationRelativeTo(dialogParent);
        return d;
    }

    private static JDialog createDialog(Component dialogParentComponent, String dialogTitle) {
        JDialog dialog;
        Window dialogParent = dialogParentComponent instanceof Window ? (Window)dialogParentComponent : SwingUtilities.getWindowAncestor(dialogParentComponent);
        if (dialogParent == null) {
            dialog = new JDialog();
            if (logger.isDebugEnabled()) {
                JOptionPane.showMessageDialog(null, "This action called createDataEntryPanelDialog with DialogParent == null!");
            }
        } else if (dialogParent instanceof Frame) {
            dialog = new JDialog((Frame)dialogParent, dialogTitle);
        } else if (dialogParent instanceof Dialog) {
            dialog = new JDialog((Dialog)dialogParent, dialogTitle);
        } else {
            throw new IllegalArgumentException("The dialogParent you gave me is not a Frame or Dialog (it is a " + dialogParent.getClass().getName() + ")");
        }
        return dialog;
    }

    public static JDialog createSingleButtonDataEntryPanelDialog(final DataEntryPanel dataEntry, Component dialogParent, String dialogTitle, String actionButtonTitle) {
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataEntry.applyChanges();
            }
        };
        return DataEntryPanelBuilder.createSingleButtonDataEntryPanelDialog(dataEntry, dialogParent, dialogTitle, actionButtonTitle, okAction);
    }

    public static JDialog createDataEntryPanelDialog(final DataEntryPanel dataEntry, Component dialogParent, String dialogTitle, String actionButtonTitle) {
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (dataEntry.hasUnsavedChanges()) {
                    return new Boolean(dataEntry.applyChanges());
                }
                return new Boolean(true);
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (dataEntry.hasUnsavedChanges()) {
                    dataEntry.discardChanges();
                }
                return new Boolean(true);
            }
        };
        return DataEntryPanelBuilder.createDataEntryPanelDialog(dataEntry, dialogParent, dialogTitle, actionButtonTitle, okCall, cancelCall);
    }

    public static JDialog createSingleButtonDataEntryPanelDialog(DataEntryPanel dataEntry, Component dialogParent, String dialogTitle, String actionButtonTitle, Action okAction) {
        JDialog d = DataEntryPanelBuilder.createDialog(dialogParent, dialogTitle);
        JComponent panel = dataEntry.getPanel();
        JDefaultButton okButton = new JDefaultButton(okAction);
        okButton.setText(actionButtonTitle);
        CommonCloseAction closeAction = new CommonCloseAction(d);
        okButton.addActionListener(closeAction);
        SPSUtils.makeJDialogCancellable(d, closeAction);
        okButton.addActionListener(new CommonCloseAction(d));
        d.getRootPane().setDefaultButton(okButton);
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add((Component)panel, "Center");
        cp.add((Component)ButtonBarFactory.buildCenteredBar((JButton)okButton), "South");
        cp.setBorder(Borders.DIALOG_BORDER);
        d.setContentPane(cp);
        d.pack();
        return d;
    }
}

