/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OwnTracksProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OwnTracksProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.US_ASCII))).readObject();
        if (!root.getString("_type").equals("location")) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        String uniqueId = root.getString("tid");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, uniqueId);
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(root.getJsonNumber("tst").longValue() * 1000L));
        if (root.containsKey((Object)"sent")) {
            position.setDeviceTime(new Date(root.getJsonNumber("sent").longValue() * 1000L));
        }
        position.setValid(true);
        position.setLatitude(root.getJsonNumber("lat").doubleValue());
        position.setLongitude(root.getJsonNumber("lon").doubleValue());
        if (root.containsKey((Object)"vel")) {
            position.setSpeed(UnitsConverter.knotsFromKph(root.getInt("vel")));
        }
        if (root.containsKey((Object)"alt")) {
            position.setAltitude(root.getInt("alt"));
        }
        if (root.containsKey((Object)"cog")) {
            position.setCourse(root.getInt("cog"));
        }
        if (root.containsKey((Object)"acc")) {
            position.setAccuracy(root.getInt("acc"));
        }
        if (root.containsKey((Object)"t")) {
            String event = root.getString("t");
            this.decodeAlarm(position, event, root.getInt("rty", -1));
            position.set("event", event);
        }
        if (root.containsKey((Object)"batt")) {
            position.set("batteryLevel", root.getInt("batt"));
        }
        if (root.containsKey((Object)"uext")) {
            position.set("power", root.getJsonNumber("uext").doubleValue());
        }
        if (root.containsKey((Object)"ubatt")) {
            position.set("battery", root.getJsonNumber("ubatt").doubleValue());
        }
        if (root.containsKey((Object)"vin")) {
            position.set("vin", root.getString("vin"));
        }
        if (root.containsKey((Object)"name")) {
            position.set("vin", root.getString("name"));
        }
        if (root.containsKey((Object)"rpm")) {
            position.set("rpm", root.getInt("rpm"));
        }
        if (root.containsKey((Object)"ign")) {
            position.set("ignition", root.getBoolean("ign"));
        }
        if (root.containsKey((Object)"motion")) {
            position.set("motion", root.getBoolean("motion"));
        }
        if (root.containsKey((Object)"odometer")) {
            position.set("odometer", root.getJsonNumber("odometer").doubleValue() * 1000.0);
        }
        if (root.containsKey((Object)"hmc")) {
            position.set("hours", root.getJsonNumber("hmc").doubleValue() / 3600.0);
        }
        if (root.containsKey((Object)"anum")) {
            int inputCount = root.getInt("anum");
            for (int i = 0; i < inputCount; ++i) {
                String indexString = String.format("%02d", i);
                if (root.containsKey((Object)("adda-" + indexString))) {
                    position.set("adc" + (i + 1), root.getString("adda-" + indexString));
                }
                if (!root.containsKey((Object)("temp_c-" + indexString))) continue;
                position.set("temp" + (i + 1), root.getJsonNumber("temp_c-" + indexString).doubleValue());
            }
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }

    private void decodeAlarm(Position position, String event, Integer reportType) {
        block11 : switch (event) {
            case "9": {
                position.addAlarm("lowBattery");
                break;
            }
            case "1": {
                position.addAlarm("powerOn");
                break;
            }
            case "i": {
                position.set("ignition", true);
                break;
            }
            case "I": {
                position.set("ignition", false);
                break;
            }
            case "E": {
                position.addAlarm("powerRestored");
                break;
            }
            case "e": {
                position.addAlarm("powerCut");
                break;
            }
            case "!": {
                position.addAlarm("tow");
                break;
            }
            case "s": {
                position.addAlarm("overspeed");
                break;
            }
            case "h": {
                switch (reportType) {
                    case 0: 
                    case 3: {
                        position.addAlarm("hardBraking");
                        break block11;
                    }
                    case 1: 
                    case 4: {
                        position.addAlarm("hardAcceleration");
                        break block11;
                    }
                    case 2: 
                    case 5: {
                        position.addAlarm("hardCornering");
                    }
                }
            }
        }
    }
}

