/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XMLMapAttr
implements Map {
    Map map = new HashMap(5);

    static Attr createAttributeAndDecode(String string, String string2) {
        if (Attr.isValid(string) == Attr.isValid("stringvalue")) {
            string2 = Attr.decode(string2);
        }
        return new Attr(string, string2);
    }

    static Attr createAttribute(int n, String string) {
        return new Attr(n, string);
    }

    public Object get(Object object) {
        Object object2;
        try {
            object2 = this.getAttribute(object);
        }
        catch (Exception exception) {
            object2 = null;
            ExternalUtil.exception(exception);
        }
        return object2;
    }

    public Object get(Object object, Object[] objectArray) {
        Object object2;
        try {
            object2 = this.getAttribute(object, objectArray);
        }
        catch (Exception exception) {
            object2 = null;
            ExternalUtil.exception(exception);
        }
        return object2;
    }

    Object getAttribute(Object object) throws Exception {
        return this.getAttribute(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(Object object, Object[] objectArray) throws Exception {
        Attr attr;
        String string = (String)object;
        Object[] objectArray2 = ModifiedAttribute.translateInto((String)object, null);
        object = (String)objectArray2[0];
        Object object2 = this;
        synchronized (object2) {
            attr = (Attr)this.map.get(object);
        }
        object2 = null;
        if (attr == null && string.startsWith("class:")) {
            attr = (Attr)this.map.get(string.substring(6));
            object2 = attr != null ? attr.getType(objectArray) : null;
        } else {
            try {
                object2 = attr == null ? attr : attr.get(objectArray);
            }
            catch (Exception exception) {
                ExternalUtil.annotate((Throwable)exception, "attrName = " + object);
                throw exception;
            }
        }
        if (object2 instanceof ModifiedAttribute) {
            Object object3 = ((ModifiedAttribute)object2).getValue(string);
            if (object3 instanceof Attr) {
                return ((Attr)object3).get(objectArray);
            }
            return object3;
        }
        return object2;
    }

    public synchronized Object put(Object object, Object object2) {
        return this.put(object, object2, true);
    }

    synchronized Object put(Object object, Object object2, boolean bl) {
        Object object3;
        if (object == null || !(object instanceof String)) {
            return null;
        }
        Object[] objectArray = ModifiedAttribute.translateInto((String)object, object2);
        String string = (String)objectArray[0];
        Object object4 = objectArray[1];
        Object object5 = object3 = object4 == null || object4 instanceof Attr ? object4 : new Attr(object4);
        if (bl) {
            string = Attr.decode(string).intern();
        }
        return this.map.put(string, object3);
    }

    public static void writeHeading(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE attributes PUBLIC \"-//NetBeans//DTD DefaultAttributes 1.0//EN\" \"http://www.netbeans.org/dtds/attributes-1_0.dtd\">");
        printWriter.println("<attributes version=\"1.0\">");
    }

    public static void writeEnding(PrintWriter printWriter) {
        printWriter.println("</attributes>");
    }

    public synchronized void write(PrintWriter printWriter, String string, String string2) {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.isEmpty()) {
            return;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            object2 = (String)object3.getKey();
            object = (Attr)object3.getValue();
            if (object2 == null || object == null || ((String)object2).length() == 0 || ((Attr)object).isValid() == -1) {
                if (object2 == null || ((String)object2).length() == 0 || object != null && ((Attr)object).isValid() != -1) continue;
                iterator.remove();
                continue;
            }
            treeSet.add(object2);
        }
        for (Object object3 : treeSet) {
            object2 = (Attr)this.map.get(object3);
            if (object2 != null) {
                ((Attr)object2).transformMe();
            }
            if (!bl) {
                bl = true;
                object = string;
                try {
                    object = XMLUtil.toAttributeValue((String)string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                printWriter.println(string2 + "<fileobject name=\"" + (String)object + "\">");
            }
            if (((String)object3).equals("instantiatingIterator")) {
                printWriter.println(string2 + string2 + "<attr name=\"" + ((Attr)object2).getAttrNameForPrint((String)object3) + "\" " + "newvalue=\"" + ((Attr)object2).getClassName() + "\"/>");
                continue;
            }
            printWriter.println(string2 + string2 + "<attr name=\"" + ((Attr)object2).getAttrNameForPrint((String)object3) + "\" " + ((Attr)object2).getKeyForPrint() + "=\"" + ((Attr)object2).getValueForPrint() + "\"/>");
            ((Attr)object2).maybeAddSerValueComment(printWriter, string2 + string2);
        }
        if (bl) {
            printWriter.println(string2 + "</fileobject>");
        }
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public synchronized int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public synchronized Set<String> keySet() {
        return this.map.keySet();
    }

    public synchronized Collection values() {
        return this.map.values();
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized void putAll(Map map) {
        this.map.putAll(map);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object instanceof Map) {
            return ((Object)this.map).equals(object);
        }
        return false;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Attr {
        private static final String[] ALLOWED_ATTR_KEYS = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "methodvalue", "serialvalue", "urlvalue", "newvalue", "bundlevalue"};
        private String value;
        private int keyIndex;
        private Object obj;

        private Attr(Object object) {
            this.obj = object;
        }

        private Attr(int n, String string) {
            this.keyIndex = n;
            this.value = string != null ? string.intern() : null;
        }

        private Attr(String string, String string2) {
            this.keyIndex = Attr.isValid(string);
            this.value = string2.intern();
        }

        static String[] getAttrTypes() {
            return ALLOWED_ATTR_KEYS;
        }

        private final void putEntry(String string, String string2) {
            this.keyIndex = Attr.isValid(string);
            this.value = string2.intern();
        }

        static Object unMarshallObjectRecursively(Object object) {
            Object object2 = object;
            while (object2 instanceof NbMarshalledObject) {
                try {
                    object2 = ((NbMarshalledObject)object2).get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    return object;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    return object;
                }
            }
            return object2 == null ? object : object2;
        }

        private void transformMe() {
            if (this.obj == null) {
                return;
            }
            Object object = Attr.unMarshallObjectRecursively(this.obj);
            if (object != null) {
                int n = Attr.distinguishObject(object);
                if (n != Attr.isValid("SERIALVALUE")) {
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[n], object.toString());
                } else {
                    String string;
                    try {
                        string = Attr.encodeValue(object);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[n], string);
                }
            }
        }

        static int distinguishObject(Object object) {
            if (object instanceof Byte) {
                return Attr.isValid("BYTEVALUE");
            }
            if (object instanceof Short) {
                return Attr.isValid("SHORTVALUE");
            }
            if (object instanceof Integer) {
                return Attr.isValid("INTVALUE");
            }
            if (object instanceof Long) {
                return Attr.isValid("LONGVALUE");
            }
            if (object instanceof Float) {
                return Attr.isValid("FLOATVALUE");
            }
            if (object instanceof Double) {
                return Attr.isValid("DOUBLEVALUE");
            }
            if (object instanceof Boolean) {
                return Attr.isValid("BOOLVALUE");
            }
            if (object instanceof Character) {
                return Attr.isValid("CHARVALUE");
            }
            if (object instanceof String) {
                return Attr.isValid("STRINGVALUE");
            }
            if (object instanceof URL) {
                return Attr.isValid("URLVALUE");
            }
            return Attr.isValid("SERIALVALUE");
        }

        static String encode(String string) {
            try {
                string = XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer(6 * string.length());
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isISOControl(string.charAt(i)) || Attr.isEncodedChar(i, string)) {
                    stringBuffer.append(Attr.encodeChar(string.charAt(i)));
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            return stringBuffer.toString();
        }

        static String encodeChar(char c) {
            String string = Integer.toString(c, 16);
            return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
        }

        static String decode(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            try {
                for (int i = 0; i < string.length(); ++i) {
                    if (Attr.isEncodedChar(i, string)) {
                        String string2 = string.substring(i + 2, i + 6);
                        stringBuffer.append((char)Integer.parseInt(string2, 16));
                        i += 5;
                        continue;
                    }
                    stringBuffer.append(string.charAt(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Exceptions.printStackTrace((Throwable)numberFormatException);
                return string;
            }
            return stringBuffer.toString();
        }

        private static boolean isEncodedChar(int n, String string) {
            boolean bl;
            boolean bl2 = bl = n + 5 < string.length();
            if (bl) {
                char c;
                bl &= string.charAt(n) == '\\' && string.charAt(n + 1) == 'u';
                for (int i = n + 2; bl && i < n + 6; bl &= Character.digit(c = string.charAt(i), 16) != -1, ++i) {
                }
            }
            return bl;
        }

        private Object get() throws Exception {
            return this.getObject(null);
        }

        private Object get(Object[] objectArray) throws Exception {
            return this.getObject(objectArray);
        }

        final String getKey() {
            String[] stringArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return "serialvalue";
            }
            if (this.isValid() == -1) {
                return "";
            }
            return stringArray[this.keyIndex];
        }

        final String getValue() {
            if (this.obj != null) {
                Attr.getValue(this.obj);
            }
            return this.value != null ? this.value : "";
        }

        static final String getValue(Object object) {
            try {
                return Attr.encodeValue(object);
            }
            catch (IOException iOException) {
                return "";
            }
        }

        final String getValueForPrint() {
            if (this.obj != null) {
                Attr attr = null;
                if (this.obj instanceof ModifiedAttribute) {
                    attr = (Attr)((ModifiedAttribute)this.obj).getValue();
                }
                return attr != null ? Attr.encode(attr.getValue()) : Attr.encode(this.getValue());
            }
            return this.value != null ? Attr.encode(this.value) : "";
        }

        final String getKeyForPrint() {
            if (this.obj != null && this.obj instanceof ModifiedAttribute) {
                Attr attr = (Attr)((ModifiedAttribute)this.obj).getValue();
                int n = Attr.isValid("SERIALVALUE");
                if (attr != null) {
                    n = Attr.distinguishObject(attr.getValue());
                }
                String[] stringArray = Attr.getAttrTypes();
                return stringArray[n];
            }
            return this.getKey();
        }

        final String getAttrNameForPrint(String string) {
            if (this.obj != null && this.obj instanceof ModifiedAttribute) {
                Object[] objectArray = ModifiedAttribute.revert(string, this.obj);
                return Attr.encode((String)objectArray[0]);
            }
            return Attr.encode(string);
        }

        final void maybeAddSerValueComment(PrintWriter printWriter, String string) {
            if (this.obj != null) {
                String string2;
                String string3 = null;
                if (this.obj instanceof ModifiedAttribute && Attr.distinguishObject(string3 = ((Attr)((ModifiedAttribute)this.obj).getValue()).getValue()) != Attr.isValid("SERIALVALUE")) {
                    return;
                }
                printWriter.print(string);
                printWriter.print("<!-- ");
                String string4 = string2 = string3 != null ? string3.toString() : this.obj.toString();
                if (string2.indexOf("--") != -1) {
                    string2 = string2.replace('-', '_');
                }
                printWriter.print(string2);
                printWriter.println(" -->");
            }
        }

        final Class<?> getType(Object[] objectArray) {
            try {
                if (this.obj != null) {
                    return this.obj.getClass();
                }
                switch (this.keyIndex) {
                    case 0: {
                        return Byte.class;
                    }
                    case 1: {
                        return Short.class;
                    }
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return Long.class;
                    }
                    case 4: {
                        return Float.class;
                    }
                    case 5: {
                        return Double.class;
                    }
                    case 6: {
                        return Boolean.class;
                    }
                    case 7: {
                        return Character.class;
                    }
                    case 8: {
                        return this.value.getClass();
                    }
                    case 9: {
                        return this.methodValue(this.value, objectArray).getMethod().getReturnType();
                    }
                    case 10: {
                        return null;
                    }
                    case 11: {
                        return URL.class;
                    }
                    case 12: {
                        return ExternalUtil.findClass(Utilities.translate((String)this.value));
                    }
                    case 13: {
                        return String.class;
                    }
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            return null;
        }

        final String getClassName() {
            if (this.obj != null) {
                Object object = null;
                if (this.obj instanceof ModifiedAttribute) {
                    object = ((Attr)((ModifiedAttribute)this.obj).getValue()).getValue();
                }
                return object != null ? object.getClass().getName() : this.obj.getClass().getName();
            }
            return null;
        }

        static Object decodeValue(String string) throws IOException {
            if (string == null || string.length() == 0) {
                return null;
            }
            byte[] byArray = new byte[string.length() / 2];
            int n = 0;
            for (int i = 0; i < string.length(); i += 2) {
                try {
                    int n2 = Integer.parseInt(string.substring(i, i + 2), 16);
                    if (n2 > 127) {
                        n2 -= 256;
                    }
                    byArray[n++] = (byte)n2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw (IOException)ExternalUtil.copyAnnotation(new IOException(), numberFormatException);
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            try {
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)byteArrayInputStream);
                Object object = nbObjectInputStream.readObject();
                return object;
            }
            catch (Exception exception) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), exception);
            }
        }

        static String encodeValue(Object object) throws IOException {
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object2 = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object2).writeObject(object);
                ((ObjectOutputStream)object2).close();
            }
            catch (Exception exception) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), exception);
            }
            object2 = byteArrayOutputStream.toByteArray();
            StringBuffer stringBuffer = new StringBuffer(((Object)object2).length * 2);
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (object2[i] < 16 && object2[i] >= 0) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString((int)(object2[i] < 0 ? object2[i] + 256 : object2[i])));
            }
            return stringBuffer.toString();
        }

        private Object getObject(Object[] objectArray) throws Exception {
            if (this.obj != null) {
                return this.obj;
            }
            int n = this.isValid();
            if (n != -1) {
                try {
                    switch (n) {
                        case 0: {
                            return new Byte(this.value);
                        }
                        case 1: {
                            return new Short(this.value);
                        }
                        case 2: {
                            return new Integer(this.value);
                        }
                        case 3: {
                            return new Long(this.value);
                        }
                        case 4: {
                            return new Float(this.value);
                        }
                        case 5: {
                            return new Double(this.value);
                        }
                        case 6: {
                            return Boolean.valueOf(this.value);
                        }
                        case 7: {
                            if (this.value.trim().length() != 1) break;
                            return new Character(this.value.charAt(0));
                        }
                        case 8: {
                            return this.value;
                        }
                        case 9: {
                            return this.methodValue(this.value, objectArray).invoke();
                        }
                        case 10: {
                            return Attr.decodeValue(this.value);
                        }
                        case 11: {
                            return new URL(this.value);
                        }
                        case 12: {
                            Class clazz = ExternalUtil.findClass(Utilities.translate((String)this.value));
                            if (SharedClassObject.class.isAssignableFrom(clazz)) {
                                return SharedClassObject.findObject((Class)clazz, (boolean)true);
                            }
                            return clazz.newInstance();
                        }
                        case 13: {
                            String[] stringArray = this.value.split("#", 2);
                            return NbBundle.getBundle((String)stringArray[0]).getObject(stringArray[1]);
                        }
                    }
                }
                catch (Exception exception) {
                    ExternalUtil.annotate((Throwable)exception, "value = " + this.value);
                    throw exception;
                }
                catch (LinkageError linkageError) {
                    throw (ClassNotFoundException)ExternalUtil.annotate((Throwable)new ClassNotFoundException(this.value), linkageError);
                }
            }
            throw new InstantiationException(this.value);
        }

        private final MethodAndParams methodValue(String string, Object[] objectArray) throws Exception {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                Class[][] classArrayArray;
                String string2 = string.substring(n + 1);
                Class clazz = ExternalUtil.findClass(string.substring(0, n));
                FileObject fileObject = null;
                String string3 = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (fileObject == null && objectArray[i] instanceof FileObject) {
                        fileObject = (FileObject)objectArray[i];
                    }
                    if (string3 != null || !(objectArray[i] instanceof String)) continue;
                    string3 = (String)objectArray[i];
                }
                for (Class[] classArray : classArrayArray = new Class[][]{{FileObject.class, String.class}, {String.class, FileObject.class}, {FileObject.class}, {String.class}, new Class[0], {Map.class, String.class}, {Map.class}}) {
                    Method method;
                    try {
                        method = clazz.getDeclaredMethod(string2, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                    Object[] objectArray2 = new Object[classArray.length];
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i] == FileObject.class) {
                            objectArray2[i] = fileObject;
                            continue;
                        }
                        if (classArray[i] == String.class) {
                            objectArray2[i] = string3;
                            continue;
                        }
                        assert (classArray[i] == Map.class);
                        objectArray2[i] = Attr.wrapToMap(fileObject);
                    }
                    return new MethodAndParams(method, objectArray2);
                }
            }
            throw new InstantiationException(string);
        }

        static final Map wrapToMap(FileObject fileObject) {
            return fileObject == null ? Collections.EMPTY_MAP : new FileMap(fileObject);
        }

        final int isValid() {
            String[] stringArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return Attr.isValid("SERIALVALUE");
            }
            if (this.keyIndex >= stringArray.length || this.keyIndex < 0) {
                return -1;
            }
            return this.keyIndex;
        }

        static final int isValid(String string) {
            int n = -1;
            String[] stringArray = Attr.getAttrTypes();
            String string2 = string.trim();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                n = i;
                break;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Attr) {
                Attr attr = (Attr)object;
                if (attr.keyIndex != this.keyIndex) {
                    return false;
                }
                return attr.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return 743 + this.keyIndex << 8 + this.value.hashCode();
        }

        private static class MethodAndParams {
            private Method method;
            private Object[] params;

            MethodAndParams(Method method, Object[] objectArray) {
                this.method = method;
                this.params = objectArray;
            }

            public Object invoke() throws Exception {
                this.method.setAccessible(true);
                return this.method.invoke(null, this.params);
            }

            public Method getMethod() {
                return this.method;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AttrFileSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private FileObject fo;

        private AttrFileSet(FileObject fileObject) {
            this.fo = fileObject;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Iter
            implements Iterator<Map.Entry<String, Object>> {
                Enumeration<String> attrs;

                Iter() {
                    this.attrs = AttrFileSet.this.fo.getAttributes();
                }

                @Override
                public boolean hasNext() {
                    return this.attrs.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String string = this.attrs.nextElement();
                    return new FOEntry(AttrFileSet.this.fo, string);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new Iter();
        }

        @Override
        public int size() {
            Enumeration<String> enumeration = this.fo.getAttributes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
            return n;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FOEntry
    implements Map.Entry<String, Object> {
        private FileObject fo;
        private String attr;

        private FOEntry(FileObject fileObject, String string) {
            this.fo = fileObject;
            this.attr = string;
        }

        @Override
        public String getKey() {
            return this.attr;
        }

        @Override
        public Object getValue() {
            return this.fo.getAttribute(this.attr);
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileMap
    extends AbstractMap<String, Object> {
        private FileObject fo;

        private FileMap(FileObject fileObject) {
            this.fo = fileObject;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AttrFileSet(this.fo);
        }

        public Object get(String string) {
            return this.fo.getAttribute(string);
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String string, Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static class ModifiedAttribute
    implements Serializable {
        static final long serialVersionUID = 84214031923497718L;
        private static final String[] fragments = new String[]{"transient:"};
        private int modifier = 0;
        private Object origAttrValue = null;

        private ModifiedAttribute(Object object) {
            this.origAttrValue = object;
        }

        static Object[] translateInto(String string, Object object) {
            String string2 = string;
            Object object2 = object;
            ModifiedAttribute modifiedAttribute = null;
            for (int i = 0; i < fragments.length; ++i) {
                String string3 = fragments[i];
                int n = string2.indexOf(string3);
                if (n == -1) continue;
                string2 = string2.substring(0, n) + string2.substring(n + string3.length());
                if (modifiedAttribute == null) {
                    modifiedAttribute = new ModifiedAttribute(object);
                    object2 = modifiedAttribute;
                }
                modifiedAttribute.modifier |= 1 << i;
            }
            return new Object[]{string2, object2};
        }

        static Object[] revert(String string, Object object) {
            if (!(object instanceof ModifiedAttribute) || object == null) {
                return new Object[]{string, object};
            }
            ModifiedAttribute modifiedAttribute = (ModifiedAttribute)object;
            String string2 = string;
            Object object2 = modifiedAttribute;
            for (int i = 0; i < fragments.length; ++i) {
                String string3 = fragments[i];
                if ((modifiedAttribute.modifier & 1 << i) == 0 || string3 == null) continue;
                string2 = string3 + string2;
                if (!(object2 instanceof ModifiedAttribute)) continue;
                object2 = modifiedAttribute.origAttrValue;
            }
            return new Object[]{string2, object2};
        }

        Object getValue(String string) {
            for (int i = 0; i < fragments.length; ++i) {
                String string2 = fragments[i];
                int n = string.indexOf(string2);
                if (n == -1) continue;
                return this;
            }
            return this.origAttrValue;
        }

        Object getValue() {
            return this.getValue("");
        }

        static boolean isTransient(FileObject fileObject, String string) {
            Object object = fileObject.getAttribute(fragments[0] + string);
            if (object instanceof ModifiedAttribute) {
                return (((ModifiedAttribute)object).modifier & 1) != 0;
            }
            return false;
        }
    }
}

