/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import org.openide.util.NbBundle;
import tr.model.DataUpgrade0to1;
import tr.model.DataUpgrade1to2;
import tr.model.DataUpgrade2to3;
import tr.model.DataUpgrade3to4;
import tr.model.IDGenerator;
import tr.model.action.Action;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.project.ProjectFutures;
import tr.model.project.ProjectProjects;
import tr.model.project.ProjectRoot;
import tr.model.project.ProjectSingleActions;
import tr.model.project.ProjectTemplates;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data
extends ObservableImpl
implements IDGenerator,
Observer {
    public static final int CURRENT_VERSION = 4;
    int version = 4;
    private int maxID = 100;
    private Manager<Topic> topics = new Manager();
    private Manager<Context> contexts;
    private Manager<Information> information;
    private Manager<Future> futures;
    private Manager<Thought> thoughts;
    private Manager<Action> actions;
    private Project rootProject;
    private Project rootActions;
    private Project rootTemplates;
    private Project rootFutures;
    private Criterion timeCriterion;
    private Criterion energyCriterion;
    private Criterion priorityCriterion;
    private long maxLogID = 0L;
    private transient ProjectRoot root;
    private transient boolean changed;

    public Data() {
        this.topics.add(Topic.getDefault());
        this.contexts = new Manager();
        this.contexts.add(Context.getDefault());
        this.thoughts = new Manager();
        this.futures = new Manager();
        this.information = new Manager();
        this.rootProject = new ProjectProjects();
        this.rootActions = new ProjectSingleActions();
        this.rootTemplates = new ProjectTemplates();
        this.rootFutures = new ProjectFutures();
        this.resetObservers();
    }

    public final void resetObservers() {
        this.thoughts.addObserver(this);
        this.thoughts.resetObservers();
        this.futures.addObserver(this);
        this.futures.resetObservers();
        this.information.addObserver(this);
        this.information.resetObservers();
        this.topics.addObserver(this);
        this.topics.resetObservers();
        this.contexts.addObserver(this);
        this.contexts.resetObservers();
        this.getTimeCriterion();
        this.timeCriterion.addObserver(this);
        this.timeCriterion.resetObservers();
        this.getEnergyCriterion();
        this.energyCriterion.addObserver(this);
        this.energyCriterion.resetObservers();
        this.getPriorityCriterion();
        this.priorityCriterion.addObserver(this);
        this.priorityCriterion.resetObservers();
        this.getRootAll().addObserver(this);
        this.getRootAll().resetObservers();
        this.getRootFutures().addObserver(this);
        this.getRootFutures().resetObservers();
        this.getRootTemplates().addObserver(this);
        this.getRootTemplates().resetObservers();
    }

    @Override
    public final synchronized int getNextID() {
        return ++this.maxID;
    }

    public final synchronized long getNextLogID() {
        return ++this.maxLogID;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void checkVersion() {
        if (this.version == 4) {
            return;
        }
        if (this.version == 0) {
            DataUpgrade0to1.process(this);
        }
        if (this.version == 1) {
            DataUpgrade1to2.process(this);
        }
        if (this.version == 2) {
            DataUpgrade2to3.process(this);
        }
        if (this.version == 3) {
            DataUpgrade3to4.process(this);
        }
    }

    public final Manager<Thought> getThoughtManager() {
        return this.thoughts;
    }

    public final Manager<Topic> getTopicManager() {
        return this.topics;
    }

    public final Manager<Context> getContextManager() {
        return this.contexts;
    }

    public final Manager<Information> getInformationManager() {
        return this.information;
    }

    public final Manager<Future> getFutureManager() {
        return this.futures;
    }

    public final Criterion getTimeCriterion() {
        if (this.timeCriterion == null) {
            Data idGenerator = this;
            this.timeCriterion = new Criterion("Time");
            this.timeCriterion.setUse(false);
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"5_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"10_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"15_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"20_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"30_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"45_min"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"1_hr"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"1.5_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"2_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"2.5_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"3_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"4_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"5_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"6_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"7_hrs"), idGenerator));
            this.timeCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"8_hrs"), idGenerator));
        }
        this.timeCriterion.key = "time";
        return this.timeCriterion;
    }

    public final Criterion getEnergyCriterion() {
        if (this.energyCriterion == null) {
            Data idGenerator = this;
            this.energyCriterion = new Criterion("Energy");
            this.energyCriterion.setUse(false);
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"None"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Low_Mental"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Med_Mental"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"High_Mental"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Low_Physical"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Med_Physical"), idGenerator));
            this.energyCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"High_Physical"), idGenerator));
        }
        this.energyCriterion.key = "energy";
        return this.energyCriterion;
    }

    public final Criterion getPriorityCriterion() {
        if (this.priorityCriterion == null) {
            Data idGenerator = this;
            this.priorityCriterion = new Criterion("Priority");
            this.priorityCriterion.setUse(false);
            this.priorityCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Must"), idGenerator));
            this.priorityCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Should"), idGenerator));
            this.priorityCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Would"), idGenerator));
            this.priorityCriterion.values.add(new Value(NbBundle.getMessage(Data.class, (String)"Could"), idGenerator));
        }
        this.priorityCriterion.key = "priority";
        return this.priorityCriterion;
    }

    public final Project getRootTemplates() {
        if (this.rootTemplates == null) {
            this.rootTemplates = new ProjectTemplates();
        }
        return this.rootTemplates;
    }

    public final Project getRootFutures() {
        if (this.rootFutures == null) {
            this.rootFutures = new ProjectFutures();
        }
        return this.rootFutures;
    }

    public final Project getRootProjects() {
        if (this.rootProject == null) {
            this.rootProject = new ProjectProjects();
        } else if (!(this.rootProject instanceof ProjectProjects)) {
            this.rootProject = new ProjectProjects(this.rootProject);
        }
        return this.rootProject;
    }

    public final ProjectSingleActions getRootActions() {
        if (this.rootActions == null) {
            this.rootActions = new ProjectSingleActions();
            if (this.actions != null) {
                for (Action action : this.actions.list()) {
                    this.rootActions.add(action);
                }
                this.actions = null;
            }
        }
        return (ProjectSingleActions)this.rootActions;
    }

    public final ProjectRoot getRootAll() {
        if (this.root == null) {
            this.root = new ProjectRoot((ProjectProjects)this.getRootProjects(), this.getRootActions());
        }
        return this.root;
    }

    public final void setChanged(boolean changed) {
        if (this.changed != changed) {
            this.changed = changed;
            this.notifyObservers((Observable)this);
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    public final void update(Observable observable, Object argument) {
        this.changed = true;
        this.notifyObservers(observable, argument);
    }
}

