/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.reports.reference;

import au.com.trgtd.tr.reports.reference.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.view.JasperViewer;
import tr.extract.Extract;
import tr.extract.ExtractReferences;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamTopic;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private ParamTopic paramTopic;
    private ParamBoolean paramGroup;
    private ParamBoolean paramNotes;

    public String getID() {
        return "report-reference";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        this.paramTopic = new ParamTopic("topic", this.getString("param-topic"), Extract.FormatType.XML);
        this.paramGroup = new ParamBoolean("group", this.getString("param-group"));
        this.paramNotes = new ParamBoolean("notes", this.getString("param-notes"));
        Vector<Param> params = new Vector<Param>();
        params.add((Param)this.paramTopic);
        params.add((Param)this.paramGroup);
        params.add((Param)this.paramNotes);
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> extractParams = this.getParams();
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), extractParams);
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, Object> rparams = new HashMap<String, Object>();
        rparams.put("param-notes", Boolean.parseBoolean(this.paramNotes.getValue()));
        rparams.put("param-topic", this.paramTopic.getValue());
        FileInputStream reportStream = this.paramGroup.getValue().equals("true") ? new FileInputStream(Resources.FILE_RPT_REFERENCES_GROUPED) : new FileInputStream(Resources.FILE_RPT_REFERENCES);
        File xmlfile = ReportImpl.getTmpFile((String)"References.xml");
        ExtractReferences.process((Data)data, (File)xmlfile);
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(xmlfile, "/references/reference");
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams, (JRDataSource)xmlDataSource);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }
}

