/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.BrowseFolders;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    public static final String ICON_BASE_DD_VALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    public static final String ICON_BASE_DD_INVALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    public static final String ICON_BASE_EJB_MODULE_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbModuleNodeIcon";
    public static final String ICON_BASE_ENTERPRISE_JAVA_BEANS_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbContainerNodeIcon";
    public static final String ICON_BASE_SESSION_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/SessionNodeIcon";
    public static final String ICON_BASE_ENTITY_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EntityNodeIcon";
    public static final String ICON_BASE_MESSAGE_DRIVEN_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MessageNodeIcon";
    public static final String ICON_BASE_MISC_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MiscNodeIcon";
    private static BrowseFolders.FileObjectFilter imageFileFilter = new BrowseFolders.FileObjectFilter(){

        @Override
        public boolean accept(FileObject fileObject) {
            return fileObject.getMIMEType().startsWith("image/");
        }
    };

    public static String browseIcon(EjbJarMultiViewDataObject dataObject) {
        String relativePath;
        FileObject fileObject = BrowseFolders.showDialog(dataObject.getSourceGroups(), imageFileFilter);
        if (fileObject != null) {
            FileObject projectDirectory = dataObject.getProjectDirectory();
            relativePath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)fileObject);
        } else {
            relativePath = null;
        }
        return relativePath;
    }

    public static Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        return c == null ? new Color(89, 79, 191) : c;
    }

    public static JTree findTreeComponent(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                JTree tree = Utils.findTreeComponent(components[i]);
                if (tree == null) continue;
                return tree;
            }
        }
        return null;
    }

    public static String getBundleMessage(String messageId) {
        return NbBundle.getMessage(Utils.class, (String)messageId);
    }

    public static boolean isValidPackageName(String packageName) {
        String[] strings = packageName.split("[.]");
        if (strings.length == 0) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (Utilities.isJavaIdentifier((String)strings[i])) continue;
            return false;
        }
        return packageName.charAt(packageName.length() - 1) != '.';
    }

    public static FileObject getPackageFile(ClassPath classPath, String packageName) {
        return classPath.findResource(Utils.packageToPath(packageName));
    }

    private static String packageToPath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getPackage(String ejbClass) {
        int i = ejbClass.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return ejbClass.substring(0, i);
    }

    public static void notifyError(Exception ex) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    public static FileObject getSourceFile(ClassPath classPath, String className) {
        return classPath.findResource(Utils.packageToPath(className) + ".java");
    }

    public static String getEjbDisplayName(Ejb ejb) {
        String name = ejb.getDefaultDisplayName();
        if (name == null && (name = ejb.getEjbName()) == null) {
            name = " ";
        }
        return name;
    }

    public static void openEditorFor(FileObject ejbJarFile, final String ejbClass) {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)ejbJarFile);
        if (ejbModule == null) {
            Utils.displaySourceNotFoundDialog();
            return;
        }
        MetadataModel ejbModel = ejbModule.getMetadataModel();
        try {
            FileObject classFo = (FileObject)ejbModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata metadata) throws Exception {
                    return metadata.findResource(ejbClass.replace('.', '/') + ".java");
                }
            });
            final ArrayList handle = new ArrayList(1);
            if (classFo != null) {
                JavaSource source = JavaSource.forFileObject((FileObject)classFo);
                source.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = controller.getElements().getTypeElement(ejbClass);
                        if (typeElement != null) {
                            handle.add(ElementHandle.create((Element)typeElement));
                        }
                    }
                }, false);
            }
            if (!handle.isEmpty()) {
                ElementOpen.open((FileObject)classFo, (ElementHandle)((ElementHandle)handle.get(0)));
            } else {
                Utils.displaySourceNotFoundDialog();
            }
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void displaySourceNotFoundDialog() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utils.class, (String)"MSG_sourceNotFound")));
    }

    public static void runInAwtDispatchThread(Runnable runnable) {
        org.netbeans.modules.xml.multiview.Utils.runInAwtDispatchThread((Runnable)runnable);
    }
}

