/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ExtractInterfaceRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractInterfaceRefactoring refactoring;
    private String pkgName;
    private ElementHandle<TypeElement> classHandle;

    ExtractInterfaceRefactoringPlugin(ExtractInterfaceRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getInterfaceName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equalsIgnoreCase(newName) || !"java".equalsIgnoreCase(child.getExt())) continue;
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return super.fastCheckParameters();
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        Problem result = null;
        String newName = this.refactoring.getInterfaceName();
        TypeMirror parsedType = javac.getTreeUtilities().parseType(newName, (TypeElement)this.classHandle.resolve((CompilationInfo)javac));
        if (parsedType != null && parsedType.getKind() != TypeKind.ERROR) {
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return super.fastCheckParameters(javac);
    }

    public Problem prepare(RefactoringElementsBag bag) {
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        try {
            UpdateClassTask.create(bag, primFile, this.refactoring, this.classHandle);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 1);
        javac.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle sourceType = this.refactoring.getSourceType();
            Problem result = ExtractInterfaceRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Element sourceElm = sourceType.resolveElement((CompilationInfo)javac);
            result = JavaPluginUtils.isSourceElement(sourceElm, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (sourceElm == null || sourceElm.getKind() != ElementKind.CLASS && sourceElm.getKind() != ElementKind.INTERFACE && sourceElm.getKind() != ElementKind.ENUM) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)sourceElm));
            PackageElement pkgElm = (PackageElement)javac.getElementUtilities().outermostTypeElement(sourceElm).getEnclosingElement();
            this.pkgName = pkgElm.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        Set<Modifier> mods;
        Element elm;
        if (this.refactoring.getMethods().isEmpty() && this.refactoring.getFields().isEmpty() && this.refactoring.getImplements().isEmpty()) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_MembersNotAvailable"));
        }
        javac.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        assert (sourceType != null);
        HashSet<? extends Element> members = new HashSet<Element>(sourceType.getEnclosedElements());
        for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
            elm = (ExecutableElement)elementHandle.resolve((CompilationInfo)javac);
            if (elm == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (javac.getElementUtilities().isSynthetic(elm) || elm.getKind() != ElementKind.METHOD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            if (!members.contains(elm)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            mods = elm.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC) && !mods.contains((Object)Modifier.STATIC)) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)elm.getSimpleName().toString()));
        }
        for (ElementHandle elementHandle : this.refactoring.getFields()) {
            VariableTree tree;
            elm = (VariableElement)elementHandle.resolve((CompilationInfo)javac);
            if (elm == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (javac.getElementUtilities().isSynthetic(elm) || elm.getKind() != ElementKind.FIELD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            if (!members.contains(elm)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            mods = elm.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC) && mods.contains((Object)Modifier.STATIC) && mods.contains((Object)Modifier.FINAL) && (tree = (VariableTree)javac.getTrees().getTree(elm)).getInitializer() != null) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)elm.getSimpleName().toString()));
        }
        return null;
    }

    private static List<TypeMirror> findUsedGenericTypes(ExtractInterfaceRefactoring refactoring, CompilationInfo javac, TypeElement javaClass) {
        ElementHandle<ExecutableElement> handle;
        List<TypeMirror> typeArgs = JavaRefactoringUtils.elementsToTypes(javaClass.getTypeParameters());
        if (typeArgs.isEmpty()) {
            return typeArgs;
        }
        Types typeUtils = javac.getTypes();
        Set<TypeMirror> used = Collections.newSetFromMap(new IdentityHashMap());
        Iterator<ElementHandle<ExecutableElement>> methodIter = refactoring.getMethods().iterator();
        while (methodIter.hasNext() && !typeArgs.isEmpty()) {
            handle = methodIter.next();
            ExecutableElement elm = (ExecutableElement)handle.resolve(javac);
            RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, elm.getReturnType());
            Iterator<? extends VariableElement> paramIter = elm.getParameters().iterator();
            while (paramIter.hasNext() && !typeArgs.isEmpty()) {
                VariableElement param = paramIter.next();
                RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, param.asType());
            }
        }
        Iterator<TypeMirrorHandle<TypeMirror>> it = refactoring.getImplements().iterator();
        while (it.hasNext() && !typeArgs.isEmpty()) {
            handle = it.next();
            TypeMirror implemetz = handle.resolve(javac);
            RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, implemetz);
        }
        return RefactoringUtils.filterTypes(typeArgs, used);
    }

    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractInterfaceRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractInterfaceRefactoring refactoring, ElementHandle<TypeElement> sourceType) {
            this.sourceType = sourceType;
            this.refactoring = refactoring;
        }

        public static void create(RefactoringElementsBag bag, FileObject fo, ExtractInterfaceRefactoring refactoring, ElementHandle<TypeElement> sourceType) throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            ModificationResult modification = js.runModificationTask((Task)new UpdateClassTask(refactoring, sourceType));
            List diffs = modification.getDifferences(fo);
            for (ModificationResult.Difference diff : diffs) {
                bag.add((AbstractRefactoring)refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modification));
            }
            bag.registerTransaction(JavaRefactoringPlugin.createTransaction(Collections.singletonList(modification)));
        }

        public void cancel() {
        }

        /*
         * WARNING - void declaration
         */
        public void run(WorkingCopy wc) throws Exception {
            void var11_23;
            Tree interfaceTree;
            wc.toPhase(JavaSource.Phase.RESOLVED);
            this.createCu(wc);
            TypeElement clazz = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            assert (clazz != null);
            ClassTree classTree = wc.getTrees().getTree(clazz);
            TreeMaker maker = wc.getTreeMaker();
            List<TypeMirror> typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)wc, clazz);
            if (typeParams.isEmpty()) {
                interfaceTree = maker.Identifier((CharSequence)this.refactoring.getInterfaceName());
            } else {
                ArrayList<ExpressionTree> typeParamTrees = new ArrayList<ExpressionTree>(typeParams.size());
                for (TypeMirror typeMirror : typeParams) {
                    Tree tree = maker.Type(typeMirror);
                    typeParamTrees.add((ExpressionTree)tree);
                }
                interfaceTree = maker.ParameterizedType((Tree)maker.Identifier((CharSequence)this.refactoring.getInterfaceName()), typeParamTrees);
            }
            HashSet<Tree> members2Remove = new HashSet<Tree>();
            HashSet<Tree> interfaces2Remove = new HashSet<Tree>();
            members2Remove.addAll(this.getFields2Remove((CompilationInfo)wc, this.refactoring.getFields()));
            members2Remove.addAll(this.getMethods2Remove((CompilationInfo)wc, this.refactoring.getMethods(), clazz));
            interfaces2Remove.addAll(this.getImplements2Remove((CompilationInfo)wc, this.refactoring.getImplements(), clazz));
            for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
                MethodTree tree;
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)wc);
                MethodTree mt = tree = wc.getTrees().getTree(executableElement);
                if (executableElement.getAnnotation(Override.class) != null) continue;
                TreeMaker make = wc.getTreeMaker();
                AnnotationTree ann = make.Annotation((Tree)make.Identifier((CharSequence)"Override"), Collections.emptyList());
                ModifiersTree modifiers = wc.getTreeMaker().addModifiersAnnotation(mt.getModifiers(), ann);
                wc.rewrite((Tree)mt.getModifiers(), (Tree)modifiers);
            }
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            for (Tree tree : classTree.getMembers()) {
                if (members2Remove.contains(tree)) continue;
                arrayList.add(tree);
            }
            List<Tree> list = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), interfaces2Remove, interfaceTree);
            if (clazz.getKind() == ElementKind.CLASS) {
                ClassTree classTree2 = maker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), list, arrayList);
            } else if (clazz.getKind() == ElementKind.INTERFACE) {
                ClassTree classTree3 = maker.Interface(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), list, arrayList);
            } else if (clazz.getKind() == ElementKind.ENUM) {
                ClassTree classTree4 = maker.Enum(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), list, arrayList);
            } else {
                throw new IllegalStateException(classTree.toString());
            }
            wc.rewrite((Tree)classTree, (Tree)var11_23);
        }

        private List<Tree> getFields2Remove(CompilationInfo javac, List<ElementHandle<VariableElement>> members) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(members.size());
            for (ElementHandle<VariableElement> handle : members) {
                VariableElement elm = (VariableElement)handle.resolve(javac);
                assert (elm != null);
                Tree t = javac.getTrees().getTree(elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getMethods2Remove(CompilationInfo javac, List<ElementHandle<ExecutableElement>> members, TypeElement clazz) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            boolean isInterface = clazz.getKind() == ElementKind.INTERFACE;
            ArrayList<Tree> result = new ArrayList<Tree>(members.size());
            for (ElementHandle<ExecutableElement> handle : members) {
                ExecutableElement elm = (ExecutableElement)handle.resolve(javac);
                assert (elm != null);
                if (!isInterface && !elm.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                MethodTree t = javac.getTrees().getTree(elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getImplements2Remove(CompilationInfo javac, List<TypeMirrorHandle<TypeMirror>> members, TypeElement clazz) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> memberTypes = new ArrayList<TypeMirror>(members.size());
            for (TypeMirrorHandle<TypeMirror> handle : members) {
                TypeMirror tm = handle.resolve(javac);
                memberTypes.add(tm);
            }
            ClassTree classTree = javac.getTrees().getTree(clazz);
            ArrayList<Tree> result = new ArrayList<Tree>();
            Types types = javac.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror existingTM = javac.getTrees().getTypeMirror(path);
                for (TypeMirror tm : memberTypes) {
                    if (!types.isSameType(tm, existingTM)) continue;
                    result.add(tree);
                    continue block1;
                }
            }
            return result;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> allImpls, Set<Tree> impls2Remove, Tree impl2Add) {
            ArrayList<Tree> ret;
            if (allImpls == null) {
                ret = new ArrayList<Tree>(1);
            } else {
                ret = new ArrayList(allImpls.size() + 1);
                ret.addAll(allImpls);
            }
            if (impls2Remove != null && !impls2Remove.isEmpty()) {
                ret.removeAll(impls2Remove);
            }
            ret.add(impl2Add);
            return ret;
        }

        public void createCu(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker make = wc.getTreeMaker();
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)wc);
            List<TypeMirror> typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)wc, (TypeElement)this.sourceType.resolve((CompilationInfo)wc));
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParams.size());
            TypeElement sourceTypeElm = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            for (TypeParameterElement typeParameterElement : sourceTypeElm.getTypeParameters()) {
                TypeMirror typeMirror = typeParameterElement.asType();
                for (TypeMirror newParam : typeParams) {
                    Tree t;
                    if (!wc.getTypes().isSameType(typeMirror, newParam) || (t = wc.getTrees().getTree(typeParameterElement)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    TypeParameterTree typeParamTree = (TypeParameterTree)t;
                    if (!typeParamTree.getBounds().isEmpty()) {
                        typeParamTree = (TypeParameterTree)genUtils.importFQNs(t);
                    }
                    newTypeParams.add(typeParamTree);
                }
            }
            ArrayList<Tree> members = new ArrayList<Tree>();
            for (ElementHandle<VariableElement> elementHandle : this.refactoring.getFields()) {
                VariableElement variableElement = (VariableElement)elementHandle.resolve((CompilationInfo)wc);
                VariableTree tree = (VariableTree)wc.getTrees().getTree(variableElement);
                VariableTree newVarTree = make.Variable(make.Modifiers(Collections.emptySet(), tree.getModifiers().getAnnotations()), (CharSequence)tree.getName(), tree.getType(), tree.getInitializer());
                newVarTree = (VariableTree)genUtils.importFQNs((Tree)newVarTree);
                tree = (VariableTree)genUtils.importComments((Tree)tree, wc.getTrees().getPath(variableElement).getCompilationUnit());
                genUtils.copyComments((Tree)tree, (Tree)newVarTree, false);
                genUtils.copyComments((Tree)tree, (Tree)newVarTree, true);
                members.add(newVarTree);
            }
            for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)wc);
                TreePath mpath = wc.getTrees().getPath(executableElement);
                MethodTree tree = wc.getTrees().getTree(executableElement);
                List<? extends AnnotationTree> annotations = UpdateClassTask.filterOutOverrideAnnotation(tree.getModifiers().getAnnotations(), (CompilationInfo)wc, mpath);
                MethodTree newMethodTree = make.Method(make.Modifiers(Collections.emptySet(), annotations), (CharSequence)tree.getName(), tree.getReturnType(), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), (BlockTree)null, null);
                newMethodTree = (MethodTree)genUtils.importFQNs((Tree)newMethodTree);
                tree = (MethodTree)genUtils.importComments((Tree)tree, wc.getTrees().getPath(executableElement).getCompilationUnit());
                genUtils.copyComments((Tree)tree, (Tree)newMethodTree, false);
                genUtils.copyComments((Tree)tree, (Tree)newMethodTree, true);
                members.add(newMethodTree);
            }
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            for (TypeMirrorHandle<TypeMirror> typeMirrorHandle : this.refactoring.getImplements()) {
                TypeMirror implMirror = typeMirrorHandle.resolve((CompilationInfo)wc);
                arrayList.add(make.Type(implMirror));
            }
            ClassTree classTree2 = make.Interface(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)this.refactoring.getInterfaceName(), newTypeParams, arrayList, Collections.emptyList());
            classTree2 = genUtils.insertClassMembers(classTree2, members);
            FileObject fileObject = this.refactoring.getSourceType().getFileObject();
            FileObject sourceRoot = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
            String relativePath = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)fileObject.getParent()) + "/" + this.refactoring.getInterfaceName() + ".java";
            CompilationUnitTree cu = JavaPluginUtils.createCompilationUnit(sourceRoot, relativePath, classTree2, wc, make);
            wc.rewrite(null, (Tree)cu);
        }

        private static List<? extends AnnotationTree> filterOutOverrideAnnotation(List<? extends AnnotationTree> annotations, CompilationInfo javac, TreePath pathToMethod) {
            if (annotations.isEmpty()) {
                return annotations;
            }
            ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>(annotations.size());
            TypeElement overrideAnn = javac.getElements().getTypeElement("java.lang.Override");
            for (AnnotationTree annotationTree : annotations) {
                Element annotation = javac.getTrees().getElement(new TreePath(pathToMethod, annotationTree));
                if (annotation != null && annotation == overrideAnn) continue;
                newAnnotations.add(annotationTree);
            }
            return newAnnotations;
        }
    }
}

