/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.options.InlineHintsOptionsPanelController;
import org.netbeans.modules.java.editor.options.InlineHintsSettings;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InlineHintsPanel
extends JPanel {
    public static final String JAVA_INLINE_HINT_PARAMETER_NAME = "javaInlineHintParameterName";
    public static final String JAVA_INLINE_HINT_CHAINED_TYPES = "javaInlineHintChainedTypes";
    public static final String JAVA_INLINE_HINT_VAR_TYPE = "javaInlineHintVarType";
    private static final Map<String, Boolean> DEFAULT_VALUES;
    private List<JCheckBox> parameterBoxes;
    private InlineHintsOptionsPanelController controller;
    private boolean changed = false;
    private JCheckBox javaInlineHintChainedTypesCB;
    private JCheckBox javaInlineHintParameterNameCB;
    private JCheckBox javaInlineHintVarTypeCB;
    private JCheckBox javaInlineHintsCB;

    public InlineHintsPanel(InlineHintsOptionsPanelController controller) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
    }

    public void load(InlineHintsOptionsPanelController controller) {
        this.controller = controller;
        this.javaInlineHintsCB.setSelected(InlineHintsSettings.isInlineHintsEnabled());
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.parameterBoxes) {
            box.setSelected(node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())));
        }
        this.updateCheckBoxEnabledState(null);
        this.changed = false;
    }

    public void store() {
        if (this.javaInlineHintsCB.isSelected() != InlineHintsSettings.isInlineHintsEnabled()) {
            InlineHintsSettings.setInlineHintsEnabled(this.javaInlineHintsCB.isSelected());
        }
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.parameterBoxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())))) continue;
            node.putBoolean(box.getActionCommand(), value);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changed = false;
        EditorRegistry.componentList().stream().map(jtc -> jtc.getDocument()).filter(doc -> doc != null).map(doc -> NbEditorUtilities.getFileObject((Document)doc)).filter(fo -> fo != null).forEach(fo -> IndexingManager.getDefault().refreshAllIndices(new FileObject[]{fo}));
    }

    public boolean changed() {
        return this.changed;
    }

    private void initComponents() {
        this.javaInlineHintParameterNameCB = new JCheckBox();
        this.javaInlineHintChainedTypesCB = new JCheckBox();
        this.javaInlineHintVarTypeCB = new JCheckBox();
        this.javaInlineHintsCB = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintParameterNameCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintParameterNameCB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintChainedTypesCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintChainedTypesCB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintVarTypeCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintVarTypeCB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaInlineHintsCB, (String)NbBundle.getMessage(InlineHintsPanel.class, (String)"InlineHintsPanel.javaInlineHintsCB.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaInlineHintVarTypeCB).addComponent(this.javaInlineHintChainedTypesCB).addComponent(this.javaInlineHintParameterNameCB))).addComponent(this.javaInlineHintsCB)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.javaInlineHintsCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.javaInlineHintParameterNameCB).addGap(6, 6, 6).addComponent(this.javaInlineHintChainedTypesCB).addGap(6, 6, 6).addComponent(this.javaInlineHintVarTypeCB).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void updateCheckBoxEnabledState(ActionEvent evt) {
        if (this.javaInlineHintsCB.isSelected() && this.parameterBoxes.stream().noneMatch(AbstractButton::isSelected)) {
            if (evt != null && evt.getSource() == this.javaInlineHintsCB) {
                for (JCheckBox box2 : this.parameterBoxes) {
                    box2.setSelected(DEFAULT_VALUES.get(box2.getActionCommand()));
                }
            } else {
                this.javaInlineHintsCB.setSelected(false);
            }
        }
        this.parameterBoxes.forEach(box -> box.setEnabled(this.javaInlineHintsCB.isSelected()));
    }

    private void fillBoxes() {
        this.parameterBoxes = new ArrayList<JCheckBox>();
        this.parameterBoxes.add(this.javaInlineHintParameterNameCB);
        this.parameterBoxes.add(this.javaInlineHintChainedTypesCB);
        this.parameterBoxes.add(this.javaInlineHintVarTypeCB);
        this.javaInlineHintParameterNameCB.setActionCommand(JAVA_INLINE_HINT_PARAMETER_NAME);
        this.javaInlineHintChainedTypesCB.setActionCommand(JAVA_INLINE_HINT_CHAINED_TYPES);
        this.javaInlineHintVarTypeCB.setActionCommand(JAVA_INLINE_HINT_VAR_TYPE);
    }

    private void addListeners() {
        ActionListener al = e -> this.checkBoxChanged(e);
        this.javaInlineHintsCB.addActionListener(al);
        for (JCheckBox box : this.parameterBoxes) {
            box.addActionListener(al);
        }
    }

    private void checkBoxChanged(ActionEvent evt) {
        this.updateCheckBoxEnabledState(evt);
        if (this.javaInlineHintsCB.isSelected() != InlineHintsSettings.isInlineHintsEnabled()) {
            this.changed = true;
            return;
        }
        Preferences node = InlineHintsSettings.getCurrentNode();
        for (JCheckBox box : this.parameterBoxes) {
            if (node.getBoolean(box.getActionCommand(), DEFAULT_VALUES.get(box.getActionCommand())) == box.isSelected()) continue;
            this.changed = true;
            return;
        }
        this.changed = false;
    }

    static {
        HashMap<String, Boolean> defaultValuesBuilder = new HashMap<String, Boolean>();
        defaultValuesBuilder.put(JAVA_INLINE_HINT_PARAMETER_NAME, true);
        defaultValuesBuilder.put(JAVA_INLINE_HINT_CHAINED_TYPES, false);
        defaultValuesBuilder.put(JAVA_INLINE_HINT_VAR_TYPE, false);
        DEFAULT_VALUES = Collections.unmodifiableMap(defaultValuesBuilder);
    }
}

