/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.support.api.GroovyExtender;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.groovy.support.wizard.AbstractFileWizard;
import org.netbeans.modules.groovy.support.wizard.ProjectTypeStrategy;
import org.netbeans.modules.groovy.support.wizard.impl.AntProjectTypeStrategy;
import org.netbeans.modules.groovy.support.wizard.impl.MavenProjectTypeStrategy;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public abstract class AbstractGroovyWizard
extends AbstractFileWizard {
    protected ProjectTypeStrategy strategy;

    protected AbstractGroovyWizard() {
    }

    @Override
    public void initialize(WizardDescriptor wiz) {
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.strategy = this.findCorrectStrategy();
        super.initialize(wiz);
    }

    private ProjectTypeStrategy findCorrectStrategy() {
        FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
        if (pom != null && pom.isValid()) {
            return new MavenProjectTypeStrategy(this.project);
        }
        return new AntProjectTypeStrategy(this.project);
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(AbstractGroovyWizard.class, (String)"LBL_NewGroovyFileWizardIterator_WizardProgress_CreatingFile"));
        FileObject template = this.findCorrectTemplate();
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder dFolder = DataFolder.findFolder((FileObject)targetFolder);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String pkgName = this.getPackageName(targetFolder);
        DataObject dobj = pkgName == null ? dTemplate.createFromTemplate(dFolder, targetName) : dTemplate.createFromTemplate(dFolder, targetName, Collections.singletonMap("package", pkgName));
        FileObject createdFile = dobj.getPrimaryFile();
        Project proj = Templates.getProject((WizardDescriptor)this.wiz);
        if (!GroovyExtender.isActive(proj)) {
            GroovyExtender.activate(proj);
        }
        handle.finish();
        return Collections.singleton(createdFile);
    }

    protected FileObject findCorrectTemplate() {
        return Templates.getTemplate((WizardDescriptor)this.wiz);
    }

    private String getPackageName(FileObject targetFolder) {
        List<SourceGroup> groups = this.retrieveGroups();
        String packageName = null;
        for (int i = 0; i < groups.size() && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups.get(i).getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replace("/", ".");
        }
        return packageName;
    }

    protected List<SourceGroup> retrieveGroups() {
        return GroovySources.getGroovySourceGroups(ProjectUtils.getSources((Project)this.project));
    }
}

